set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8335717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1983-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '2211440',
      2,
      0.367362,
      0,
      2,
      '3304',
      2,
      NULL,
      NULL,
      NULL,
      ' 1-24-1978',
      21.606161,
      NULL,
      2,
      3,
      6.925606,
      '10-16-1975',
      36,
      NULL,
      9,
      116.233036,
      NULL,
      ' 8- 1-1986',
      ' 8-10-1989',
      ' 5- 9-1990',
      0.644146,
      0.007832,
      NULL,
      0,
      0,
      1,
      1.218449,
      1.511017,
      1.285641,
      18.368420,
      NULL,
      NULL,
      16,
      71.628609,
      120.471055,
      11,
      24,
      0,
      2,
      1,
      0.581677,
      3,
      1.173217,
      0,
      0.093297,
      1,
      NULL,
      1,
      0.507917,
      1.589218,
      1,
      1,
      1,
      NULL,
      2,
      NULL,
      0.788746,
      1,
      1.345607,
      0.108096,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5.184371,
      0.555190,
      2.068063,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0,
      3,
      1.489799,
      NULL,
      1.274620,
      0.393502,
      1.825928,
      0,
      1,
      0.512494,
      0.770163,
      0,
      0.260614,
      0.189655,
      0,
      NULL,
      1,
      1,
      1.356982,
      0.023135,
      NULL,
      NULL,
      0.474208,
      3.268623,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720666,
      NULL,
      NULL,
      1,
      1.904919,
      NULL,
      0.639769,
      3,
      1.570469,
      2,
      NULL,
      NULL,
      0,
      1.397346,
      0.019854,
      0.965180,
      4,
      NULL,
      1.323136,
      1.479240,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281782,
      1,
      0,
      1,
      2.806367,
      1.042844,
      2,
      3,
      0.899280,
      3.060559,
      1.535980,
      2,
      1,
      1,
      9.030247,
      5.218699,
      6,
      7.599358,
      NULL,
      0,
      6,
      0,
      NULL,
      NULL,
      0,
      1,
      '10-18-2003',
      335.564819,
      ' 0-10-1983',
      614.329933,
      1.338068,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665999,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.010432,
      NULL,
      11,
      0.688774,
      0.744555,
      3.377193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.979829,
      0.579116,
      NULL,
      0,
      1.056054,
      NULL,
      NULL,
      0.442101,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577498,
      1,
      0.236985,
      NULL,
      NULL,
      1,
      3,
      11.166782,
      NULL,
      1.559383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.479858,
      NULL,
      2,
      NULL,
      8.046639,
      48,
      7,
      3.386579,
      1,
      2.464442,
      '13141',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      8,
      30.532153,
      0,
      0.789913,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.558522,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.716780,
      NULL,
      NULL,
      0.164351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.864683,
      0,
      18,
      1.822559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.068067,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.433135,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544866,
      NULL,
      NULL,
      NULL,
      0.409789,
      1,
      2.718924,
      4,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.141878,
      0.815660,
      1,
      NULL,
      1,
      1,
      1.806763,
      1,
      1.011389,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.236324,
      NULL,
      NULL,
      8.734234,
      6,
      0.115069,
      0.197056,
      0.447355,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139597,
      NULL,
      NULL,
      3,
      NULL,
      1.788145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.262650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191964,
      NULL,
      NULL,
      1.175249,
      NULL,
      NULL,
      0.595141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992869,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.252729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672663,
      NULL,
      NULL,
      2.570960,
      18,
      10.786334,
      2,
      NULL,
      NULL,
      7.518506,
      1,
      2,
      1,
      12.015514,
      0,
      2.116729,
      16.558904,
      15,
      0,
      NULL,
      NULL,
      NULL,
      1.341152,
      3.108466,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527352,
      1.722990,
      0.570318,
      0,
      1.575097,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.930079,
      NULL,
      NULL,
      2.689620,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.157353,
      NULL,
      NULL,
      0.083007,
      NULL,
      NULL,
      2.846880,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.630452,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      3.985596,
      NULL,
      NULL,
      2.280222,
      NULL,
      NULL,
      1.053117,
      NULL,
      2.071316,
      0,
      0.277013,
      2,
      1.945399,
      NULL,
      NULL,
      3.146789,
      NULL,
      NULL,
      NULL,
      85.127825,
      NULL,
      NULL,
      NULL,
      0.667560,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.838263,
      NULL,
      NULL,
      NULL,
      1.337574,
      NULL,
      NULL,
      NULL,
      1.632319,
      NULL,
      NULL,
      NULL,
      0.735078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.891853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.119295,
      1.856198,
      NULL,
      NULL,
      1.561772,
      0,
      1,
      NULL,
      NULL,
      2,
      1.179362,
      1,
      2.831389,
      NULL,
      NULL,
      0.947433,
      NULL,
      NULL,
      1.298205,
      NULL,
      NULL,
      12608,
      5.420070,
      0,
      2,
      1.288302,
      0,
      NULL,
      NULL,
      1,
      1.408001,
      0,
      1,
      NULL,
      0.473397,
      NULL,
      1.783250,
      NULL,
      1.104245,
      1.921785,
      0,
      NULL,
      NULL,
      NULL,
      0.429351,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646744,
      1.581566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143796,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.140650,
      2.270399,
      NULL,
      NULL,
      NULL,
      1.574659,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.491521,
      NULL,
      1.940814,
      NULL,
      0.974989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.943880,
      0,
      0,
      4,
      NULL,
      2.539537,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      10,
      NULL,
      NULL,
      NULL,
      2.080652,
      NULL,
      15,
      7,
      NULL,
      18,
      NULL,
      NULL,
      2,
      14,
      NULL,
      NULL,
      9,
      NULL,
      2,
      17,
      NULL,
      16,
      0,
      NULL,
      16.709397,
      NULL,
      NULL,
      2,
      6,
      NULL,
      NULL,
      17,
      NULL,
      3,
      0,
      1.361532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.692676,
      NULL,
      3.799424,
      3,
      6.147225,
      1.791382,
      NULL,
      NULL,
      89.647491,
      116,
      6.712867,
      1,
      2,
      '31040',
      '',
      NULL,
      0.928064,
      '',
      '',
      '',
      1.581901,
      '',
      '',
      '');
commit;
end;
/


