set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9505926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '4012201',
      2.080163,
      1,
      0,
      0,
      '3212',
      2.258497,
      0,
      NULL,
      NULL,
      NULL,
      87,
      NULL,
      5,
      0,
      0.096933,
      ' 5-26-1985',
      61,
      1,
      90,
      87.677724,
      2.774036,
      NULL,
      '10-20-1983',
      ' 4- 7-2003',
      1.949514,
      0.123398,
      2,
      NULL,
      0.877109,
      1.806322,
      8,
      NULL,
      1.712177,
      5,
      3,
      9.772166,
      1,
      1,
      10,
      NULL,
      13.923013,
      2.557388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      7,
      3.093411,
      1,
      0,
      1,
      5.153291,
      1,
      0,
      1,
      1.760820,
      6,
      NULL,
      0.978388,
      5,
      3,
      0.334445,
      2.436136,
      1.368412,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.332122,
      3.165487,
      5.181070,
      1.173008,
      1,
      1,
      0,
      NULL,
      3.172981,
      1.961139,
      2.429427,
      1,
      NULL,
      1.142827,
      2,
      NULL,
      0.867923,
      3,
      0,
      7,
      0,
      0.251365,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.820310,
      0.565455,
      1.419514,
      0,
      0,
      0,
      1,
      NULL,
      1.641269,
      1,
      0,
      0,
      NULL,
      1.400560,
      0.378186,
      1.633538,
      NULL,
      1.723838,
      1,
      1,
      0,
      0,
      1,
      0.118879,
      0.711851,
      4.860925,
      2,
      NULL,
      0.465937,
      NULL,
      3.939782,
      3,
      1.284298,
      1.047648,
      2,
      0,
      5,
      4.798534,
      4,
      3,
      3.610645,
      1.659308,
      1.043735,
      NULL,
      3.027254,
      ' 6-27-1981',
      95,
      ' 4-12-1981',
      3,
      0.457420,
      0,
      1,
      5.976518,
      1.210313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285518,
      1,
      1.278636,
      0,
      0.191799,
      NULL,
      1.846045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      2.463031,
      0.406427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.346470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.691559,
      1.087202,
      0,
      1,
      NULL,
      0,
      1.795668,
      3.166592,
      20,
      2.848956,
      NULL,
      NULL,
      NULL,
      NULL,
      3.795352,
      0,
      3,
      NULL,
      2.646132,
      3,
      0.479904,
      3,
      3,
      1.630022,
      3.924322,
      NULL,
      3,
      2.097530,
      2,
      3,
      NULL,
      0,
      NULL,
      8.588451,
      0.693489,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1.061775,
      NULL,
      0,
      3.428891,
      2,
      5,
      4,
      NULL,
      7,
      5,
      0,
      NULL,
      1,
      0.748670,
      2,
      18.593219,
      3.267585,
      1.804555,
      NULL,
      39,
      69,
      15.545546,
      5,
      2,
      3,
      NULL,
      '',
      NULL,
      0.690122,
      '',
      '',
      NULL,
      0.599881,
      NULL,
      '',
      '',
      2.230142,
      5,
      55,
      26.181054,
      0.722371,
      4,
      NULL,
      2.709887,
      4.854481,
      3.094700,
      3.321807,
      1.403350,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.835691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177093,
      NULL,
      NULL,
      1.804738,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.712636,
      1.589133,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.450861,
      3,
      1.955403,
      0.961766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.915237,
      0.622857,
      2,
      0,
      1.403743,
      0.437997,
      1,
      NULL,
      1,
      1,
      3.709677,
      0.976351,
      3.075357,
      1,
      1.526787,
      0,
      NULL,
      NULL,
      1.191258,
      NULL,
      NULL,
      0.442150,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.389261,
      NULL,
      NULL,
      NULL,
      1.196536,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.507618,
      0.117007,
      1,
      NULL,
      NULL,
      NULL,
      5.219881,
      1,
      0.564483,
      0,
      0.787705,
      1.604376,
      NULL,
      NULL,
      7.827300,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.139628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.316210,
      NULL,
      NULL,
      0.291967,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.178138,
      NULL,
      1.859055,
      0.088987,
      NULL,
      NULL,
      NULL,
      0.050160,
      1.903426,
      7.818163,
      4,
      0,
      0.762956,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.289102,
      1.830289,
      1.244984,
      NULL,
      NULL,
      NULL,
      4.834595,
      NULL,
      1.920775,
      1.840115,
      0.322104,
      1,
      2.839288,
      0.561953,
      NULL,
      2,
      0,
      1.436575,
      2.515293,
      1,
      0.408735,
      2.827706,
      NULL,
      NULL,
      3.640492,
      0.830301,
      0,
      1,
      NULL,
      4.131345,
      1.907062,
      1,
      1.971679,
      0.967097,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.477596,
      1,
      1,
      0,
      NULL,
      NULL,
      0.290236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.097153,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.371652,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.047547,
      NULL,
      NULL,
      NULL,
      0.205198,
      22,
      24,
      NULL,
      NULL,
      NULL,
      1.832613,
      NULL,
      NULL,
      1,
      2.094744,
      1.377731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      41,
      NULL,
      1,
      NULL,
      0,
      1.617469,
      NULL,
      NULL,
      1.602528,
      1,
      0.539125,
      1,
      0.644722,
      0.171888,
      1.628803,
      0,
      0.653969,
      1,
      1.165147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.097522,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0,
      2.667196,
      7.862993,
      NULL,
      NULL,
      3.367701,
      1,
      0.964018,
      0,
      1,
      1.689169,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      0,
      1.753645,
      0,
      NULL,
      1.789672,
      0.906904,
      NULL,
      1.670650,
      1,
      0.185502,
      1.670709,
      1.391582,
      0.123528,
      NULL,
      2,
      0.147403,
      0,
      3.243440,
      0.506146,
      1,
      0,
      1.924171,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.015874,
      NULL,
      1,
      0.494299,
      0.777536,
      4,
      0.960744,
      0,
      NULL,
      NULL,
      33,
      49.664700,
      5.177447,
      NULL,
      1,
      NULL,
      '',
      '',
      1.602663,
      '',
      '',
      '',
      0.043855,
      NULL,
      '',
      '');
commit;
end;
/


