set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8731046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      1.898875,
      1,
      NULL,
      1,
      '4421',
      0.188722,
      1,
      NULL,
      NULL,
      ' 5-26-1979',
      21.321576,
      NULL,
      NULL,
      0,
      1.103102,
      ' 7- 9-1996',
      15.092368,
      3,
      26.037660,
      78.681083,
      NULL,
      NULL,
      NULL,
      NULL,
      2.130132,
      NULL,
      NULL,
      2.726408,
      0.142095,
      NULL,
      NULL,
      0,
      0.009129,
      2.466349,
      7.005815,
      16.169813,
      4.472916,
      33.007213,
      28.379072,
      7.590347,
      21.681987,
      4.392490,
      0,
      3,
      0,
      0.223918,
      1.159719,
      0,
      1,
      0.290073,
      NULL,
      NULL,
      0,
      0.399719,
      0.112090,
      1.061477,
      3,
      0,
      2.707700,
      3,
      NULL,
      1.563074,
      1.782433,
      NULL,
      2.032056,
      2,
      NULL,
      0,
      0.539432,
      0.041774,
      NULL,
      4.777410,
      1,
      2.763765,
      1,
      0.637574,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.083152,
      1.252788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      4,
      1,
      0,
      1.038000,
      1.046839,
      0.117955,
      NULL,
      0,
      1.525099,
      1.380791,
      1.385348,
      1,
      1.957774,
      0.634295,
      0.282036,
      NULL,
      1.414113,
      2,
      1.295282,
      0.929758,
      NULL,
      1,
      6.070570,
      NULL,
      5,
      0,
      1,
      5.772357,
      3.112704,
      6,
      0.697333,
      2,
      7.513745,
      0.613284,
      2,
      6.312773,
      0.691571,
      1,
      0.783361,
      NULL,
      0,
      0,
      3,
      0.129996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.345871,
      0,
      3,
      1,
      1.775872,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.299718,
      NULL,
      1.289337,
      3,
      NULL,
      1,
      1.323599,
      2,
      NULL,
      4,
      1.979964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216937,
      NULL,
      4.399351,
      7,
      4,
      NULL,
      0.389204,
      NULL,
      NULL,
      NULL,
      1,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.532075,
      1.767141,
      1.893609,
      2.416692,
      0,
      1,
      0.204636,
      2.667016,
      40.258541,
      1.191350,
      0,
      NULL,
      NULL,
      NULL,
      2.080614,
      NULL,
      0.343899,
      NULL,
      0.503853,
      NULL,
      NULL,
      2.295288,
      NULL,
      1.419562,
      1.666551,
      1.362219,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      1.869452,
      NULL,
      1.630020,
      1.439854,
      1.411223,
      1.894209,
      0.464984,
      1.912549,
      1.623454,
      NULL,
      0.101520,
      1,
      NULL,
      0.644838,
      1,
      3,
      5,
      9.886191,
      8.950400,
      6,
      NULL,
      3.413768,
      2.946544,
      NULL,
      3.804658,
      2,
      NULL,
      2.140397,
      NULL,
      NULL,
      45,
      67,
      64,
      1.499222,
      1.228791,
      3,
      '11431',
      '',
      '',
      NULL,
      '30104',
      NULL,
      '',
      0.223685,
      '',
      '',
      '',
      2.926737,
      28.808450,
      24.469592,
      NULL,
      0,
      NULL,
      4.967857,
      2.656214,
      2.625082,
      0.179850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658036,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.531947,
      3.598233,
      1.937659,
      1.618738,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      1.793680,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693560,
      NULL,
      NULL,
      NULL,
      1.805861,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.504867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436857,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.342179,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      5,
      1.220966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860849,
      NULL,
      NULL,
      0.102724,
      NULL,
      NULL,
      1.070794,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.207493,
      NULL,
      NULL,
      0.057670,
      NULL,
      NULL,
      2.222725,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.819966,
      3.211227,
      6,
      0,
      4.706087,
      3,
      0.808731,
      7,
      5.052345,
      2,
      3,
      0,
      2,
      3,
      1,
      3.887568,
      3.158362,
      3.365895,
      2,
      2.917715,
      5,
      2.615875,
      0.052913,
      3.855517,
      2.264073,
      3,
      2.301327,
      1.085287,
      0,
      0.603950,
      0.163936,
      2,
      1.174929,
      1,
      NULL,
      NULL,
      4,
      4.880530,
      3.635560,
      1,
      NULL,
      NULL,
      0.105993,
      0.933555,
      0,
      0.796246,
      0,
      0.046626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363612,
      1.664655,
      0.662025,
      1,
      0.554021,
      1.638245,
      1.018211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459904,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.199994,
      17,
      0,
      0.008948,
      NULL,
      NULL,
      1,
      15.491232,
      7,
      1.627609,
      NULL,
      NULL,
      1.162584,
      1.012503,
      1,
      1,
      NULL,
      0,
      12103,
      0,
      1.403489,
      1,
      NULL,
      1,
      1,
      1.852000,
      1.372508,
      0,
      0.985234,
      1.704819,
      0.151525,
      1,
      NULL,
      1,
      1.808538,
      0.648158,
      1.264538,
      1.995276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.446305,
      0.254251,
      5,
      4,
      0,
      1.142291,
      NULL,
      12.182261,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.907606,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.337094,
      NULL,
      NULL,
      3.354172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.052404,
      NULL,
      2.013264,
      NULL,
      2,
      NULL,
      0.214118,
      NULL,
      3,
      NULL,
      0.285940,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.137903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.584576,
      NULL,
      25,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.834552,
      NULL,
      3,
      0,
      NULL,
      NULL,
      55,
      100,
      0.031447,
      0,
      NULL,
      '12304',
      NULL,
      '',
      2,
      '00211',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


