set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8020079';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      3,
      0.171373,
      3,
      0,
      '1313',
      2,
      1,
      NULL,
      NULL,
      ' 9-28-1991',
      3.803215,
      NULL,
      5,
      3.108352,
      1,
      ' 6-14-1974',
      NULL,
      0,
      NULL,
      118,
      3.878198,
      ' 4-11-1987',
      ' 1-17-1981',
      ' 6- 4-1984',
      1.291085,
      0.600936,
      2,
      0,
      0,
      0.061331,
      3.856135,
      1,
      0.346515,
      NULL,
      2,
      1.981046,
      13,
      187.432998,
      NULL,
      2.351856,
      22,
      2.224045,
      NULL,
      1.811852,
      0,
      0,
      1,
      1.574428,
      0.304347,
      0,
      1,
      0,
      1,
      1.951453,
      0.063955,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      1.346954,
      7,
      7,
      NULL,
      1.277565,
      NULL,
      3.909274,
      0.726340,
      2.530735,
      0.174978,
      2.457459,
      NULL,
      3.171348,
      0,
      NULL,
      NULL,
      0.003769,
      NULL,
      NULL,
      NULL,
      1,
      0.351205,
      3.757804,
      0,
      NULL,
      0,
      0,
      1.886557,
      0,
      1,
      0.796977,
      1.901945,
      1.649459,
      NULL,
      1.219450,
      0.408438,
      1,
      0.916834,
      2,
      0,
      2,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      NULL,
      5.859526,
      2,
      2,
      1,
      1.153008,
      4,
      1.047647,
      1.837645,
      1,
      NULL,
      1.989620,
      1,
      NULL,
      1.698791,
      0,
      NULL,
      0.948154,
      NULL,
      NULL,
      1,
      0,
      0.596672,
      5,
      NULL,
      1.692291,
      NULL,
      8,
      1.714376,
      7.310844,
      4,
      3.384249,
      0,
      5,
      0.426308,
      NULL,
      NULL,
      1.526735,
      2.229528,
      10,
      6.297323,
      3.147123,
      1.894002,
      NULL,
      0.693344,
      NULL,
      367,
      NULL,
      324,
      1,
      0.311283,
      0,
      2.161734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.854351,
      NULL,
      NULL,
      NULL,
      0.704130,
      0,
      1.685487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      1,
      5.499595,
      1,
      NULL,
      NULL,
      NULL,
      0.720437,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.494965,
      0.704121,
      2,
      0.756634,
      0.344396,
      1,
      2.394523,
      15,
      1.444792,
      0.333125,
      NULL,
      NULL,
      NULL,
      0.751637,
      0,
      1.101117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.397077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.183185,
      5,
      5,
      8.610232,
      5,
      5,
      4.504542,
      3,
      4,
      2.387670,
      2.324653,
      0,
      NULL,
      2,
      0.915979,
      NULL,
      6,
      41,
      5,
      3.924675,
      1,
      0,
      '03404',
      '',
      NULL,
      1.215816,
      NULL,
      '',
      '',
      1.980723,
      NULL,
      '',
      '',
      1.926079,
      46.344407,
      16,
      NULL,
      3.083925,
      40.595517,
      17.673751,
      NULL,
      2,
      1.866231,
      2.427697,
      0.886950,
      0.221033,
      NULL,
      NULL,
      0.422058,
      NULL,
      NULL,
      0.158672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.393626,
      1,
      0,
      1.919708,
      NULL,
      3.242811,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693632,
      NULL,
      NULL,
      3.586948,
      2.967472,
      1,
      1.136973,
      NULL,
      NULL,
      1,
      NULL,
      0.012415,
      1,
      1.096797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      16.504291,
      NULL,
      3.459381,
      5,
      2,
      9.270196,
      NULL,
      NULL,
      0.516909,
      1,
      1.598117,
      0,
      0,
      NULL,
      0.647802,
      NULL,
      0.931882,
      1,
      0,
      NULL,
      1.776466,
      0,
      0.869634,
      NULL,
      1,
      1,
      NULL,
      1.133244,
      NULL,
      NULL,
      1.981698,
      NULL,
      NULL,
      4.343752,
      2.842069,
      5.550629,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.115580,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.533428,
      3.678626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      4.295572,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.183582,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.722674,
      NULL,
      NULL,
      1,
      1,
      0,
      2.927927,
      0,
      0,
      5.110547,
      3,
      NULL,
      2.283912,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.851635,
      1,
      1.096349,
      NULL,
      0,
      2.551346,
      0.582972,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      1.784516,
      NULL,
      NULL,
      NULL,
      0.284135,
      1.517583,
      2.093353,
      2.341765,
      1.703979,
      0.230451,
      3,
      2,
      5.454994,
      8.112908,
      NULL,
      NULL,
      NULL,
      0.039035,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151266,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518724,
      NULL,
      NULL,
      1,
      0.436873,
      NULL,
      1,
      1.983938,
      3.232940,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686910,
      NULL,
      NULL,
      NULL,
      0.429413,
      NULL,
      NULL,
      NULL,
      3.564319,
      NULL,
      NULL,
      NULL,
      1.804964,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.547279,
      NULL,
      NULL,
      NULL,
      1.333719,
      NULL,
      NULL,
      NULL,
      3.564550,
      54.028147,
      1522.114792,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1275,
      363.823684,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      8835,
      77.191937,
      1.508170,
      1.266543,
      1,
      1,
      1,
      0.396727,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.301737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.297494,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301909,
      2.301997,
      NULL,
      0.931808,
      NULL,
      1.996216,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.491540,
      1.887589,
      NULL,
      NULL,
      NULL,
      1.438154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997594,
      NULL,
      0.380498,
      NULL,
      1,
      0,
      1.371005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.598619,
      0.104440,
      NULL,
      1.136412,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      1.052582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.828812,
      1.147297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.467811,
      4,
      1.694878,
      8,
      NULL,
      0.259455,
      NULL,
      NULL,
      NULL,
      2,
      3.277540,
      1.941229,
      1,
      0,
      NULL,
      1.901999,
      0,
      NULL,
      0,
      1.326964,
      NULL,
      NULL,
      0,
      NULL,
      0.095056,
      1.400052,
      NULL,
      1,
      1.796557,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0.669891,
      1.040382,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      4,
      10,
      14,
      NULL,
      1.521703,
      NULL,
      61,
      43,
      4,
      0,
      2.779491,
      NULL,
      '',
      '',
      0.870972,
      NULL,
      '',
      '',
      1.083950,
      '',
      '',
      '');
commit;
end;
/


