set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027574';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0222214',
      0,
      1.744769,
      5,
      NULL,
      '2314',
      3.216353,
      1,
      NULL,
      NULL,
      ' 2-27-2001',
      11.722712,
      NULL,
      7,
      1,
      NULL,
      '11-18-2000',
      17,
      1,
      NULL,
      82.625744,
      NULL,
      ' 1-25-1996',
      ' 6-20-1978',
      ' 0- 8-1997',
      2.728967,
      NULL,
      1,
      NULL,
      0.720228,
      NULL,
      1.892244,
      0.651204,
      0.229329,
      2,
      5,
      NULL,
      5.927131,
      24.858119,
      NULL,
      4.958965,
      11.599140,
      NULL,
      3.273286,
      9,
      0.351959,
      NULL,
      0,
      NULL,
      1,
      0.053604,
      0.222540,
      3.595445,
      1,
      NULL,
      1.612181,
      NULL,
      2,
      5.430455,
      3.583025,
      NULL,
      0.784864,
      2,
      0,
      3,
      2.082645,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.629280,
      1.446810,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.053888,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593324,
      1,
      0.941395,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888973,
      3.566441,
      4,
      4.961211,
      3,
      1,
      4,
      0.079428,
      NULL,
      NULL,
      3.104425,
      1.230291,
      0,
      4.028120,
      1.702815,
      0.857203,
      0,
      1.710473,
      NULL,
      NULL,
      NULL,
      6,
      5,
      0,
      0.725417,
      1,
      2.043780,
      2.779421,
      4,
      3,
      7,
      5,
      NULL,
      5,
      5.549349,
      4.187389,
      9,
      7,
      2.634883,
      NULL,
      NULL,
      3,
      6.339569,
      NULL,
      NULL,
      5.583113,
      0,
      1.234226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.019078,
      1,
      3,
      1.577597,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.560172,
      1,
      0,
      NULL,
      2.495919,
      NULL,
      1.034383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.800450,
      0.029611,
      1,
      1.672270,
      4,
      1,
      0.825966,
      NULL,
      NULL,
      NULL,
      1.950650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349410,
      1,
      NULL,
      0,
      0,
      0,
      2,
      42.277056,
      0.886632,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.178744,
      1,
      0.774987,
      3,
      1,
      1,
      3,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      0.223530,
      NULL,
      3.714264,
      1.463320,
      NULL,
      1,
      1.224355,
      0,
      NULL,
      0.244326,
      0,
      0,
      NULL,
      2,
      0.634171,
      NULL,
      NULL,
      1.948905,
      1.525316,
      NULL,
      NULL,
      3,
      3,
      7,
      2.298146,
      3,
      1,
      0,
      2.748818,
      2.370035,
      NULL,
      4.078876,
      60.459753,
      NULL,
      NULL,
      1.079442,
      1,
      '',
      '',
      '',
      2.355430,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      3,
      7.258923,
      27.702940,
      28.570917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578104,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939710,
      NULL,
      NULL,
      1.806580,
      NULL,
      NULL,
      1.448912,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.529330,
      NULL,
      NULL,
      1.311362,
      NULL,
      NULL,
      0.381142,
      NULL,
      NULL,
      0.526134,
      NULL,
      NULL,
      0.154555,
      NULL,
      NULL,
      2.754879,
      0,
      2.015771,
      1.166651,
      1,
      NULL,
      NULL,
      NULL,
      1.713162,
      NULL,
      NULL,
      NULL,
      1.024519,
      NULL,
      NULL,
      1.674599,
      NULL,
      NULL,
      1.122365,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.008225,
      NULL,
      NULL,
      1.657075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418563,
      NULL,
      NULL,
      2.672902,
      NULL,
      1.311920,
      2,
      1,
      1.640862,
      2.957655,
      2.823244,
      3,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327166,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.568392,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0.952482,
      0.762033,
      3,
      1.756303,
      0,
      2,
      NULL,
      6.626649,
      7,
      NULL,
      1.012335,
      NULL,
      NULL,
      3.398246,
      3.350658,
      1.942158,
      3,
      1,
      2.454891,
      2,
      NULL,
      3.694453,
      1.390860,
      0,
      NULL,
      0,
      2,
      3,
      3,
      2.017244,
      2.777178,
      NULL,
      1,
      0,
      3,
      2,
      NULL,
      10.860993,
      2,
      NULL,
      5.140593,
      0,
      4.094593,
      0.669811,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.491794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.184015,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.574310,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.960011,
      NULL,
      NULL,
      8,
      0,
      0,
      0,
      1,
      1.332898,
      1.770985,
      0,
      1.724482,
      0,
      0.895022,
      1.154919,
      0.155240,
      1,
      1,
      0.451209,
      0.502408,
      1,
      NULL,
      0.465253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.281138,
      NULL,
      6.174629,
      6.860475,
      8,
      2,
      1,
      NULL,
      2,
      1.088125,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.474780,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.167323,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.190463,
      NULL,
      NULL,
      0.348483,
      NULL,
      NULL,
      1.915242,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.383622,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      8,
      0.789554,
      3,
      NULL,
      NULL,
      97.801634,
      6,
      0,
      0.182883,
      '',
      '',
      '',
      3,
      '32112',
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


