set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9773907';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.922492,
      2.053086,
      5.674115,
      4,
      1,
      0.040806,
      4,
      '311',
      '31200204',
      20.679729,
      69.592906,
      '0440423',
      NULL,
      0.385525,
      NULL,
      3,
      NULL,
      NULL,
      0.829784,
      NULL,
      NULL,
      ' 8-13-1990',
      NULL,
      38,
      NULL,
      0.619283,
      1.293072,
      '10- 9-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      3.813194,
      ' 8-18-1986',
      NULL,
      '10-28-1982',
      3.153575,
      1.254078,
      1,
      2.806579,
      0,
      NULL,
      1,
      2.324871,
      NULL,
      NULL,
      NULL,
      7,
      4.306342,
      NULL,
      NULL,
      NULL,
      NULL,
      4.734233,
      0,
      NULL,
      NULL,
      0,
      1.929307,
      0.436326,
      1,
      0.940496,
      0,
      1.723117,
      2.827758,
      0.716335,
      0,
      3,
      3.463706,
      2,
      2.127559,
      1,
      0.067148,
      0,
      NULL,
      1,
      NULL,
      0.268475,
      0.054950,
      3,
      NULL,
      6.950170,
      1.329284,
      NULL,
      0.440140,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0.734797,
      NULL,
      NULL,
      NULL,
      1.952005,
      1,
      1.070119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.807895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804840,
      1,
      0.934107,
      1.207820,
      0.641382,
      1,
      NULL,
      NULL,
      0,
      0.176246,
      NULL,
      NULL,
      NULL,
      0,
      1.795660,
      0,
      1.653770,
      0.778222,
      0.113830,
      NULL,
      0,
      7.437803,
      NULL,
      0.939869,
      3,
      4,
      7.286426,
      3,
      1,
      5,
      1,
      1.493124,
      0.073611,
      NULL,
      3,
      1.447439,
      NULL,
      NULL,
      7,
      0,
      3,
      2,
      7,
      0,
      1,
      0.366497,
      1.021477,
      NULL,
      ' 7- 1-1987',
      NULL,
      ' 7- 7-1980',
      653,
      3,
      0,
      1,
      0.719850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053492,
      1.616081,
      1,
      1,
      NULL,
      1,
      0.147346,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.859190,
      0.044662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199966,
      2,
      0.079914,
      1.627065,
      0.002684,
      0,
      NULL,
      NULL,
      NULL,
      2.564437,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701944,
      0,
      1,
      0.635384,
      0.731267,
      NULL,
      1,
      0,
      41.445357,
      2.984616,
      1,
      NULL,
      NULL,
      NULL,
      1.501870,
      0.884670,
      3,
      2,
      0,
      0.671805,
      0.113989,
      NULL,
      NULL,
      1,
      3,
      0.395030,
      0.151985,
      NULL,
      3.320321,
      2,
      NULL,
      1.699904,
      0.509495,
      NULL,
      0,
      NULL,
      0,
      1.591055,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      0,
      NULL,
      1.790587,
      0,
      NULL,
      9,
      4,
      6.923184,
      1,
      1.147884,
      2,
      2.981990,
      NULL,
      1.091262,
      NULL,
      3,
      3.857574,
      43.070768,
      NULL,
      56,
      NULL,
      1,
      2,
      1,
      '04230',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.688066,
      7,
      23.356053,
      51,
      2.755088,
      16,
      5.855389,
      1,
      4,
      1.278207,
      2,
      2.514365,
      0,
      NULL,
      NULL,
      1.053802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.234387,
      NULL,
      NULL,
      0.942249,
      0.856859,
      3.835765,
      2.362490,
      NULL,
      0.593694,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.089178,
      NULL,
      1,
      NULL,
      NULL,
      0.514654,
      5,
      3,
      1,
      0.348232,
      NULL,
      NULL,
      NULL,
      0.102299,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.566987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.015448,
      1.285153,
      3.096288,
      0,
      0.173382,
      0.929315,
      1.759186,
      0.713669,
      NULL,
      1,
      1.022980,
      3,
      NULL,
      1,
      NULL,
      1.681363,
      NULL,
      NULL,
      1.664204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.063519,
      3.559657,
      4.134262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.314190,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.740204,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620674,
      NULL,
      NULL,
      1.010347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.333795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.674498,
      3.528563,
      1,
      NULL,
      NULL,
      1.805504,
      NULL,
      NULL,
      9,
      6,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.869110,
      2,
      1.511934,
      NULL,
      NULL,
      7,
      0,
      2.451774,
      2,
      NULL,
      3,
      1.205684,
      1,
      0.379572,
      0,
      1,
      1.321363,
      NULL,
      2.122284,
      NULL,
      1,
      4,
      2.363926,
      0,
      NULL,
      NULL,
      3.490356,
      2.321755,
      4,
      0,
      1,
      1,
      1.517233,
      NULL,
      3.054323,
      NULL,
      NULL,
      1.095639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.534661,
      NULL,
      NULL,
      1.635958,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.592264,
      NULL,
      NULL,
      3,
      1.296450,
      0.780223,
      0,
      1.296210,
      3.533247,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      179,
      NULL,
      NULL,
      NULL,
      0.253587,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.128820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.697667,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.165714,
      NULL,
      NULL,
      NULL,
      0.630426,
      NULL,
      NULL,
      NULL,
      0.468572,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.607641,
      14,
      NULL,
      2,
      9.887845,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      29,
      2,
      1,
      0.659921,
      1.919709,
      NULL,
      0.374033,
      0,
      0,
      1.509122,
      1,
      0.573047,
      NULL,
      0.526861,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847079,
      1.868846,
      4,
      1.177285,
      NULL,
      0,
      1,
      3,
      13.497758,
      2.497950,
      3,
      0.218310,
      1,
      NULL,
      NULL,
      0,
      2.473600,
      NULL,
      2.015086,
      1,
      NULL,
      0.115521,
      1,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0.614716,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.293814,
      0.727956,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.219860,
      NULL,
      1,
      NULL,
      9,
      2,
      10.478417,
      0,
      0.463160,
      1.185600,
      25.625770,
      NULL,
      1.664491,
      NULL,
      1.157249,
      '34101',
      '',
      '',
      1.512207,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


