set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8733301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '4004140',
      3.401795,
      0,
      2,
      NULL,
      NULL,
      2.064364,
      1,
      NULL,
      NULL,
      ' 1-24-1991',
      NULL,
      NULL,
      5,
      0,
      6,
      ' 8-13-1995',
      23,
      3,
      168.143440,
      59,
      3.403620,
      NULL,
      ' 9-19-1988',
      ' 6- 2-1983',
      3,
      1,
      1.706506,
      0.227604,
      0,
      1.786974,
      3.633031,
      1.015742,
      NULL,
      NULL,
      NULL,
      17.217608,
      NULL,
      11.380081,
      23,
      3,
      2.732341,
      NULL,
      4.432010,
      NULL,
      NULL,
      1.271453,
      0.928055,
      1.431472,
      1,
      0,
      0,
      0.107641,
      1.426361,
      1.764184,
      0.289922,
      NULL,
      1,
      0,
      0,
      11.486901,
      2.363876,
      2.323472,
      0.400245,
      0,
      0,
      4,
      1,
      5.740070,
      0,
      NULL,
      1.938779,
      1.422221,
      0,
      5,
      0.541027,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      4,
      0,
      0.304658,
      NULL,
      3.087252,
      1.982703,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0.149857,
      1.273436,
      1.805155,
      0.386316,
      1.361529,
      0,
      0,
      1.501215,
      8,
      1.430225,
      0,
      0.371629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      3.309585,
      0.171532,
      NULL,
      1.477544,
      NULL,
      5.534696,
      1.457910,
      1,
      1.962955,
      5.808973,
      NULL,
      1,
      1.332258,
      0.281973,
      0,
      NULL,
      1,
      NULL,
      3.494736,
      1,
      5.979239,
      0,
      0,
      5.913716,
      6.860849,
      8,
      NULL,
      4.508057,
      3,
      2.335549,
      1.508573,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.988527,
      7.029449,
      6.762840,
      NULL,
      2,
      1.747218,
      ' 8-25-1990',
      10,
      '10-18-1990',
      59.283829,
      1,
      1,
      3,
      3,
      2,
      NULL,
      NULL,
      0.669090,
      1.743015,
      NULL,
      0.149782,
      0.769905,
      4,
      NULL,
      2.559469,
      3.871890,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.910479,
      NULL,
      1,
      0.592172,
      NULL,
      4,
      0.419460,
      1,
      3,
      NULL,
      9,
      1,
      0.661120,
      0.846850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.417925,
      5,
      NULL,
      1.572442,
      3.888306,
      0,
      NULL,
      NULL,
      0,
      12,
      1.056307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047384,
      1,
      NULL,
      1.118257,
      1,
      0,
      2,
      15.329840,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891932,
      2,
      0.238398,
      0.797368,
      1.109204,
      1,
      0.283039,
      1.324904,
      0,
      0.652962,
      NULL,
      0.333042,
      2.524425,
      3,
      NULL,
      NULL,
      1.190374,
      1,
      1.480925,
      0.658271,
      0,
      0.296340,
      1,
      1.486966,
      1,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      3.607851,
      1,
      2,
      3,
      6.840305,
      4,
      0,
      7.930458,
      NULL,
      1.664919,
      3.879818,
      25,
      2,
      3.242227,
      NULL,
      3.789145,
      5,
      NULL,
      4.456311,
      1.516698,
      NULL,
      '00122',
      '',
      '',
      1.523655,
      '',
      NULL,
      '',
      0.937169,
      '',
      NULL,
      NULL,
      0,
      24,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.947065,
      NULL,
      3,
      1.589109,
      1,
      1,
      1.507827,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.080403,
      1.686623,
      0,
      NULL,
      NULL,
      NULL,
      3.395799,
      3.989756,
      2,
      0.936129,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      3,
      7.857912,
      0,
      1.292872,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.658087,
      0,
      NULL,
      NULL,
      1.929184,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1.796727,
      1.260340,
      1,
      1.745470,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.146489,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      2,
      1.059192,
      1,
      NULL,
      NULL,
      NULL,
      7,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.573508,
      1,
      1.327549,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.841927,
      NULL,
      NULL,
      1.720346,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.854992,
      3.007810,
      1.855296,
      NULL,
      NULL,
      3.223867,
      NULL,
      2.822509,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.477820,
      NULL,
      0.857328,
      NULL,
      NULL,
      1.392679,
      NULL,
      3.166063,
      1.727620,
      0.383645,
      1.382398,
      1,
      1,
      NULL,
      NULL,
      0,
      3,
      1.953157,
      1,
      2.586560,
      0,
      7.802567,
      0.677827,
      5.462426,
      3,
      NULL,
      2.837577,
      NULL,
      1.721264,
      NULL,
      0,
      1.341702,
      NULL,
      3.797893,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.707256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860935,
      NULL,
      NULL,
      1.503523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.689171,
      NULL,
      0,
      0,
      0,
      1.196219,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925844,
      NULL,
      NULL,
      NULL,
      0.087281,
      NULL,
      NULL,
      NULL,
      1.442824,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.587237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.579617,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261190,
      1,
      0.181162,
      NULL,
      NULL,
      1.664413,
      NULL,
      NULL,
      0.457449,
      NULL,
      NULL,
      0.599427,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      88.421125,
      NULL,
      3.942123,
      1,
      1,
      0,
      2.282683,
      0.037671,
      1,
      NULL,
      0,
      0.428362,
      0.387798,
      1,
      3,
      0.129845,
      1.211760,
      1.129497,
      1,
      1,
      1.019498,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.314699,
      NULL,
      NULL,
      0.772464,
      1.998176,
      0,
      NULL,
      2.535268,
      NULL,
      1,
      NULL,
      2.146264,
      NULL,
      1.767379,
      NULL,
      0,
      NULL,
      1.514963,
      NULL,
      3.339132,
      NULL,
      NULL,
      NULL,
      0.808865,
      NULL,
      1.700148,
      NULL,
      0.243304,
      NULL,
      1.365308,
      NULL,
      0,
      NULL,
      0.838637,
      0.093337,
      1.853717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400128,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600417,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      21.774504,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1,
      1.010571,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977224,
      1.880602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.363668,
      27,
      26.656152,
      1.946318,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.319309,
      2.013227,
      3,
      1.695270,
      3.131735,
      NULL,
      2.959033,
      2.358298,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      3.150380,
      NULL,
      0.952476,
      1.500768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.805819,
      NULL,
      1.685215,
      1,
      NULL,
      NULL,
      0.004071,
      NULL,
      2.681033,
      3.985714,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      1.463164,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.098812,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.357425,
      NULL,
      1.163117,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.111034,
      NULL,
      157.115901,
      NULL,
      NULL,
      3.784310,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.524354,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.424853,
      NULL,
      NULL,
      NULL,
      83,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.772693,
      1,
      1.974338,
      NULL,
      NULL,
      103.361993,
      39,
      1.865075,
      0,
      3.639216,
      NULL,
      '42242',
      '12121',
      0.363610,
      NULL,
      NULL,
      '',
      1.698010,
      '',
      '',
      '');
commit;
end;
/


