set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9002983';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      '2244',
      3.190055,
      1,
      NULL,
      NULL,
      ' 8- 6-1995',
      8,
      NULL,
      0.688209,
      3,
      0,
      ' 4-22-1977',
      21.620722,
      2.841403,
      162,
      39.563091,
      3.851842,
      '10-22-2003',
      ' 8-28-1981',
      ' 1-28-1977',
      NULL,
      3,
      3.887989,
      NULL,
      NULL,
      3,
      2.933632,
      1.749783,
      1.291457,
      93.989932,
      7,
      4.785537,
      14,
      NULL,
      46.593841,
      NULL,
      6,
      NULL,
      NULL,
      11.206290,
      0.618092,
      0.629572,
      1.552393,
      0.106546,
      0,
      1,
      0.953789,
      NULL,
      0,
      1.020760,
      53.778139,
      4,
      8.252298,
      NULL,
      NULL,
      4.022561,
      1.391533,
      NULL,
      1,
      1.643242,
      NULL,
      4,
      1,
      1.952853,
      0.477503,
      1,
      0.476405,
      8,
      1.060198,
      4,
      1.740303,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5,
      2.109810,
      0,
      1.322591,
      1,
      0,
      0,
      0.375250,
      1.934189,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      9.195344,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508818,
      4.206423,
      1,
      0,
      3,
      2,
      0.899722,
      3.648394,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      1,
      1.473914,
      NULL,
      0,
      1.704008,
      NULL,
      1.477599,
      2.388889,
      1,
      4.251690,
      0,
      1,
      1,
      2.120331,
      NULL,
      6,
      NULL,
      NULL,
      1.538876,
      NULL,
      11.547990,
      1,
      2,
      2,
      3,
      NULL,
      1,
      10,
      4.313029,
      NULL,
      6,
      4.465386,
      2,
      2.595384,
      ' 0-23-1991',
      354.944205,
      ' 2- 2-1987',
      NULL,
      2.201193,
      NULL,
      0.043070,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.981836,
      1,
      NULL,
      1.746681,
      NULL,
      0.717371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.915129,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.575700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.205189,
      1.904392,
      0.792284,
      0.506034,
      1.058115,
      1.004587,
      1,
      1372.792926,
      1.076648,
      1,
      NULL,
      NULL,
      NULL,
      1.342769,
      0,
      2,
      0.421260,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1.953635,
      1,
      0.119784,
      1.900246,
      1,
      0,
      NULL,
      113,
      186.375781,
      109,
      NULL,
      105,
      59,
      1.437214,
      0,
      0.825385,
      1.823390,
      0,
      0.790151,
      0,
      7,
      NULL,
      NULL,
      6,
      3,
      1,
      5.652314,
      5,
      4,
      0.567172,
      1.339460,
      0.825595,
      1.999924,
      2,
      0.063057,
      0.833127,
      NULL,
      0,
      NULL,
      NULL,
      51.804484,
      68.567108,
      NULL,
      0.304288,
      0,
      '24420',
      '23201',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      30,
      NULL,
      37,
      2.537825,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.527669,
      NULL,
      NULL,
      0.570372,
      NULL,
      NULL,
      1.478336,
      NULL,
      NULL,
      0.472407,
      2.533446,
      0.806118,
      0.549178,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.471764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      4.204506,
      0.591357,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.221023,
      0.747073,
      2.726268,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1.924734,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      1.717256,
      1.591458,
      1.045060,
      1.591993,
      NULL,
      NULL,
      NULL,
      0.663667,
      NULL,
      NULL,
      1.879970,
      1.930700,
      1.134858,
      0,
      3.526130,
      NULL,
      2,
      0.151139,
      NULL,
      NULL,
      NULL,
      1.521343,
      NULL,
      NULL,
      NULL,
      1.577240,
      NULL,
      NULL,
      NULL,
      0.533290,
      0.133226,
      1.339627,
      2,
      1.587154,
      0,
      NULL,
      NULL,
      8.832548,
      7,
      4,
      2.874492,
      0,
      0.346542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.881485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486750,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.004726,
      NULL,
      NULL,
      3.978466,
      NULL,
      3,
      3.428891,
      2,
      3.920055,
      2,
      7.659007,
      2,
      9.375930,
      7,
      1.725673,
      3.115044,
      5.799811,
      1,
      1,
      1.560271,
      3,
      1.333018,
      2.890562,
      3,
      2,
      0.500572,
      NULL,
      4.502745,
      5.522076,
      6,
      1.703440,
      0,
      0,
      1,
      0,
      3,
      3,
      0,
      NULL,
      3,
      2,
      1.474921,
      0.932217,
      1,
      3,
      3.198824,
      5.307762,
      3.634661,
      NULL,
      5,
      8,
      0,
      1.596756,
      NULL,
      1,
      1.696215,
      1,
      NULL,
      NULL,
      1.026304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.327678,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256726,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      2.195585,
      1,
      NULL,
      NULL,
      1.240642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368831,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.186157,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      72,
      62.008517,
      NULL,
      13.108068,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.029161,
      1.030272,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      37,
      1.739314,
      0,
      0.424234,
      1.571984,
      0,
      1.709598,
      1.462734,
      1.449871,
      NULL,
      0,
      3,
      1,
      3,
      1.536251,
      0.060780,
      0.859369,
      0,
      0.484794,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.208512,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17,
      NULL,
      1.498777,
      19,
      NULL,
      1.003760,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361879,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.630793,
      NULL,
      1,
      NULL,
      0.522708,
      NULL,
      0.954276,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.005886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.826723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192275,
      1.196134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545767,
      2.315961,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.353488,
      NULL,
      1.985801,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.894252,
      NULL,
      93.168574,
      NULL,
      3.318481,
      0,
      0.635142,
      NULL,
      0,
      NULL,
      2.612589,
      NULL,
      42,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4,
      35.710948,
      1,
      NULL,
      NULL,
      NULL,
      2,
      4.898714,
      NULL,
      3,
      2.747219,
      5,
      NULL,
      NULL,
      NULL,
      0.380222,
      NULL,
      NULL,
      0,
      0.535609,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.316430,
      NULL,
      1.229132,
      NULL,
      NULL,
      0.387545,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.556255,
      NULL,
      1.783648,
      1.972886,
      NULL,
      1.252641,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.659415,
      8,
      8.526966,
      0,
      0,
      0.767723,
      NULL,
      6,
      1.174205,
      1.358025,
      2.835381,
      '04022',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


