set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0115805';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.753213,
      4.575031,
      NULL,
      1,
      2.140625,
      4.134089,
      1,
      0,
      '124',
      '04210144',
      57,
      59,
      '1004140',
      1,
      1.827973,
      1,
      3,
      '1033',
      NULL,
      1.096840,
      NULL,
      NULL,
      ' 7-25-1976',
      29.439188,
      15.274741,
      NULL,
      1.307897,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 9- 8-2001',
      '10- 4-1999',
      ' 5- 9-1991',
      3.350567,
      NULL,
      3.215293,
      NULL,
      NULL,
      0.527951,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      9,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      5.860029,
      3.626884,
      NULL,
      0.441775,
      5,
      1.912734,
      0,
      0.203771,
      0,
      0,
      3,
      1.299614,
      1,
      0.238631,
      1,
      NULL,
      NULL,
      0,
      0.699659,
      0,
      3.552179,
      1,
      0.383882,
      NULL,
      NULL,
      1,
      NULL,
      0.617831,
      1.726277,
      1,
      1.880408,
      2,
      2,
      NULL,
      1.754441,
      NULL,
      NULL,
      NULL,
      0.111683,
      4,
      1,
      4,
      0,
      0.825085,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667732,
      0,
      1,
      4.487170,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      1.875248,
      0.541767,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.835255,
      1.018243,
      0.486433,
      1,
      NULL,
      1,
      1.186902,
      1.334662,
      0,
      1.080220,
      NULL,
      0,
      1.456636,
      NULL,
      0.462712,
      NULL,
      1,
      NULL,
      4.981710,
      NULL,
      1.489911,
      4,
      0,
      1.407856,
      2.354861,
      5.611490,
      1,
      7,
      1,
      NULL,
      1,
      NULL,
      1,
      4.948433,
      6,
      3,
      NULL,
      1.436921,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.210313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.842124,
      0,
      NULL,
      1,
      1,
      1.781053,
      1.827202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.679022,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.351420,
      NULL,
      5.728613,
      0.679667,
      0.712424,
      1,
      NULL,
      NULL,
      0,
      5.408337,
      1,
      0.901792,
      7,
      1.376238,
      6,
      NULL,
      590.527125,
      ' 7- 0-1976',
      392,
      NULL,
      0.163360,
      0,
      1,
      3.373391,
      NULL,
      NULL,
      NULL,
      1.930682,
      1.974797,
      3,
      6.408057,
      1.915066,
      1.952949,
      NULL,
      NULL,
      NULL,
      3.657677,
      NULL,
      2.848039,
      2,
      NULL,
      2.532643,
      0,
      3,
      2.166901,
      2,
      NULL,
      0.807179,
      0,
      1,
      3.750949,
      0.252730,
      4.477959,
      1,
      1.792357,
      0.474824,
      1,
      1,
      1.505163,
      NULL,
      0.691179,
      1.508990,
      0,
      0,
      0.826808,
      NULL,
      NULL,
      1.556288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.091329,
      48.521590,
      NULL,
      11,
      20.213471,
      5.797035,
      4,
      5,
      NULL,
      '111',
      NULL,
      0.715465,
      NULL,
      '',
      NULL,
      0.188581,
      NULL,
      '',
      NULL,
      0.363417,
      NULL,
      158,
      24.728274,
      1.979407,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.655947,
      NULL,
      1.522156,
      NULL,
      NULL,
      1.195687,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.979575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.016283,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.668407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.625178,
      NULL,
      1.164086,
      1,
      1.857996,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876331,
      1,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.875922,
      2,
      NULL,
      1.595790,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371986,
      NULL,
      NULL,
      0.030262,
      NULL,
      NULL,
      0.490080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372164,
      NULL,
      NULL,
      0.517753,
      NULL,
      NULL,
      1.032831,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.688909,
      0.347431,
      NULL,
      3,
      5.484108,
      2.624442,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.478405,
      1.704340,
      1.309359,
      2,
      3.059456,
      2,
      NULL,
      3.460148,
      0.728393,
      NULL,
      2,
      1.079570,
      0.885682,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.485628,
      3,
      7,
      1,
      5,
      NULL,
      6.698420,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0.061633,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.369741,
      1.517602,
      NULL,
      2,
      0,
      1,
      1.288602,
      3.154302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.869626,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.913656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.667700,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.467512,
      NULL,
      NULL,
      NULL,
      2.748116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.508744,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609402,
      1.862294,
      6,
      NULL,
      NULL,
      1.882093,
      0.298445,
      1,
      NULL,
      1.536232,
      1,
      NULL,
      NULL,
      1.358681,
      NULL,
      NULL,
      0.892568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016023,
      1,
      1.318790,
      1,
      1,
      1.133061,
      0,
      1.863799,
      0,
      1.625852,
      0,
      1.412848,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.060260,
      0,
      1.987659,
      0.220532,
      NULL,
      2.247407,
      4.953533,
      NULL,
      0,
      0.882110,
      0,
      NULL,
      0.114588,
      NULL,
      0,
      1.760088,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0.479129,
      NULL,
      NULL,
      0.273133,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.720939,
      NULL,
      1,
      0.313347,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.332202,
      NULL,
      1,
      NULL,
      2,
      2,
      6,
      0,
      1,
      1.740586,
      54.064004,
      4,
      2,
      3,
      7,
      '3213',
      NULL,
      '3040',
      1,
      '12344',
      '',
      NULL,
      0.660435,
      NULL,
      '',
      NULL);
commit;
end;
/


