set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4704279';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '12',
      22,
      26,
      '3144043',
      NULL,
      0,
      0,
      0,
      '4204',
      2,
      0,
      NULL,
      NULL,
      ' 6-24-1996',
      9.269157,
      61,
      NULL,
      2,
      1,
      '10-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 2-21-1992',
      0.363270,
      1.921643,
      2,
      0,
      1,
      NULL,
      9.195198,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      9.505473,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3,
      NULL,
      1,
      NULL,
      0.958883,
      1,
      1.883017,
      1.356370,
      0.606619,
      1.739845,
      1,
      0,
      3.941782,
      8,
      3,
      NULL,
      1.130922,
      1.991821,
      0,
      0,
      NULL,
      0,
      NULL,
      0.707294,
      NULL,
      3.569885,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4,
      2.703473,
      0.175159,
      NULL,
      NULL,
      NULL,
      0.914666,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      0,
      1.308982,
      0,
      0.157875,
      1,
      NULL,
      0.925003,
      NULL,
      0,
      0.098731,
      1,
      1,
      0.623485,
      0,
      0.095811,
      1,
      1.058236,
      0.980778,
      3,
      0.970553,
      5,
      0,
      1.362841,
      NULL,
      NULL,
      1.693483,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.331863,
      2.674572,
      NULL,
      1,
      0,
      0.127372,
      NULL,
      NULL,
      1,
      1.895422,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0.022949,
      NULL,
      0.954987,
      1.278969,
      0,
      0,
      NULL,
      1.030465,
      0.749443,
      NULL,
      1,
      0.443187,
      NULL,
      1,
      1.078490,
      2.025635,
      0.034892,
      1,
      9.580723,
      NULL,
      7,
      0.414354,
      5,
      0,
      0,
      2,
      3,
      ' 1-12-1974',
      1057.468164,
      ' 5-28-2000',
      312.097082,
      1,
      0.309783,
      0,
      2.811064,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.732636,
      1,
      NULL,
      0,
      1,
      0.323030,
      1.542635,
      0.074572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451332,
      0.557109,
      0.314274,
      0,
      1,
      0,
      0.985213,
      NULL,
      NULL,
      NULL,
      0.155168,
      NULL,
      1.567352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0.802746,
      3,
      6366.901800,
      0.863690,
      1,
      NULL,
      NULL,
      NULL,
      3.919614,
      0.478100,
      2.417959,
      NULL,
      2,
      0.774593,
      1.708264,
      3.348158,
      3.131386,
      3.963802,
      1,
      NULL,
      NULL,
      0.269714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740596,
      0.596258,
      0,
      0.715793,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957753,
      50,
      NULL,
      66.108129,
      16,
      4,
      3.400445,
      2.575491,
      '0030',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      19,
      0.570459,
      44.436449,
      2.162442,
      35.960464,
      4.720850,
      10.129449,
      1.749225,
      0.200172,
      0,
      0.694312,
      3.543388,
      2,
      1.012011,
      1.757334,
      NULL,
      NULL,
      NULL,
      3.302829,
      1.531121,
      NULL,
      3.807238,
      1.547307,
      1,
      1.878223,
      3.639714,
      1,
      0.963942,
      0.097293,
      0,
      NULL,
      NULL,
      3.215834,
      0.114181,
      0,
      1,
      0.215079,
      1.297126,
      NULL,
      NULL,
      1.091269,
      1,
      NULL,
      NULL,
      11.021035,
      NULL,
      6,
      1.797660,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.578852,
      NULL,
      NULL,
      0.007178,
      0.867249,
      3,
      1.466842,
      3,
      1,
      3.389847,
      NULL,
      0.107449,
      0.421220,
      0.802121,
      NULL,
      2,
      0,
      1.881989,
      0.565420,
      1.809177,
      2,
      1.664269,
      0.289580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.963814,
      0.394711,
      1.920123,
      10.732053,
      NULL,
      5,
      1.852729,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.133781,
      NULL,
      NULL,
      NULL,
      1,
      1.192561,
      1.740553,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.552812,
      3.643790,
      2,
      2.978154,
      1.540161,
      NULL,
      4.971159,
      7.527649,
      5.878132,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.965173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991420,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.393512,
      2,
      3.901213,
      1,
      7,
      NULL,
      2,
      NULL,
      2,
      3.345709,
      2.819749,
      1.236944,
      1.464695,
      NULL,
      NULL,
      5.148382,
      NULL,
      NULL,
      NULL,
      0.409601,
      3,
      0,
      NULL,
      NULL,
      3.779444,
      NULL,
      NULL,
      3.044297,
      1.353956,
      3,
      0.386826,
      NULL,
      0.575830,
      0,
      5.992127,
      2.710368,
      2,
      3,
      NULL,
      0,
      NULL,
      1.810044,
      1.369867,
      1,
      2.891836,
      NULL,
      NULL,
      0.951849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397219,
      NULL,
      NULL,
      3.084275,
      NULL,
      NULL,
      1.232324,
      NULL,
      NULL,
      0.610801,
      NULL,
      NULL,
      1.230647,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.409396,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.740224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.714899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.282616,
      0.239474,
      NULL,
      NULL,
      1.123281,
      1.214474,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.278406,
      NULL,
      NULL,
      1.274000,
      1,
      NULL,
      NULL,
      1,
      2.327675,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.476108,
      1.903030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.165800,
      51.390378,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193865,
      NULL,
      NULL,
      0,
      1,
      17,
      1.838465,
      15.614305,
      NULL,
      1.977496,
      NULL,
      1.736802,
      70.734525,
      78,
      NULL,
      0,
      1,
      1.515733,
      1,
      0,
      0.244142,
      0,
      NULL,
      NULL,
      0.244613,
      1.832511,
      0.274433,
      NULL,
      1,
      1,
      0,
      0.698662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.154513,
      NULL,
      2.631497,
      8,
      3.872250,
      1.582894,
      2,
      3.848858,
      NULL,
      0.032151,
      1.434067,
      2.861073,
      1.199311,
      NULL,
      0.958131,
      0,
      1,
      0.365012,
      NULL,
      1.739263,
      NULL,
      1.524803,
      1,
      0.263090,
      1.169949,
      1,
      NULL,
      1,
      0.112710,
      0.067156,
      0,
      NULL,
      3,
      1.903116,
      0,
      NULL,
      1,
      0.646892,
      0,
      3.470492,
      0.295307,
      2.666832,
      0,
      0,
      1.022595,
      2,
      1.583861,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925930,
      NULL,
      NULL,
      0.401653,
      NULL,
      0.989445,
      2.134770,
      4.810531,
      11.711871,
      NULL,
      0,
      0.148123,
      3,
      69.706232,
      4,
      1.265840,
      1,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '');
commit;
end;
/


