set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507588';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      3.932752,
      NULL,
      6,
      1,
      NULL,
      3,
      1.427195,
      NULL,
      NULL,
      ' 5- 5-1981',
      69.229024,
      NULL,
      1.424001,
      0.547865,
      0.864453,
      ' 0-13-1989',
      6.257788,
      1,
      159,
      39,
      1,
      ' 3-28-1983',
      ' 6- 9-1986',
      ' 3- 9-1974',
      3.523322,
      NULL,
      2.171413,
      0.545535,
      1.040921,
      1.023065,
      1,
      1.358670,
      0,
      7,
      8,
      NULL,
      7.709626,
      24.411317,
      12.857650,
      6.300354,
      3.978835,
      6.272907,
      0.316105,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.052072,
      1.634323,
      3.187464,
      0.756633,
      1,
      6.540984,
      NULL,
      4,
      1.242605,
      0.106754,
      NULL,
      1,
      NULL,
      0,
      1.272074,
      NULL,
      0,
      2,
      5,
      0,
      1.050178,
      NULL,
      NULL,
      1.217046,
      NULL,
      NULL,
      1.595085,
      1,
      0.618605,
      1.266038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.110566,
      0.224525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555728,
      4,
      1.366433,
      0.911656,
      5,
      0.937182,
      0,
      0.830368,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.952079,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.398028,
      0,
      1.493674,
      1,
      0,
      1.605930,
      4.448608,
      NULL,
      0.580557,
      1.434853,
      7,
      3.201511,
      1.616576,
      7,
      1.299836,
      2,
      5,
      8,
      6.366556,
      8,
      6.811735,
      NULL,
      1.369614,
      3,
      0.550159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.076100,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317364,
      0,
      0.787022,
      0,
      1.647070,
      0,
      0.412612,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.731973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.207777,
      3.870928,
      2.704189,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.063773,
      1.546756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.168212,
      1.987197,
      1,
      1,
      0,
      1,
      3.184049,
      55,
      0.910588,
      0,
      NULL,
      NULL,
      NULL,
      1.323793,
      1.891118,
      2.043025,
      2.733787,
      0.343754,
      3,
      NULL,
      1.647809,
      0,
      0.584010,
      1.848216,
      1,
      1,
      3,
      2.962940,
      NULL,
      NULL,
      1.233438,
      0,
      1.107999,
      1.232725,
      0.052989,
      1,
      0.294798,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.160553,
      3.861500,
      NULL,
      NULL,
      8.164843,
      5,
      7.212629,
      NULL,
      1.980804,
      3.487059,
      NULL,
      2.172134,
      0.809085,
      1.232775,
      0.344965,
      14.288789,
      0.079249,
      1.385243,
      NULL,
      3,
      NULL,
      78,
      1,
      4,
      NULL,
      '2202',
      '1101',
      '',
      NULL,
      NULL,
      '',
      '',
      1.785451,
      '',
      '',
      '',
      NULL,
      0.600561,
      171.803630,
      NULL,
      0.727574,
      16.907170,
      2,
      2,
      5.508604,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.096307,
      NULL,
      NULL,
      NULL,
      1.768087,
      0,
      0,
      2,
      0.257621,
      NULL,
      3,
      1,
      3.409442,
      0.835010,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.151796,
      NULL,
      NULL,
      0.012890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155139,
      4.922074,
      4.626696,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.835266,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.209928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254083,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.683184,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.320359,
      NULL,
      3.791480,
      1,
      3.534184,
      0,
      1,
      NULL,
      1.663679,
      3.652936,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.289087,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.134407,
      NULL,
      NULL,
      0.319265,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.518088,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      2.689670,
      1.901777,
      NULL,
      NULL,
      4,
      7,
      2,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      3.636582,
      1,
      2,
      1.395611,
      5.101008,
      NULL,
      1,
      NULL,
      NULL,
      3.113385,
      2,
      2,
      NULL,
      1.490479,
      0,
      NULL,
      1,
      1.412942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171858,
      0,
      1.873290,
      NULL,
      1,
      1,
      1.617898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.097366,
      2.191727,
      4,
      1.567944,
      NULL,
      1.586597,
      2.839619,
      0.966521,
      2.983264,
      NULL,
      NULL,
      NULL,
      3.446839,
      1.377699,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.357423,
      NULL,
      0.774000,
      NULL,
      0.887465,
      NULL,
      0,
      1,
      0.155906,
      NULL,
      0.237275,
      1,
      1,
      1.021234,
      NULL,
      1,
      1,
      NULL,
      0.647024,
      0.362537,
      0,
      0.328621,
      1.476437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.924259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227640,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143605,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086297,
      1.448813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      0,
      1.827981,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0.274011,
      0.090253,
      0.150476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2.726046,
      0,
      2.595250,
      0.637896,
      NULL,
      5.939841,
      NULL,
      1,
      0.742991,
      NULL,
      1.646624,
      NULL,
      0.839202,
      1.486088,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      2.978274,
      3.645452,
      NULL,
      0.375117,
      0.338644,
      NULL,
      1.171537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367794,
      NULL,
      NULL,
      0.024205,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133052,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.567442,
      6.205001,
      9.279151,
      3.242943,
      0,
      NULL,
      3,
      72.795112,
      3,
      2.579773,
      1.810849,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0.440040,
      '',
      '',
      '');
commit;
end;
/


