set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1030042',
      NULL,
      NULL,
      NULL,
      2,
      '4204',
      2,
      1.773284,
      NULL,
      NULL,
      ' 9- 0-1986',
      16,
      NULL,
      4,
      2.505215,
      NULL,
      ' 7- 5-2003',
      22.610200,
      0.144649,
      NULL,
      117,
      3.038659,
      NULL,
      ' 7-29-1989',
      NULL,
      0,
      3.465380,
      0,
      3.892659,
      NULL,
      1.547629,
      2,
      3.743059,
      NULL,
      NULL,
      NULL,
      9,
      3,
      NULL,
      14.655184,
      4.400695,
      24,
      NULL,
      1.201283,
      3.000715,
      0,
      3,
      1.554330,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.714946,
      2,
      3.362169,
      3,
      2,
      NULL,
      0,
      6.850579,
      2.823169,
      NULL,
      NULL,
      NULL,
      1.952829,
      8.527490,
      1.005561,
      2,
      NULL,
      NULL,
      1,
      0.910552,
      2.787395,
      NULL,
      0.947976,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.034307,
      1.637327,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.244394,
      3.501320,
      0,
      0,
      1.522357,
      0,
      0.434469,
      3,
      1.254838,
      NULL,
      9,
      1.897631,
      0.171116,
      4,
      NULL,
      2.903302,
      0,
      1.602706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      5.299840,
      2,
      NULL,
      0.522402,
      NULL,
      4,
      NULL,
      NULL,
      0,
      NULL,
      1.560664,
      3.873031,
      0,
      0.719489,
      5.585787,
      NULL,
      6,
      1.720129,
      4.989212,
      NULL,
      NULL,
      0,
      6.835657,
      4,
      0.516204,
      3,
      1.236771,
      9.702886,
      NULL,
      4.804115,
      NULL,
      1.872083,
      8,
      4.997117,
      2.128856,
      0.112590,
      NULL,
      2,
      2.333088,
      6,
      9.630140,
      6,
      8.593518,
      3.246029,
      ' 3-10-1989',
      NULL,
      ' 0-27-1980',
      9.295695,
      3,
      NULL,
      NULL,
      4,
      1.941038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2.989897,
      NULL,
      1,
      NULL,
      9.686262,
      0.456898,
      2.752738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.939092,
      3.184620,
      NULL,
      1,
      0.235711,
      NULL,
      4.927374,
      1,
      3,
      NULL,
      0.768218,
      3.895563,
      7.164177,
      0.721679,
      4,
      0,
      NULL,
      7,
      1,
      0,
      NULL,
      NULL,
      1.439213,
      12,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.833724,
      NULL,
      0.295029,
      1.487324,
      0,
      NULL,
      31,
      0.833289,
      1.186909,
      NULL,
      NULL,
      NULL,
      0,
      0.082102,
      3,
      3.162002,
      2.731280,
      2.894971,
      NULL,
      NULL,
      NULL,
      0.462761,
      1.356726,
      1,
      3.390711,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.515832,
      1,
      1,
      0.023982,
      0,
      1.898807,
      0.463320,
      0.690522,
      0.633305,
      4.792881,
      1.689723,
      3,
      7,
      1.737897,
      0,
      11.340388,
      1.389101,
      NULL,
      3.929477,
      1.370668,
      1,
      NULL,
      1,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      34,
      3,
      NULL,
      3,
      '40401',
      '',
      '',
      1.509077,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.937032,
      NULL,
      7.236094,
      11.961942,
      2.801813,
      35,
      NULL,
      1,
      1.934230,
      NULL,
      3.784263,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.444458,
      NULL,
      NULL,
      3.183856,
      1.597147,
      0.314122,
      1.097652,
      NULL,
      NULL,
      NULL,
      1.621579,
      0.190834,
      0,
      NULL,
      NULL,
      0.619162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.979937,
      6.763274,
      0.798900,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.156436,
      NULL,
      NULL,
      NULL,
      0.208484,
      3.966578,
      1,
      0,
      NULL,
      NULL,
      0.567696,
      NULL,
      NULL,
      2,
      3,
      0.744546,
      NULL,
      1,
      0.739320,
      0.071182,
      0.354273,
      0.229662,
      1,
      0,
      0.249325,
      3,
      NULL,
      0.390584,
      0.771406,
      1.122225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3,
      0,
      0,
      0.616168,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.899683,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101179,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.387624,
      6,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.416032,
      0,
      3,
      5.883262,
      0,
      NULL,
      NULL,
      NULL,
      0.479659,
      NULL,
      NULL,
      0.883733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.615978,
      NULL,
      NULL,
      0.207171,
      NULL,
      NULL,
      3,
      0.404193,
      NULL,
      5,
      7,
      1,
      NULL,
      NULL,
      1,
      1.271261,
      NULL,
      NULL,
      3.960842,
      1,
      0,
      NULL,
      2,
      0.828149,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      1.165973,
      NULL,
      NULL,
      0.076364,
      NULL,
      NULL,
      0.960164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746604,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.240730,
      NULL,
      2.592991,
      1,
      0,
      1,
      NULL,
      NULL,
      1.970275,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.441206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753985,
      1.438797,
      NULL,
      0.740344,
      NULL,
      1.169439,
      3.823958,
      NULL,
      NULL,
      NULL,
      0.058148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.259052,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.952350,
      1.001817,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.050487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134696,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2.766257,
      1.581537,
      NULL,
      NULL,
      3,
      0.679073,
      NULL,
      NULL,
      1.360976,
      NULL,
      NULL,
      NULL,
      3.177193,
      1.756828,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.888519,
      NULL,
      NULL,
      0.782987,
      NULL,
      NULL,
      NULL,
      2,
      1.932717,
      15.396708,
      1.575672,
      1,
      1.316524,
      1,
      NULL,
      NULL,
      3.439855,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      145,
      NULL,
      1,
      1.229246,
      0,
      1.474299,
      1,
      1,
      NULL,
      1.132336,
      0.224885,
      1.662430,
      1,
      0,
      0.718677,
      1.051639,
      0.105060,
      0.723255,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969428,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702980,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867272,
      0.353914,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.615201,
      NULL,
      1.805088,
      NULL,
      0.700248,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.311857,
      1.580647,
      1.042898,
      0,
      0,
      1,
      10.910485,
      NULL,
      NULL,
      2.600636,
      1.488184,
      0.852593,
      0,
      0,
      2.021991,
      1,
      24,
      NULL,
      1.759053,
      NULL,
      NULL,
      NULL,
      3,
      1.186498,
      0.862214,
      9.534472,
      NULL,
      1,
      2.553743,
      3,
      NULL,
      3.127677,
      0.318685,
      0,
      1,
      1.666727,
      0,
      NULL,
      1.622119,
      0,
      0.744678,
      1.569227,
      0.130906,
      NULL,
      1.681415,
      NULL,
      1,
      NULL,
      1.042918,
      NULL,
      0.970012,
      3,
      0.690022,
      1.609782,
      1.736730,
      0,
      1,
      1.787931,
      1,
      1.733538,
      0,
      0.763684,
      1,
      0.183064,
      1,
      NULL,
      0,
      2,
      1,
      1.818460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069103,
      0.228448,
      1.319956,
      0,
      NULL,
      1.052227,
      NULL,
      0.682048,
      5.863623,
      0.533783,
      NULL,
      NULL,
      24.330211,
      81,
      1,
      0.989247,
      2.790283,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.236711,
      '',
      '',
      NULL);
commit;
end;
/


