set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7729873';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '3231020',
      NULL,
      1.796290,
      2,
      1,
      '4130',
      1.582366,
      0.446481,
      NULL,
      NULL,
      ' 1-18-1974',
      4.194538,
      NULL,
      3.263513,
      3,
      1.811107,
      ' 8- 5-1985',
      41.409663,
      0.653374,
      4,
      5,
      2.815148,
      NULL,
      ' 7-22-1994',
      ' 1-25-1992',
      1.812186,
      0.246715,
      1.212874,
      0,
      0,
      1,
      NULL,
      3.074914,
      NULL,
      NULL,
      NULL,
      2.009690,
      3,
      91.941188,
      NULL,
      4.078738,
      NULL,
      0.716972,
      1,
      5.092791,
      0.918281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015648,
      0.984158,
      NULL,
      2,
      6.086979,
      NULL,
      0,
      0,
      1.674585,
      1,
      1,
      0,
      6,
      0,
      1.564349,
      0.319511,
      0,
      1,
      1.700119,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.162922,
      NULL,
      NULL,
      1,
      11.998933,
      NULL,
      NULL,
      0.208285,
      NULL,
      2,
      1,
      1.818599,
      3.550290,
      0,
      3,
      0.881874,
      NULL,
      3,
      0,
      0,
      0,
      1.451414,
      1.774530,
      0,
      0,
      9.367654,
      1,
      2,
      1,
      1.803954,
      NULL,
      NULL,
      0.778405,
      NULL,
      NULL,
      1,
      NULL,
      0.082643,
      NULL,
      NULL,
      1,
      0.463950,
      0,
      1,
      NULL,
      1.666494,
      1.400337,
      0.735575,
      0.955456,
      1,
      1,
      0.292516,
      1,
      0,
      NULL,
      1.372924,
      0,
      1.703754,
      0,
      0,
      1.835476,
      1,
      NULL,
      1,
      1,
      1.601908,
      1,
      0.729687,
      0.862038,
      1,
      0,
      0.311603,
      NULL,
      0.850578,
      2.354039,
      NULL,
      1.587748,
      5,
      0,
      0,
      1.552455,
      0.798013,
      2.537973,
      ' 3- 6-1999',
      NULL,
      ' 0-13-2003',
      8.251029,
      3.995662,
      1.970792,
      0.937457,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1.002519,
      0.719113,
      1.748137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.219522,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.485937,
      0.400963,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.603733,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708448,
      7,
      10,
      0,
      2,
      8.997913,
      0,
      2.576071,
      0.279044,
      1,
      1.466949,
      1,
      0.141703,
      48,
      NULL,
      2.144134,
      NULL,
      79.677532,
      51,
      4.758157,
      3.667380,
      0.575731,
      3.130779,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      1.465867,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      1.277595,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.591440,
      NULL,
      NULL,
      0.155115,
      NULL,
      NULL,
      0.833079,
      NULL,
      NULL,
      NULL,
      1,
      2.983224,
      0.370086,
      NULL,
      NULL,
      NULL,
      1.943798,
      3.399214,
      1,
      NULL,
      NULL,
      1.067333,
      NULL,
      NULL,
      0.232529,
      NULL,
      NULL,
      6.625666,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.770042,
      3,
      2,
      NULL,
      2.877509,
      2,
      2.065801,
      NULL,
      NULL,
      1.066393,
      0,
      0,
      0.709669,
      0.925291,
      3,
      0.724311,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.549710,
      NULL,
      0,
      0.128968,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.558601,
      NULL,
      NULL,
      1.366343,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.531016,
      NULL,
      NULL,
      0.807079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.827905,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.568946,
      NULL,
      NULL,
      1.226708,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.682670,
      0,
      2,
      2.926981,
      NULL,
      2.441585,
      NULL,
      1,
      2.211604,
      1.511850,
      NULL,
      0,
      0.639515,
      NULL,
      NULL,
      3.709860,
      NULL,
      0,
      0.639425,
      1.959826,
      1.133524,
      0,
      0.016345,
      NULL,
      NULL,
      NULL,
      1.097607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806944,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.281514,
      NULL,
      NULL,
      1.229601,
      NULL,
      NULL,
      0.843002,
      NULL,
      NULL,
      0.948986,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.672492,
      NULL,
      NULL,
      1,
      1.547532,
      1,
      0,
      1.687082,
      3.794073,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610047,
      NULL,
      NULL,
      NULL,
      0.228461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.885164,
      NULL,
      NULL,
      NULL,
      1.470539,
      NULL,
      NULL,
      NULL,
      1.139647,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.576788,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.756421,
      NULL,
      NULL,
      1.417825,
      NULL,
      NULL,
      0.398187,
      NULL,
      1,
      4713.787739,
      NULL,
      1.798401,
      0.737725,
      0.315751,
      0,
      NULL,
      0.527171,
      1.594506,
      0,
      0.954991,
      1,
      1,
      1,
      1.454579,
      NULL,
      1.463499,
      0,
      1.859624,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0.536068,
      0,
      0.256558,
      1.114212,
      5.932242,
      1.910278,
      2.406595,
      0.198603,
      1,
      3,
      18,
      NULL,
      NULL,
      11.021099,
      NULL,
      7.898194,
      1,
      NULL,
      9.016576,
      9.693875,
      NULL,
      2.583062,
      10.902385,
      NULL,
      19.860915,
      5.309153,
      NULL,
      10.376641,
      1.614679,
      NULL,
      1,
      19,
      NULL,
      16,
      NULL,
      NULL,
      18,
      7,
      NULL,
      NULL,
      11.624908,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951368,
      NULL,
      0.609079,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.203792,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '41324',
      NULL,
      '',
      1.315161,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


