set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7409886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3213241',
      0,
      1.716668,
      1,
      3,
      '4310',
      3,
      1,
      NULL,
      NULL,
      '10-21-1985',
      52.203777,
      NULL,
      1.920813,
      2,
      1.943671,
      ' 9-21-1992',
      54,
      1.015686,
      140,
      152.821455,
      1,
      ' 9-14-1979',
      '10-10-1979',
      ' 6- 4-1981',
      3,
      0.710089,
      3,
      0,
      0,
      2,
      0,
      1.537309,
      1.987043,
      NULL,
      4.434865,
      NULL,
      0.240919,
      11,
      23,
      5.609213,
      31,
      1,
      NULL,
      0.871903,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.743836,
      NULL,
      NULL,
      1,
      1,
      0.381433,
      3,
      3.741169,
      2,
      2,
      1,
      1,
      0,
      0.692994,
      0.427814,
      1.791086,
      3,
      2,
      0.692258,
      NULL,
      0,
      NULL,
      1.480356,
      NULL,
      2,
      1.160702,
      0,
      NULL,
      NULL,
      1.099287,
      NULL,
      NULL,
      4,
      1,
      7.166850,
      1.570074,
      0.172957,
      NULL,
      NULL,
      NULL,
      2.977649,
      1,
      2,
      2.924960,
      3,
      1,
      0.754098,
      NULL,
      3,
      3,
      2,
      1.628927,
      0.457914,
      NULL,
      6.474054,
      0.199644,
      0.849016,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.212966,
      5,
      0,
      NULL,
      5.274575,
      3,
      6.462364,
      NULL,
      NULL,
      1,
      1.328341,
      0,
      1,
      4.817863,
      0,
      0.139085,
      0,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      7,
      NULL,
      1.623083,
      1,
      1,
      6,
      3.073709,
      4.678402,
      NULL,
      NULL,
      4.955463,
      0,
      8.808683,
      4,
      1,
      5.418853,
      3.033678,
      5.869585,
      0.017244,
      1.213768,
      7,
      4.589227,
      10.449256,
      4.413711,
      2.337330,
      ' 0-28-1984',
      NULL,
      NULL,
      9,
      3,
      1,
      0,
      7.894441,
      0.958982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.429676,
      1.443149,
      1.326324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      5,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.239796,
      NULL,
      1.977224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797878,
      1,
      1,
      NULL,
      0,
      0,
      0.439978,
      0,
      63.001863,
      1,
      1,
      47,
      6.665968,
      51,
      1.965098,
      1,
      2.876356,
      2,
      NULL,
      2,
      0,
      1,
      2.000950,
      NULL,
      0.261322,
      NULL,
      0.259838,
      2,
      NULL,
      2.789362,
      1,
      1.819826,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1.185169,
      0.625476,
      0.055080,
      NULL,
      1,
      1.294285,
      3.031131,
      1,
      11,
      3,
      4.229868,
      5,
      9,
      0,
      NULL,
      1,
      3,
      2,
      0,
      1.135878,
      31.399380,
      2,
      NULL,
      NULL,
      63,
      NULL,
      28.943229,
      1.978969,
      0.876689,
      0,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      1.818937,
      '',
      '',
      NULL,
      3.943793,
      31.101873,
      200.057065,
      16.365308,
      0.435172,
      5,
      15.507895,
      1,
      0.711074,
      0,
      NULL,
      NULL,
      1.595257,
      NULL,
      NULL,
      0.565036,
      NULL,
      NULL,
      2,
      1.893482,
      1.663660,
      1,
      2.268646,
      1.219780,
      0.296769,
      NULL,
      NULL,
      1,
      3,
      1.681143,
      1,
      NULL,
      NULL,
      NULL,
      1.498068,
      1.480740,
      0,
      NULL,
      NULL,
      0.340929,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.783379,
      NULL,
      NULL,
      0.385688,
      2,
      0.565060,
      0.044730,
      NULL,
      NULL,
      NULL,
      NULL,
      2.286345,
      0,
      2,
      3,
      3.823803,
      1,
      1.019435,
      1.506055,
      1,
      NULL,
      NULL,
      2.607321,
      1.204184,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.169177,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.930088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.069407,
      NULL,
      3.430130,
      1.054276,
      1,
      1.209576,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2.803939,
      3,
      NULL,
      2.813566,
      3.043332,
      1,
      3,
      2.216406,
      0.715488,
      1,
      NULL,
      NULL,
      7.949273,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.323511,
      5.558529,
      7,
      1,
      0.708818,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.965997,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.567267,
      0,
      NULL,
      0.410034,
      0.848241,
      0.045358,
      4.990161,
      0.734105,
      2.298682,
      1.666641,
      NULL,
      NULL,
      5,
      5,
      0.149252,
      1,
      3.135443,
      0.757107,
      NULL,
      2,
      0.561621,
      1,
      NULL,
      3,
      0.142087,
      NULL,
      4.940479,
      0.253352,
      2.258060,
      1.432002,
      0.574436,
      NULL,
      3,
      NULL,
      3,
      1,
      3.689800,
      2,
      1,
      NULL,
      2.568678,
      3,
      7.113138,
      1.936727,
      0,
      2,
      3.114458,
      0.646897,
      3.864126,
      3.754585,
      3,
      NULL,
      3,
      1,
      NULL,
      6.824646,
      0.767680,
      NULL,
      53.158248,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.919544,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.035380,
      1,
      NULL,
      0.492865,
      0,
      NULL,
      3.105287,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.023505,
      1,
      NULL,
      2.439354,
      NULL,
      NULL,
      NULL,
      0.131671,
      NULL,
      9.712323,
      1,
      NULL,
      2.990386,
      1,
      2,
      2,
      0.326584,
      0.804019,
      3.217538,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      3.692230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.832529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.347535,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.778233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100724,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.090982,
      3.891433,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.422684,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.025495,
      1,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1.949380,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      40.853803,
      NULL,
      NULL,
      2.953856,
      1.477619,
      NULL,
      NULL,
      NULL,
      36,
      0.908604,
      0.118128,
      98,
      11.696124,
      3.672027,
      NULL,
      2,
      NULL,
      NULL,
      0,
      327,
      1,
      0,
      1.660825,
      NULL,
      NULL,
      0.486175,
      NULL,
      NULL,
      1,
      0.492827,
      0,
      1,
      NULL,
      1.848917,
      0,
      1.377867,
      1.438165,
      0.673937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188949,
      0,
      1.337788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118327,
      0.971670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826238,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.426806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372433,
      0.701704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.430231,
      NULL,
      NULL,
      1,
      0.736931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939200,
      0,
      1,
      1.075253,
      0.617967,
      0.355037,
      NULL,
      1.879257,
      2.352541,
      2.310589,
      1,
      0,
      1.561764,
      0.118285,
      3,
      1.797263,
      1,
      0.480951,
      0,
      0.265479,
      1.055874,
      0,
      1.363688,
      1.847029,
      0.772328,
      0,
      0,
      0,
      1,
      2,
      0.178151,
      0,
      0,
      0.120520,
      0.938336,
      0,
      1,
      1,
      1.209594,
      0,
      NULL,
      0.432126,
      1,
      NULL,
      1.603565,
      3,
      3,
      1.781629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.795696,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.012131,
      '',
      '',
      '');
commit;
end;
/


