set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8910324';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3243010',
      2.031505,
      0.752765,
      3,
      2,
      '4234',
      3.989898,
      1.127985,
      NULL,
      NULL,
      ' 9-20-1988',
      7,
      NULL,
      NULL,
      3.662368,
      1,
      NULL,
      21.304865,
      0,
      70.306473,
      102.761040,
      3,
      '10-14-1987',
      NULL,
      ' 8-19-1986',
      3,
      NULL,
      1.398348,
      0,
      0.832098,
      0.530477,
      1,
      1,
      0,
      57.178546,
      NULL,
      0.868330,
      0,
      25,
      7,
      5,
      8.172207,
      NULL,
      3,
      6,
      NULL,
      1,
      0,
      1,
      1.201949,
      1,
      1,
      1.198224,
      0,
      0.713378,
      NULL,
      3,
      3,
      5,
      0.639047,
      NULL,
      0.888459,
      0.125410,
      0.740114,
      0,
      1,
      NULL,
      0,
      1.116563,
      NULL,
      0,
      0.434859,
      1.423562,
      1.106844,
      1.009276,
      NULL,
      1.195417,
      0.731888,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.675674,
      0.672872,
      1.256819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.647979,
      1.973908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821535,
      0,
      NULL,
      4.294886,
      NULL,
      0.461370,
      1.595301,
      1,
      1,
      NULL,
      0,
      1.834925,
      1.395369,
      0,
      0,
      0.423502,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.747904,
      1.637399,
      1,
      NULL,
      1.685075,
      NULL,
      1.372661,
      1.335586,
      1.773243,
      0.967405,
      1.320431,
      0.952342,
      1,
      NULL,
      7,
      NULL,
      0,
      0,
      7.500074,
      7,
      4.073366,
      NULL,
      1.645808,
      0.961017,
      1.804525,
      NULL,
      1654,
      '11- 1-1976',
      1487,
      NULL,
      NULL,
      0,
      3.491566,
      0.884485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.588940,
      1.512274,
      1,
      NULL,
      1.664782,
      1.908371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.246433,
      NULL,
      411,
      1.814410,
      NULL,
      1.363739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0.224152,
      2.227443,
      0.558444,
      0,
      1,
      1,
      NULL,
      1,
      0,
      3,
      1.182266,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.119753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170917,
      2.067996,
      1.956497,
      1,
      3.300692,
      0,
      0.636137,
      0,
      41,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.566015,
      1,
      3.539897,
      0,
      1,
      2,
      NULL,
      1.826186,
      2.146293,
      0,
      3,
      1.199376,
      0.881950,
      4.722038,
      1.381727,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.865783,
      NULL,
      1,
      NULL,
      0.711109,
      0.590941,
      0,
      1,
      NULL,
      11,
      1.861264,
      5.492859,
      0.347668,
      1.576728,
      NULL,
      3.721430,
      2.867974,
      2,
      2.592917,
      2.740832,
      35.500213,
      2,
      2,
      NULL,
      94,
      6.756096,
      73,
      3,
      1.338383,
      2,
      '02013',
      '',
      '',
      NULL,
      '43310',
      NULL,
      NULL,
      5.461584,
      '0440',
      '2002',
      NULL,
      NULL,
      NULL,
      168.403068,
      22.315956,
      3.086132,
      34,
      6.392617,
      NULL,
      4.760514,
      3.771728,
      3,
      2.720725,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.117315,
      NULL,
      NULL,
      0.202214,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.296053,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204518,
      NULL,
      NULL,
      0.440740,
      NULL,
      NULL,
      NULL,
      4.364670,
      6.020074,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.126029,
      NULL,
      NULL,
      1.281518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.178298,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.684306,
      3,
      3.755005,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.850699,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140364,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2.911749,
      5.988467,
      4,
      NULL,
      1.726145,
      NULL,
      2,
      NULL,
      0.891916,
      1.436587,
      0.665811,
      NULL,
      2,
      2.790885,
      0.766441,
      1,
      NULL,
      6.398569,
      2.734033,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.922115,
      0,
      0,
      0.492089,
      0,
      3,
      NULL,
      NULL,
      0.363303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.433918,
      NULL,
      NULL,
      0.905831,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.803863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384587,
      2,
      3.799214,
      1.850248,
      1,
      2,
      2.728997,
      NULL,
      NULL,
      3,
      1.838495,
      NULL,
      NULL,
      149.846115,
      NULL,
      NULL,
      NULL,
      1.502782,
      NULL,
      NULL,
      NULL,
      1.052004,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638323,
      1.163237,
      NULL,
      NULL,
      0.988432,
      NULL,
      NULL,
      NULL,
      0.361747,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.703762,
      NULL,
      NULL,
      NULL,
      1.833905,
      1,
      NULL,
      NULL,
      NULL,
      1.242112,
      NULL,
      NULL,
      3,
      1.876003,
      NULL,
      NULL,
      0,
      1.955927,
      NULL,
      NULL,
      0.298850,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.871549,
      1.492112,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.937964,
      NULL,
      97,
      6.331834,
      NULL,
      53,
      7,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10.319267,
      2,
      NULL,
      NULL,
      NULL,
      0.029500,
      NULL,
      0,
      NULL,
      0.336369,
      1,
      1.239377,
      1,
      0.931726,
      NULL,
      1.108791,
      0.887081,
      1.377644,
      NULL,
      1.768535,
      0,
      1,
      0,
      1,
      1.732939,
      1,
      1.107251,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      2.073757,
      3,
      1,
      5.781339,
      0.332985,
      NULL,
      12.280935,
      2.252134,
      NULL,
      NULL,
      0.299083,
      1,
      1,
      1,
      1,
      0.948062,
      3,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710598,
      NULL,
      NULL,
      0,
      2.571210,
      NULL,
      2.070008,
      NULL,
      NULL,
      1,
      1.420623,
      1,
      3,
      1,
      0,
      1.222706,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507754,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.067542,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.947708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.589447,
      NULL,
      0.906244,
      6.530971,
      2,
      NULL,
      0,
      1,
      NULL,
      2.777332,
      NULL,
      0,
      NULL,
      3,
      11.548319,
      1.690928,
      NULL,
      NULL,
      NULL,
      75,
      4.221253,
      1.846542,
      2,
      '24334',
      '',
      '',
      1.407176,
      '04441',
      '',
      '',
      6,
      '3341',
      '0004',
      NULL);
commit;
end;
/


