set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723633';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '4414112',
      0.706405,
      1,
      2,
      0,
      '4031',
      0,
      1.251041,
      NULL,
      NULL,
      ' 4- 5-1993',
      13.394528,
      NULL,
      2.087478,
      0.508110,
      1.810680,
      ' 0- 3-1977',
      NULL,
      3,
      31,
      80,
      2,
      NULL,
      ' 1- 8-1976',
      NULL,
      0,
      3,
      0,
      1,
      0.347616,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.775364,
      NULL,
      197.244468,
      31.717338,
      4,
      15,
      NULL,
      5,
      11.412934,
      1,
      0.738502,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.553628,
      0.795334,
      1.869268,
      NULL,
      0,
      0,
      2.216263,
      NULL,
      0.685632,
      0,
      NULL,
      1.267463,
      1,
      0,
      1,
      NULL,
      0,
      0.001691,
      1.352081,
      2,
      0.011120,
      4.153690,
      3,
      1,
      0.897564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.607489,
      7.248678,
      NULL,
      0,
      0.333687,
      1,
      1,
      0,
      1.280611,
      0,
      0.672218,
      2,
      1.575489,
      2,
      NULL,
      1.910915,
      0,
      0.109803,
      0,
      1,
      0.252057,
      1,
      5,
      0.330178,
      1.270467,
      0.939776,
      0.434096,
      NULL,
      NULL,
      1.104248,
      NULL,
      NULL,
      1.384420,
      5,
      NULL,
      NULL,
      2.522703,
      1.540889,
      0,
      1,
      0,
      0.270415,
      1.570957,
      2.062212,
      1.388618,
      0,
      0.845104,
      1,
      NULL,
      1.242876,
      0,
      NULL,
      1.098997,
      1.346657,
      1.060515,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.831901,
      1,
      1,
      0,
      0.510230,
      1.715490,
      1,
      2.571566,
      2.302017,
      7,
      4,
      0,
      1.187845,
      1,
      NULL,
      3.722696,
      0.206266,
      NULL,
      0,
      ' 7- 6-1995',
      43.716619,
      ' 0- 6-1988',
      NULL,
      0,
      3,
      NULL,
      7,
      1.195014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.878533,
      0.888463,
      1.420466,
      0,
      1.437952,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.689557,
      4.742441,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.338525,
      NULL,
      1,
      2,
      1.453569,
      0,
      2,
      NULL,
      1.327606,
      0.960428,
      5.565720,
      0,
      1.210774,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.050925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.791397,
      1.191088,
      1.054036,
      0,
      1.237316,
      0.329004,
      1,
      1.230067,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.342576,
      2.781972,
      1.352119,
      NULL,
      5.784550,
      1.256497,
      NULL,
      2,
      NULL,
      0.376970,
      2,
      1,
      0,
      3.626912,
      5.681329,
      1,
      1,
      0.546771,
      2.070932,
      0.456624,
      0.490565,
      NULL,
      0,
      0,
      1,
      0.533834,
      0.060171,
      NULL,
      14,
      2.731086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      9.647940,
      23.283427,
      5.887984,
      NULL,
      2,
      '20343',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0.269776,
      NULL,
      NULL,
      26,
      1,
      0,
      2.305392,
      2.655103,
      4,
      3,
      3.567612,
      0,
      0.813190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.502440,
      NULL,
      NULL,
      1.570501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0.105208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.987941,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.856403,
      1,
      2.437185,
      3.471654,
      1.820006,
      NULL,
      2,
      1.775406,
      0,
      0,
      1,
      NULL,
      3.788700,
      0,
      NULL,
      1.602494,
      NULL,
      NULL,
      0.418262,
      2.158158,
      NULL,
      0.287079,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.844097,
      NULL,
      NULL,
      0.891276,
      NULL,
      NULL,
      NULL,
      3.556471,
      0.212445,
      1,
      0.241067,
      NULL,
      NULL,
      NULL,
      1.616629,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.111415,
      NULL,
      0.079474,
      1,
      2.554652,
      0,
      0,
      NULL,
      NULL,
      5.024230,
      6,
      0,
      0,
      NULL,
      NULL,
      1.797957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834393,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.557909,
      NULL,
      NULL,
      0.791312,
      NULL,
      NULL,
      1.192232,
      NULL,
      NULL,
      5.677135,
      7.740240,
      0.038802,
      1.512300,
      NULL,
      NULL,
      2,
      3.380262,
      0,
      1.039650,
      3.887402,
      0.630478,
      0.854599,
      2,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.280866,
      0.494051,
      2,
      NULL,
      1,
      4.445775,
      3.586957,
      5.415934,
      3.255770,
      0,
      5,
      0.583882,
      1.515973,
      1,
      1.160195,
      1.472286,
      0.621864,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.988923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.438091,
      NULL,
      NULL,
      0.008382,
      NULL,
      NULL,
      0,
      1.669631,
      NULL,
      0,
      1,
      0,
      2.587839,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659989,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.398910,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.589575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.731844,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.723720,
      0,
      NULL,
      NULL,
      1,
      1.170388,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.758606,
      NULL,
      NULL,
      3.860953,
      0,
      NULL,
      NULL,
      9,
      0,
      NULL,
      NULL,
      0.381907,
      NULL,
      NULL,
      NULL,
      0.631624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151590,
      NULL,
      NULL,
      0,
      4,
      NULL,
      0.626303,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      14477,
      NULL,
      1.124353,
      0.062202,
      NULL,
      1,
      0,
      1,
      0.378939,
      1,
      0,
      1.046281,
      NULL,
      0.126796,
      0,
      1,
      1.884738,
      0.667461,
      1,
      0.980061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.522428,
      4.129086,
      2.232786,
      NULL,
      5,
      0.468452,
      13.236338,
      1,
      2,
      2,
      1,
      1.391831,
      0.464911,
      NULL,
      NULL,
      1.667252,
      0,
      3.029678,
      3.447655,
      0,
      1.337295,
      1,
      0.004444,
      0,
      2,
      NULL,
      0,
      1.570251,
      0,
      0,
      2.340803,
      1,
      NULL,
      1,
      1,
      2,
      3.185693,
      NULL,
      0,
      3.783558,
      0,
      NULL,
      2.056171,
      3,
      3,
      1.194693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      1,
      NULL,
      0.851621,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.448377,
      NULL,
      3.822119,
      NULL,
      0,
      1,
      0.762848,
      4.742687,
      0.687036,
      NULL,
      0.985520,
      1,
      1.421798,
      0,
      1.430300,
      5.034319,
      4,
      1,
      NULL,
      NULL,
      6,
      65,
      4.245193,
      NULL,
      1.958794,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


