set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9887642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      4.624338,
      NULL,
      3,
      3,
      3.715313,
      0.899653,
      '430',
      '13314144',
      61,
      69,
      '3341302',
      3,
      0,
      NULL,
      1,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      NULL,
      2.146440,
      2.130963,
      ' 4-22-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      3.356016,
      ' 1-16-1994',
      ' 5-10-1989',
      '11-15-1993',
      2,
      1,
      3,
      2.383355,
      1.773372,
      0,
      2.352101,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400397,
      1.187699,
      NULL,
      1.979235,
      NULL,
      NULL,
      0,
      1.427935,
      0.226383,
      0.147456,
      1,
      1.310736,
      2,
      1.199811,
      1.149824,
      NULL,
      3.768267,
      0,
      1,
      1,
      6,
      1.839301,
      2.632789,
      3,
      3.791015,
      0,
      7,
      NULL,
      5,
      2.635652,
      6.125498,
      0,
      3.947585,
      NULL,
      1,
      1.191153,
      NULL,
      NULL,
      1.500285,
      NULL,
      NULL,
      0.043706,
      7.945124,
      1,
      1.176740,
      3,
      0.750346,
      NULL,
      0.231451,
      2.212688,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.598091,
      3.866484,
      3,
      NULL,
      0,
      2,
      3,
      1.618365,
      7.397841,
      NULL,
      0.956722,
      3.346448,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.633634,
      1.871286,
      2,
      NULL,
      0.742061,
      1,
      0.167987,
      0.174940,
      0.952225,
      NULL,
      4,
      1.713620,
      0.248308,
      3.339231,
      1.577857,
      3.703065,
      1.544023,
      1,
      NULL,
      6.759373,
      7.444837,
      0.041422,
      NULL,
      4.233134,
      1.102184,
      6.328516,
      3.693683,
      1.294096,
      0,
      5,
      0,
      1.969033,
      2,
      0.410858,
      1,
      NULL,
      6,
      1.299375,
      0.022612,
      4,
      3,
      5.121988,
      3,
      NULL,
      6,
      0.627300,
      3.997680,
      ' 4- 8-1995',
      26,
      NULL,
      5.872881,
      NULL,
      0.930915,
      0.303642,
      2.699958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.340356,
      0,
      0,
      6.418332,
      1.907921,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      3,
      2,
      0,
      0,
      3.499926,
      NULL,
      0,
      5,
      1,
      3,
      0,
      NULL,
      3.040537,
      NULL,
      1.768206,
      6,
      1.830906,
      2,
      0,
      0.956713,
      0.475318,
      NULL,
      NULL,
      0.474387,
      2,
      1.410267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      0.824196,
      0,
      2,
      21,
      0,
      0.761330,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.849259,
      1,
      1,
      0.692378,
      0.817913,
      0,
      3,
      3.647395,
      2.396796,
      1.472356,
      NULL,
      0.653984,
      0.092638,
      3,
      NULL,
      1,
      0,
      1,
      0.479266,
      NULL,
      NULL,
      1.027417,
      0.895489,
      1.866172,
      NULL,
      1.121549,
      0,
      3.250426,
      NULL,
      NULL,
      2,
      9.983641,
      2.876361,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.056231,
      0,
      3.794871,
      1.813607,
      NULL,
      1.996214,
      3,
      NULL,
      NULL,
      6.850334,
      69.860416,
      NULL,
      5,
      1,
      '01143',
      '',
      '',
      0.407170,
      '',
      '',
      '',
      2.103575,
      '3224',
      NULL,
      '',
      1.042872,
      20.998635,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.332380,
      NULL,
      0.860094,
      1,
      NULL,
      NULL,
      1.081879,
      1,
      2.049244,
      0.856072,
      NULL,
      NULL,
      0.861079,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782662,
      38,
      1.057994,
      1,
      1,
      NULL,
      0,
      0.802539,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.023968,
      0,
      0.723257,
      0.517562,
      1.763638,
      1.938582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      4,
      NULL,
      2.062655,
      0,
      3,
      3.335368,
      9.289202,
      3.519225,
      3.550998,
      0,
      0.895562,
      0.684251,
      NULL,
      0.004930,
      3.512392,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.683724,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.568082,
      NULL,
      1,
      0,
      NULL,
      0.259136,
      0,
      NULL,
      3,
      1,
      1.133172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349244,
      1,
      NULL,
      1,
      NULL,
      NULL,
      53,
      NULL,
      NULL,
      1,
      1,
      '33244',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '3221',
      NULL,
      NULL);
commit;
end;
/


