set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      '24',
      30.440732,
      30.199431,
      '2204144',
      NULL,
      1.346989,
      5,
      1,
      '3100',
      3.998697,
      NULL,
      NULL,
      NULL,
      ' 5-29-1976',
      NULL,
      48.315957,
      NULL,
      NULL,
      0.554810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 9-27-1986',
      '10- 6-1985',
      '10-28-1977',
      0,
      NULL,
      0,
      3.758805,
      0.860226,
      2.624973,
      NULL,
      NULL,
      NULL,
      10.505785,
      9.794068,
      15,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.161657,
      3,
      NULL,
      0,
      5.324477,
      1,
      0,
      1,
      0,
      1.702061,
      2.362927,
      1.443485,
      1.392311,
      1.324172,
      3.254411,
      0.075909,
      0.651407,
      0.550276,
      NULL,
      1,
      0,
      1,
      9.446604,
      1.126169,
      0,
      0.592104,
      1,
      1,
      1.125544,
      0.368561,
      5,
      0,
      0.730828,
      0.005737,
      0.296285,
      1.455906,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      3,
      0.290897,
      NULL,
      0.280181,
      0,
      2,
      1.290297,
      1.134738,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.729585,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141764,
      7.266205,
      2,
      9,
      NULL,
      0.200668,
      NULL,
      4.555897,
      0,
      0.813921,
      NULL,
      8,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      2,
      0.730024,
      1.496525,
      1.953080,
      2,
      4,
      NULL,
      1,
      3.566867,
      0,
      0,
      0,
      2.895239,
      3.443918,
      NULL,
      1.921736,
      2,
      0.228077,
      0,
      NULL,
      4,
      6,
      NULL,
      0,
      3.319247,
      3.209487,
      NULL,
      96,
      ' 9-27-1980',
      NULL,
      NULL,
      1,
      1.196618,
      NULL,
      0.618590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.860676,
      NULL,
      0,
      0.302966,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.538360,
      NULL,
      0.220931,
      1.289494,
      0,
      0,
      0,
      NULL,
      1.392810,
      1.811002,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.869451,
      1,
      NULL,
      3.428448,
      1,
      1.970597,
      1.313827,
      2.761995,
      42,
      NULL,
      0.666673,
      NULL,
      NULL,
      NULL,
      2.502370,
      0,
      0.636532,
      1.394775,
      1.503766,
      NULL,
      NULL,
      3,
      0.011597,
      2.981475,
      2,
      3.995765,
      3.737337,
      1.845565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.151338,
      NULL,
      1.062922,
      1,
      1,
      0,
      1.933897,
      1.533163,
      1.884378,
      0.230728,
      2,
      0.206883,
      NULL,
      0,
      3,
      2,
      4.715722,
      NULL,
      4.948453,
      NULL,
      0,
      NULL,
      2.066574,
      1,
      NULL,
      30.586126,
      0,
      NULL,
      NULL,
      NULL,
      44.993968,
      15.693670,
      NULL,
      5,
      3,
      '23402',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1.712503,
      '',
      '',
      '',
      3,
      1,
      25,
      17,
      3,
      10.543602,
      3.056927,
      5,
      NULL,
      NULL,
      3.963827,
      2.215115,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.858720,
      NULL,
      3.216011,
      1,
      NULL,
      1.819182,
      0,
      NULL,
      NULL,
      0.335831,
      NULL,
      0.849848,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.300718,
      NULL,
      NULL,
      2.749787,
      2,
      NULL,
      1,
      1.938822,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.944750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.862701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960191,
      NULL,
      NULL,
      0.650437,
      1.847193,
      NULL,
      3.277270,
      NULL,
      1.670875,
      1.640184,
      NULL,
      NULL,
      2,
      3,
      3,
      2.434864,
      3.382060,
      2,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      4.196925,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.320075,
      1.478147,
      0,
      0,
      0.128794,
      5.594886,
      0,
      7.017719,
      1.790539,
      1.015274,
      NULL,
      NULL,
      2.727759,
      0,
      2.634621,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      3.209741,
      NULL,
      7.308384,
      0.954345,
      NULL,
      NULL,
      0.179168,
      NULL,
      NULL,
      0,
      0,
      3,
      0.970805,
      1,
      3,
      8,
      4.430057,
      2.497797,
      0,
      4.749720,
      2,
      NULL,
      1.740049,
      NULL,
      0,
      0.773562,
      1.122529,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.471514,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702456,
      NULL,
      NULL,
      4.740802,
      NULL,
      NULL,
      1.919883,
      NULL,
      1.465512,
      1,
      0,
      2,
      0.124139,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.324708,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.086372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207747,
      1.406729,
      2,
      NULL,
      NULL,
      NULL,
      0.393398,
      NULL,
      NULL,
      1.051033,
      NULL,
      1.166884,
      91,
      681,
      1.490212,
      1.971100,
      NULL,
      0,
      NULL,
      1,
      0,
      1.311378,
      0.391636,
      NULL,
      0,
      0,
      1.752098,
      1.552420,
      0,
      1.623225,
      0,
      0.967294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.542182,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833807,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.465007,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649620,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.444003,
      NULL,
      0.247316,
      0,
      0.344756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      3.101357,
      NULL,
      2.363466,
      1.110870,
      2,
      8,
      NULL,
      NULL,
      0.840498,
      0,
      0.943097,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3.076637,
      NULL,
      1,
      1.064048,
      NULL,
      1,
      0,
      NULL,
      0.157659,
      1.850272,
      NULL,
      2,
      3,
      NULL,
      3,
      2,
      NULL,
      0.012996,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.885908,
      3,
      NULL,
      1.661416,
      1.627356,
      0.768933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.777107,
      8,
      0.773153,
      NULL,
      NULL,
      NULL,
      103,
      2,
      3.598073,
      3.194351,
      '32110',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL);
commit;
end;
/


