set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '4223400',
      3.788748,
      1,
      5,
      1,
      '1111',
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.950638,
      15.978565,
      NULL,
      NULL,
      3.189701,
      150,
      126,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.380696,
      3.620542,
      2,
      0,
      0,
      NULL,
      1,
      0,
      12,
      NULL,
      3.610905,
      7.440039,
      13,
      13.425126,
      5.557017,
      10,
      2.805854,
      3.188230,
      NULL,
      0.041928,
      1.780819,
      1.308822,
      NULL,
      1.608932,
      0,
      1.659347,
      NULL,
      0.390156,
      1,
      1,
      0,
      1.993393,
      5.904235,
      NULL,
      3.139922,
      1,
      3,
      0.153054,
      1.238867,
      1,
      3.786789,
      0.133853,
      NULL,
      NULL,
      NULL,
      0.979198,
      4,
      1.710305,
      0,
      0.971605,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.990155,
      3.467137,
      3.602781,
      1.219248,
      1.296271,
      0,
      2,
      NULL,
      1,
      0.717139,
      NULL,
      0,
      1.553555,
      NULL,
      0.847411,
      2,
      3,
      3,
      0.300604,
      0.343285,
      0.219500,
      4,
      0.622900,
      3,
      0.585281,
      1.313351,
      NULL,
      NULL,
      1.868738,
      NULL,
      NULL,
      2,
      1.849248,
      NULL,
      1.434654,
      2.966241,
      5,
      5.022544,
      NULL,
      0,
      0,
      1.500460,
      0.577210,
      0.742429,
      NULL,
      0.175115,
      1,
      NULL,
      0,
      2,
      0,
      0,
      1.439379,
      1.754410,
      NULL,
      NULL,
      1.008594,
      4,
      0.766384,
      1.798970,
      NULL,
      0,
      NULL,
      0.259612,
      0.110357,
      NULL,
      1.183891,
      9,
      4.523391,
      NULL,
      5,
      NULL,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      '11-11-2002',
      20.438772,
      ' 5- 1-1996',
      NULL,
      2,
      0.678882,
      0,
      8.449941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.136157,
      0.820592,
      1,
      1.685527,
      1,
      0.824229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556324,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241603,
      NULL,
      NULL,
      3.054921,
      1.466151,
      2,
      NULL,
      2.294530,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.165693,
      3.674646,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835897,
      1.862562,
      1.126540,
      1.935068,
      0,
      1,
      1,
      NULL,
      0.442524,
      0,
      8.818456,
      NULL,
      7.867770,
      3.397223,
      NULL,
      1,
      1,
      0,
      2.268192,
      NULL,
      2,
      3.008696,
      1,
      2,
      3.075424,
      0,
      NULL,
      0.203716,
      10,
      1.163331,
      0,
      NULL,
      29,
      36.819239,
      44.246822,
      NULL,
      0.748843,
      0.820847,
      0,
      NULL,
      1,
      2,
      NULL,
      7,
      NULL,
      NULL,
      2.676827,
      2.808386,
      2,
      3.980021,
      NULL,
      5.718960,
      NULL,
      5,
      3,
      2,
      3,
      27,
      NULL,
      1.169316,
      9,
      NULL,
      NULL,
      NULL,
      3.289268,
      1,
      1,
      '23414',
      '',
      '',
      0.407277,
      '',
      '',
      '',
      1.508201,
      NULL,
      '',
      '',
      0,
      20.182873,
      85.634463,
      4.163256,
      2,
      NULL,
      NULL,
      6,
      3.172863,
      3,
      1,
      0.756481,
      0.051849,
      NULL,
      NULL,
      0.270844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.533310,
      2.783032,
      2.212588,
      1.226544,
      1,
      2.950631,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068337,
      0,
      3,
      2.158714,
      0,
      3.685342,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.379163,
      8,
      5,
      0.844410,
      1.951583,
      NULL,
      NULL,
      NULL,
      1.882636,
      NULL,
      NULL,
      NULL,
      3.184509,
      NULL,
      3.284507,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.606992,
      1.798509,
      2,
      3.920654,
      0.682002,
      NULL,
      1,
      1.147918,
      0.538159,
      1,
      0,
      1,
      1,
      0.821021,
      2.312003,
      1,
      NULL,
      NULL,
      1.100502,
      NULL,
      NULL,
      2.360012,
      1,
      0.158953,
      10,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.343540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492915,
      NULL,
      NULL,
      0,
      1.605434,
      NULL,
      1.338299,
      NULL,
      NULL,
      4,
      NULL,
      3.729677,
      NULL,
      1,
      1.563411,
      1,
      NULL,
      NULL,
      7.679647,
      NULL,
      5,
      0.429224,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.115637,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.237858,
      NULL,
      NULL,
      1.355175,
      NULL,
      NULL,
      NULL,
      1.456142,
      NULL,
      0.410410,
      NULL,
      NULL,
      2,
      5.500128,
      4.332044,
      1.771986,
      NULL,
      NULL,
      0.273792,
      NULL,
      NULL,
      1.016651,
      2,
      0,
      2,
      2.686093,
      NULL,
      NULL,
      NULL,
      2,
      5.054303,
      2.427538,
      6,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      1.916950,
      3,
      NULL,
      3.356951,
      3,
      1.174159,
      9.603776,
      NULL,
      NULL,
      6,
      5,
      5.910040,
      0,
      NULL,
      0.701092,
      1.131861,
      1,
      0.501187,
      0.479088,
      1,
      1,
      NULL,
      NULL,
      1.890985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.949950,
      NULL,
      NULL,
      1.755600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      3,
      0.056160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.854899,
      NULL,
      NULL,
      NULL,
      0.733694,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.069761,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.397014,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.978704,
      NULL,
      NULL,
      NULL,
      1.682935,
      NULL,
      NULL,
      NULL,
      3.600094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372968,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      91.608185,
      74.309089,
      3.913672,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.181220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      783,
      12.147667,
      1,
      1,
      NULL,
      0.563535,
      0.551719,
      1,
      1,
      0.967885,
      0.436993,
      1,
      0.756436,
      0.284400,
      0.744865,
      0.887239,
      NULL,
      1.612829,
      1.907896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.986880,
      NULL,
      0.263576,
      NULL,
      0.388867,
      NULL,
      1.189085,
      1.632154,
      2.348840,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.866927,
      1,
      0.797343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.607855,
      1,
      1.819877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.279371,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.116799,
      NULL,
      2,
      NULL,
      3,
      NULL,
      24,
      NULL,
      2.794661,
      NULL,
      0.788617,
      NULL,
      0,
      1.821220,
      1.968455,
      NULL,
      25.494190,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.305769,
      0.918001,
      NULL,
      0.968542,
      3,
      NULL,
      1,
      0.858323,
      0,
      1,
      NULL,
      NULL,
      1,
      0.550650,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      0,
      1.996732,
      NULL,
      0,
      0.063704,
      NULL,
      0.420678,
      NULL,
      NULL,
      0.618314,
      1,
      NULL,
      NULL,
      0.382175,
      NULL,
      NULL,
      1.394960,
      NULL,
      1,
      NULL,
      NULL,
      1.195704,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.755732,
      NULL,
      4,
      0.336729,
      8.048508,
      1,
      NULL,
      NULL,
      NULL,
      33.143482,
      2.992181,
      5.647530,
      7.133937,
      '32302',
      '21423',
      '33043',
      1,
      '',
      NULL,
      NULL,
      0.506987,
      NULL,
      '',
      '');
commit;
end;
/


