set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9333174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '2001104',
      2,
      1,
      6,
      NULL,
      '0343',
      3.665922,
      1,
      NULL,
      NULL,
      ' 3-20-1975',
      56,
      NULL,
      1,
      3.734200,
      1,
      '10- 1-1987',
      32.073880,
      0.970369,
      31,
      58,
      3,
      ' 0-21-2003',
      ' 0-13-1980',
      NULL,
      NULL,
      NULL,
      0.069082,
      1.267460,
      0,
      0.612826,
      0.205400,
      1.346187,
      NULL,
      NULL,
      4.506009,
      NULL,
      NULL,
      NULL,
      14.499899,
      4.158662,
      26.589125,
      4.293169,
      1,
      1,
      0.497618,
      3.688808,
      1.024194,
      1,
      0,
      1.452010,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      4.375973,
      NULL,
      0.129514,
      0.753232,
      1,
      7.702236,
      4.991053,
      0,
      6,
      0,
      1,
      0,
      1.397266,
      NULL,
      4.318915,
      0.177831,
      2,
      NULL,
      0.536093,
      0,
      NULL,
      NULL,
      0.793497,
      NULL,
      NULL,
      1.635876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.723596,
      1,
      0.465750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022618,
      1,
      0.751464,
      1.815142,
      1,
      3,
      1,
      NULL,
      1.481274,
      NULL,
      1,
      1.340776,
      0.781440,
      2.480195,
      0.291099,
      1.241225,
      1.900605,
      0,
      NULL,
      NULL,
      1.477042,
      0,
      0,
      NULL,
      1.464093,
      1.793173,
      4,
      0.033155,
      2,
      5.924984,
      NULL,
      1.591988,
      1,
      0.888942,
      4.337755,
      1.372827,
      0.880287,
      3,
      4.033681,
      NULL,
      1,
      NULL,
      4,
      NULL,
      5.857754,
      1,
      4.081419,
      NULL,
      '10-19-1981',
      NULL,
      ' 7-22-1996',
      69,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916954,
      NULL,
      0,
      0.307610,
      0.587034,
      0.818442,
      0.566390,
      1.419831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131921,
      2.048639,
      0.716371,
      NULL,
      0.487862,
      NULL,
      NULL,
      1.249430,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      0.190720,
      0.847121,
      1,
      3,
      12.030212,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.678987,
      0,
      0,
      1,
      5,
      1,
      NULL,
      2,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      1.351338,
      0.708989,
      0,
      1.695046,
      1.403807,
      1.294916,
      1,
      0,
      0.335051,
      1.027575,
      1.829082,
      1.828643,
      2.140033,
      NULL,
      0.048458,
      7.214440,
      9.609080,
      5,
      0,
      NULL,
      3,
      0,
      0.816433,
      4,
      1.607457,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      23.331219,
      54,
      NULL,
      1.840021,
      1,
      1.335424,
      '22313',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3.726422,
      41.566701,
      26,
      40.212092,
      3,
      45,
      0.973077,
      0.210524,
      0.072608,
      2.663961,
      2.577703,
      1.396900,
      1,
      NULL,
      NULL,
      0.181289,
      0,
      1,
      3,
      2.806625,
      2.244526,
      NULL,
      3,
      3.895679,
      1.728853,
      NULL,
      NULL,
      1,
      NULL,
      3.385874,
      1.792661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.703743,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812548,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.082360,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.307734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.475419,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379258,
      NULL,
      NULL,
      2.785892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412016,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.423434,
      NULL,
      NULL,
      1.318526,
      NULL,
      NULL,
      3,
      1,
      0.894539,
      1,
      NULL,
      NULL,
      5,
      1.015227,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      3,
      3,
      1.008947,
      0,
      4,
      3,
      4.792201,
      2.110457,
      NULL,
      1.712993,
      3,
      1.527438,
      NULL,
      3,
      NULL,
      1,
      3,
      2.805811,
      3,
      6.899129,
      1,
      6,
      3,
      5.653341,
      0.477375,
      0.524766,
      0.534497,
      5.434966,
      0.908740,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.586016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062054,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.422694,
      NULL,
      NULL,
      3.904657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492490,
      1.829235,
      0,
      1,
      0.418132,
      0.878530,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048554,
      NULL,
      NULL,
      NULL,
      3.091092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.676050,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.643956,
      NULL,
      NULL,
      1,
      1.410791,
      NULL,
      NULL,
      0.576460,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.905641,
      NULL,
      NULL,
      1.999095,
      NULL,
      1,
      NULL,
      1.093145,
      1,
      1,
      0.790051,
      3.934674,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.537003,
      0.187788,
      0,
      1,
      1,
      0,
      0,
      3.129172,
      NULL,
      0.284470,
      NULL,
      1.339630,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      15,
      NULL,
      2,
      22.794076,
      28.323972,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.470006,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.752372,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.314004,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.481966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.776458,
      2.011206,
      1,
      0,
      NULL,
      2,
      5.054211,
      3.374744,
      2,
      2.408138,
      0.852041,
      1,
      1.183451,
      NULL,
      0.890081,
      0.328859,
      NULL,
      1.742815,
      1.609964,
      NULL,
      0.621240,
      0,
      NULL,
      1.009158,
      2,
      NULL,
      1,
      1,
      NULL,
      1.798435,
      0,
      NULL,
      1.759386,
      0,
      NULL,
      1.104258,
      1,
      NULL,
      0.371982,
      0.911625,
      NULL,
      1.039324,
      0,
      NULL,
      1,
      0.070049,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257355,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.637978,
      NULL,
      NULL,
      3,
      93,
      1.260349,
      1.604551,
      0.633239,
      NULL,
      '41203',
      '',
      NULL,
      '',
      '',
      '',
      0.201844,
      NULL,
      '',
      '');
commit;
end;
/


