set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '3024312',
      2.070670,
      0,
      NULL,
      2,
      '4422',
      0.812001,
      1,
      NULL,
      NULL,
      ' 2-22-2000',
      28,
      NULL,
      NULL,
      1.442065,
      1.326292,
      NULL,
      48,
      3.485952,
      0,
      137.796678,
      3,
      ' 5- 5-1976',
      ' 7-25-1984',
      ' 1-23-1981',
      NULL,
      NULL,
      3.790930,
      1.598938,
      1.248919,
      3.793591,
      9.796082,
      1,
      0.354965,
      NULL,
      10,
      0.203795,
      NULL,
      NULL,
      116,
      0.246269,
      NULL,
      0.729520,
      1.303200,
      5,
      0.721397,
      NULL,
      2.474579,
      1.055126,
      1.298644,
      0,
      NULL,
      1.278437,
      4.652790,
      0.512066,
      0,
      NULL,
      2,
      5.174119,
      2.571149,
      2,
      1,
      1,
      1,
      1.397577,
      1.156806,
      3,
      NULL,
      2,
      0.362567,
      0,
      2,
      9.115707,
      1,
      NULL,
      NULL,
      0.387988,
      1,
      NULL,
      NULL,
      0.910470,
      NULL,
      NULL,
      8,
      8.792973,
      NULL,
      3,
      0,
      0.239066,
      3,
      3.427753,
      1.937282,
      0,
      3,
      1.197407,
      1.537628,
      NULL,
      NULL,
      2.823612,
      1,
      3.996649,
      3.313678,
      0,
      1,
      2,
      6.908492,
      NULL,
      NULL,
      1.991372,
      NULL,
      NULL,
      NULL,
      0.671042,
      NULL,
      NULL,
      1.233296,
      3,
      8,
      0.091117,
      1.701087,
      0,
      1,
      1.066644,
      NULL,
      1.020645,
      NULL,
      1,
      0,
      NULL,
      0,
      1.224644,
      1.413990,
      0,
      3,
      NULL,
      1,
      2.257001,
      1,
      1,
      3,
      0.791758,
      NULL,
      0.031086,
      3.556487,
      3.560965,
      0.427657,
      0.114405,
      5.387005,
      5,
      0,
      NULL,
      9,
      11.001616,
      10.240552,
      0,
      NULL,
      NULL,
      3.019957,
      4.664875,
      1,
      2,
      NULL,
      3,
      ' 4- 9-1986',
      1251.891121,
      ' 3-13-1995',
      680.909227,
      NULL,
      0,
      NULL,
      5,
      1.289320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.989778,
      0,
      1,
      NULL,
      0,
      NULL,
      0.531141,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839158,
      NULL,
      NULL,
      NULL,
      NULL,
      3.754039,
      1,
      0.259584,
      0,
      NULL,
      6,
      1.005616,
      1,
      3,
      1.448747,
      NULL,
      3,
      1.813102,
      7.186633,
      4,
      4,
      0,
      2,
      3,
      NULL,
      3,
      1,
      NULL,
      1.168807,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.788921,
      NULL,
      1.869732,
      1,
      1,
      1.392024,
      NULL,
      1,
      59,
      3.351602,
      1.538157,
      NULL,
      NULL,
      NULL,
      2,
      2.395982,
      NULL,
      1.059477,
      3.920868,
      1.718797,
      3.877498,
      3,
      NULL,
      NULL,
      2,
      2,
      2.412711,
      2.118606,
      3.467457,
      NULL,
      7,
      NULL,
      0.003251,
      4.725544,
      0.286309,
      1,
      0.639724,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      1.904664,
      0.653017,
      NULL,
      10,
      11,
      2.830309,
      10.441639,
      2.620078,
      3.933918,
      4.693512,
      2.900663,
      3.825285,
      3,
      NULL,
      NULL,
      22,
      1.226477,
      NULL,
      NULL,
      41,
      15,
      NULL,
      3,
      1.915258,
      1.457378,
      '11133',
      '',
      '',
      1.995006,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      37,
      1,
      24,
      7.805303,
      0,
      0.968753,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989275,
      1,
      NULL,
      0.632053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.747471,
      3.573034,
      3,
      1,
      1.574160,
      NULL,
      0,
      NULL,
      NULL,
      0.220794,
      0,
      0.609450,
      0.696599,
      NULL,
      NULL,
      5.564418,
      7.419530,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.580010,
      NULL,
      NULL,
      NULL,
      3.411885,
      3,
      1.015582,
      NULL,
      0,
      3,
      1.479191,
      2.793178,
      2.371655,
      1.665251,
      NULL,
      1.992006,
      1.919482,
      3,
      2,
      3,
      NULL,
      1,
      2.714673,
      0,
      0.586144,
      0.467078,
      0,
      NULL,
      0.260208,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.704122,
      0.679446,
      1.085946,
      3.299800,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.672051,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.155101,
      1,
      1.073154,
      3.352052,
      0.320746,
      0.530447,
      NULL,
      NULL,
      2,
      NULL,
      2.373288,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.947632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104407,
      NULL,
      NULL,
      1,
      1,
      1,
      1.652681,
      NULL,
      NULL,
      7,
      5.100453,
      1,
      0,
      0,
      2,
      0.107427,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      1.251007,
      3,
      1.857362,
      1.572373,
      NULL,
      4,
      1,
      1.545456,
      1.481443,
      0,
      2,
      0.406511,
      3,
      1.208232,
      2,
      0.346935,
      2.818537,
      NULL,
      NULL,
      0,
      0,
      6,
      9,
      4,
      3.140697,
      2,
      0.982219,
      1.268666,
      8.346545,
      0,
      NULL,
      1.713050,
      1.584423,
      1,
      2.795473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.930440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.775577,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.885547,
      NULL,
      NULL,
      2.987853,
      NULL,
      NULL,
      0.959791,
      1.201635,
      0.747133,
      NULL,
      0,
      2.340763,
      0.143086,
      NULL,
      NULL,
      4.284710,
      NULL,
      NULL,
      NULL,
      1.138297,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.774260,
      NULL,
      NULL,
      NULL,
      1.341995,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.254910,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.878727,
      NULL,
      NULL,
      NULL,
      1.305890,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      2.275527,
      3.644295,
      3.682356,
      2,
      2.321643,
      299,
      6.917478,
      NULL,
      49.973662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.971091,
      0,
      1.185865,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2050,
      6,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0,
      1.509948,
      NULL,
      0,
      NULL,
      0.481317,
      1,
      0.347858,
      0.816665,
      0,
      1,
      1.206827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.396936,
      0,
      3.953535,
      8,
      3.172865,
      NULL,
      4.880335,
      NULL,
      8,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437920,
      0,
      NULL,
      3.723530,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.606723,
      NULL,
      NULL,
      1.951789,
      0,
      NULL,
      1,
      1.846174,
      NULL,
      1,
      0,
      NULL,
      2,
      3.830615,
      NULL,
      1.274128,
      0.677473,
      NULL,
      NULL,
      1.431972,
      1.905971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109639,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      5,
      5,
      2,
      NULL,
      2.828708,
      18.623476,
      43.608337,
      0.784782,
      1.701613,
      2,
      '23103',
      '',
      '',
      1,
      '',
      '',
      '',
      0.497204,
      '',
      '',
      '');
commit;
end;
/


