set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0153407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.476672,
      NULL,
      2.575311,
      NULL,
      1,
      3,
      1.291108,
      2.026404,
      '412',
      '34042121',
      14.980610,
      8.438523,
      NULL,
      2,
      1,
      0,
      2,
      '0414',
      0,
      0,
      NULL,
      NULL,
      NULL,
      10,
      39.623237,
      NULL,
      2,
      5.013900,
      ' 8- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.504680,
      1.208049,
      0.405707,
      1,
      0,
      3,
      NULL,
      1.861686,
      NULL,
      NULL,
      NULL,
      5.669817,
      5.119745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.848846,
      NULL,
      0,
      0,
      0.870660,
      0.622446,
      NULL,
      1,
      1,
      1,
      1.018391,
      NULL,
      NULL,
      5.976189,
      0.326883,
      4.011100,
      NULL,
      1.534162,
      0.744355,
      0.774325,
      1.196925,
      NULL,
      1,
      0.167048,
      0,
      1,
      0,
      7.492755,
      0.703269,
      1,
      2.242337,
      1.171702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.317355,
      0,
      0.787906,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.661746,
      0.706014,
      2,
      0.196534,
      0,
      1.781449,
      0,
      1,
      NULL,
      2.341813,
      1.218619,
      NULL,
      0,
      1.929996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610779,
      1.479457,
      0,
      2.219749,
      1.723349,
      2.590626,
      NULL,
      NULL,
      1,
      1,
      0.911389,
      1,
      1.605268,
      NULL,
      0.506017,
      1,
      NULL,
      1.356996,
      1.197405,
      NULL,
      0,
      NULL,
      4,
      1,
      2,
      1,
      3.298409,
      5,
      0,
      3,
      0,
      5.947347,
      1,
      6,
      4,
      1.643779,
      5,
      1.751473,
      7,
      2,
      1,
      0.826227,
      3.954599,
      6.763095,
      NULL,
      5,
      NULL,
      3,
      ' 8-24-1979',
      93.142627,
      ' 3-24-1978',
      71,
      3,
      1.189931,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.494137,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.771782,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1,
      2.463962,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.863469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.091961,
      0.098825,
      1.367395,
      0.705527,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.764667,
      0.258851,
      3,
      0,
      0,
      NULL,
      3.947783,
      NULL,
      3.570601,
      3,
      1.818917,
      2.062251,
      3,
      NULL,
      0.893663,
      0,
      0,
      2,
      0,
      0.786965,
      0,
      1,
      1.450028,
      0,
      1.231691,
      0,
      0.544337,
      0.143271,
      1,
      NULL,
      NULL,
      0,
      1.489449,
      6.689772,
      3.629056,
      4.451529,
      2.157246,
      NULL,
      4,
      1.167332,
      3,
      1.569565,
      5.361259,
      0.738307,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.196241,
      4,
      1,
      '10041',
      NULL,
      '',
      0.963787,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      20,
      2,
      1.904262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.337795,
      2,
      0.140405,
      0,
      NULL,
      NULL,
      2,
      3,
      0.893705,
      1.690247,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.613453,
      0,
      NULL,
      NULL,
      0.656839,
      NULL,
      NULL,
      1.492835,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      7,
      3.397982,
      0.579595,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.879479,
      1.208391,
      2,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.703483,
      0.092091,
      0,
      0,
      0.945294,
      2.849786,
      0.012737,
      NULL,
      0.716399,
      NULL,
      1.047411,
      1.872502,
      NULL,
      1.891981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954303,
      NULL,
      NULL,
      1,
      2.690750,
      0.799732,
      0,
      0.006192,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162266,
      1.315455,
      1.534472,
      0.246980,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.613805,
      3.481522,
      0,
      2,
      0.498284,
      4.595525,
      1,
      2.215832,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0.734276,
      1,
      NULL,
      NULL,
      0.761054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.574361,
      5.082632,
      4.506949,
      7,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.067102,
      NULL,
      2.511910,
      1,
      0,
      0,
      2.442217,
      5.909016,
      5.594899,
      3.155301,
      2,
      1,
      2.680783,
      0,
      1.866418,
      2,
      NULL,
      NULL,
      3.482573,
      3.937958,
      3.816631,
      8,
      0,
      8,
      NULL,
      1,
      0.319272,
      0.231438,
      NULL,
      NULL,
      NULL,
      0.679701,
      NULL,
      1.135291,
      NULL,
      0.288811,
      NULL,
      NULL,
      0.365217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401389,
      NULL,
      NULL,
      1.501136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.340209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.558091,
      3,
      0.274245,
      0.158038,
      NULL,
      NULL,
      1.188230,
      NULL,
      NULL,
      6.843188,
      NULL,
      NULL,
      NULL,
      15.899171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.967668,
      NULL,
      NULL,
      NULL,
      0.550163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.024553,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.058152,
      NULL,
      NULL,
      NULL,
      3.993390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194738,
      1.979921,
      3.601529,
      28.584180,
      2,
      NULL,
      NULL,
      NULL,
      0.726279,
      NULL,
      NULL,
      NULL,
      2.648376,
      1.014637,
      0.545685,
      NULL,
      NULL,
      1.523951,
      NULL,
      0.103006,
      0.349590,
      0,
      1.779781,
      1.753234,
      1.254786,
      1,
      1,
      1.154022,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.632290,
      NULL,
      0,
      0.913364,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      1,
      NULL,
      NULL,
      2,
      4,
      12.967209,
      0.255275,
      3.460030,
      1.246143,
      NULL,
      0,
      NULL,
      0.901887,
      2,
      NULL,
      0.546878,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.648648,
      NULL,
      0.292583,
      1.424337,
      NULL,
      1.740911,
      NULL,
      NULL,
      0,
      0.965837,
      NULL,
      1.535449,
      0.776840,
      NULL,
      0.759660,
      NULL,
      NULL,
      1.353887,
      1.262611,
      NULL,
      0,
      0,
      0.968988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.716554,
      5,
      6,
      0,
      NULL,
      NULL,
      12.184851,
      87.204653,
      0.121248,
      3.878348,
      2.108134,
      '41403',
      '',
      '',
      1.060892,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '');
commit;
end;
/


