set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '1230132',
      2.117088,
      0.629032,
      2,
      NULL,
      '1341',
      NULL,
      1.506394,
      NULL,
      NULL,
      ' 5-28-2002',
      36,
      NULL,
      3,
      NULL,
      0,
      ' 7- 1-1977',
      50.838227,
      0,
      259,
      0,
      3,
      ' 9-19-1985',
      NULL,
      ' 9- 4-1992',
      NULL,
      2.830842,
      0,
      0,
      1,
      1,
      2,
      1.257798,
      0.122601,
      121,
      0.065164,
      NULL,
      5.904822,
      13.686419,
      8,
      5.726410,
      7,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.238917,
      14,
      1.098753,
      3,
      NULL,
      0,
      0.337791,
      1.118823,
      0.918527,
      NULL,
      1.863608,
      0.879268,
      1.780785,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958070,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.327397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843595,
      4,
      1.934950,
      7,
      3,
      2.522617,
      4,
      0.195384,
      NULL,
      0.557021,
      1,
      0,
      1,
      2,
      0.545376,
      4.073564,
      1.511216,
      1.909103,
      5.550180,
      0.140089,
      4,
      8.691508,
      NULL,
      0,
      0.848812,
      3.429761,
      NULL,
      6,
      1.086088,
      8,
      0,
      1,
      0,
      5,
      5,
      NULL,
      NULL,
      3.525860,
      NULL,
      NULL,
      5,
      NULL,
      9,
      4,
      NULL,
      5,
      4.926963,
      1.300554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.883683,
      1,
      1.513936,
      1.378940,
      0.832697,
      0.122208,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.835512,
      6.432674,
      4,
      0.301399,
      4.906236,
      0,
      NULL,
      NULL,
      NULL,
      1.105542,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.998603,
      0.776864,
      1,
      0,
      2,
      51,
      1,
      0.107290,
      NULL,
      5.162771,
      NULL,
      1.760234,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      2.181626,
      1,
      3,
      2.527608,
      2,
      1.725977,
      0,
      2.611431,
      1,
      NULL,
      1.878953,
      0.909757,
      2,
      0,
      0,
      0,
      NULL,
      1.455761,
      1,
      0,
      1,
      0,
      0,
      1,
      1.079916,
      NULL,
      0,
      NULL,
      9.685541,
      6,
      2,
      2,
      1.329651,
      4,
      NULL,
      2.651978,
      1.174542,
      21.804094,
      2,
      NULL,
      NULL,
      34.356587,
      32,
      NULL,
      2,
      1,
      NULL,
      '32242',
      '',
      NULL,
      2,
      '34342',
      '',
      NULL,
      0.116023,
      '',
      '',
      '',
      3,
      27,
      112,
      28.779835,
      1,
      32,
      3.403754,
      6,
      0.668748,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827872,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318140,
      1,
      NULL,
      NULL,
      1.508438,
      NULL,
      NULL,
      0.836300,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540340,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.548786,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.074837,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.743343,
      0.148244,
      0.789402,
      0.959619,
      1.241900,
      7.447606,
      3.157403,
      0,
      NULL,
      1.686561,
      NULL,
      NULL,
      4.906666,
      1.378743,
      0,
      0.452188,
      NULL,
      2.897051,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.234482,
      0,
      3.705397,
      NULL,
      3.530282,
      NULL,
      2,
      0,
      NULL,
      NULL,
      8,
      2.786260,
      2.471933,
      7,
      3,
      7,
      4,
      1,
      0,
      2,
      3.017887,
      0,
      3.247144,
      2.388646,
      NULL,
      2,
      NULL,
      1,
      8.420620,
      5.270769,
      5.179812,
      3.377932,
      3.491657,
      2.134918,
      NULL,
      3.861430,
      3,
      2.127965,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      9.221444,
      7.052221,
      NULL,
      NULL,
      2,
      3.505997,
      NULL,
      3,
      3.398851,
      1,
      1.931966,
      0.205467,
      1.477451,
      3.782332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.554305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1.124170,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      2.188484,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.028565,
      1.711067,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.327539,
      8.020924,
      1.794163,
      1.123811,
      5,
      4.552840,
      0.772801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359558,
      1.054677,
      1,
      NULL,
      NULL,
      0.213187,
      NULL,
      1,
      6.035112,
      1,
      0.453868,
      1.461484,
      1,
      0.490233,
      0,
      1,
      1.616658,
      NULL,
      NULL,
      0,
      1.449220,
      1,
      1.459386,
      0.676683,
      1.258219,
      0.397575,
      1.912178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.969530,
      2.149935,
      3,
      4,
      1,
      0.882853,
      3.605493,
      3.341581,
      17,
      0,
      NULL,
      0.354229,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.513029,
      1.601747,
      3,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      3.637519,
      3.579896,
      2.128250,
      2,
      3,
      3,
      3,
      1,
      NULL,
      3.071481,
      0,
      0.575985,
      1.083147,
      0,
      1.233669,
      0,
      1,
      1.578641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252663,
      NULL,
      NULL,
      NULL,
      3.151217,
      12.856834,
      NULL,
      1,
      NULL,
      3,
      NULL,
      19.182483,
      1.962388,
      0,
      NULL,
      '03122',
      '',
      '',
      2.301325,
      '44210',
      NULL,
      '',
      0,
      '',
      NULL,
      NULL);
commit;
end;
/


