set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427817';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      NULL,
      30.155722,
      '1234013',
      NULL,
      0.067764,
      3,
      1,
      '3340',
      NULL,
      1,
      NULL,
      NULL,
      ' 9- 6-1988',
      NULL,
      54,
      NULL,
      0.121765,
      0,
      '10-22-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 3-28-1986',
      ' 3- 8-1983',
      NULL,
      0.115258,
      3.731227,
      2.462781,
      1.978461,
      1,
      NULL,
      3,
      NULL,
      NULL,
      52.978326,
      1,
      13.380626,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896336,
      3,
      NULL,
      0.827019,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1.638567,
      0,
      4,
      NULL,
      2,
      2,
      2.415004,
      3,
      4.409065,
      1,
      0.208328,
      1,
      3.048178,
      1,
      7,
      0.727497,
      2,
      NULL,
      0.405023,
      2,
      NULL,
      3.950334,
      NULL,
      3,
      NULL,
      0.947629,
      NULL,
      NULL,
      0.635615,
      NULL,
      NULL,
      1.579934,
      0,
      2,
      1.890464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825022,
      NULL,
      0,
      3.717328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      NULL,
      0,
      8.886850,
      2.982850,
      3,
      1,
      1.776462,
      0.938892,
      5,
      0.757811,
      1.436626,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528743,
      8.007518,
      4,
      0,
      0,
      0.363181,
      6,
      4.828209,
      0,
      1,
      7,
      7,
      6.854380,
      4.738536,
      NULL,
      2,
      9.789568,
      NULL,
      NULL,
      9,
      NULL,
      9,
      NULL,
      2,
      7.500267,
      0.655733,
      5.745221,
      NULL,
      '10-26-1989',
      NULL,
      '11-21-1994',
      35,
      3.807623,
      0.967180,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387093,
      0.240678,
      4,
      4,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.433466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      2,
      1.305101,
      NULL,
      0.231414,
      2.464304,
      0,
      3,
      7.008106,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.916234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.383943,
      1,
      0,
      0,
      0.044645,
      NULL,
      3.501414,
      13,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.425102,
      2.123182,
      0,
      1,
      1.819133,
      0,
      1,
      0.367279,
      0,
      3.655132,
      NULL,
      1.528880,
      3,
      1.886954,
      0,
      1.735731,
      0.621218,
      1,
      1,
      1,
      1,
      1.885415,
      1,
      1,
      0,
      0.297703,
      1,
      0,
      1,
      5,
      NULL,
      NULL,
      9,
      8,
      3,
      5,
      2,
      3.050450,
      1,
      1.067665,
      0.936233,
      38,
      0,
      2,
      60.269988,
      NULL,
      63,
      36,
      NULL,
      5.004501,
      NULL,
      '30123',
      '',
      NULL,
      1.138145,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2,
      30,
      NULL,
      24,
      NULL,
      17,
      3,
      3.936848,
      3,
      2.712219,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331401,
      2.857178,
      1.060502,
      0,
      2.504064,
      2.530061,
      1,
      NULL,
      NULL,
      3.393020,
      3.826095,
      0.689790,
      0.683482,
      NULL,
      NULL,
      0.853017,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.350648,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      5,
      6.341855,
      3,
      1.535724,
      NULL,
      NULL,
      NULL,
      1.002794,
      NULL,
      NULL,
      NULL,
      0.364817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.099393,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.191977,
      NULL,
      0.303541,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      5.537283,
      1.047630,
      3.292111,
      2.012912,
      1.494937,
      NULL,
      NULL,
      4,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.509540,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      7,
      4,
      0,
      6,
      3.885831,
      1.095047,
      0,
      3,
      2.016699,
      2,
      3.893304,
      1,
      1,
      0,
      2,
      1.352679,
      1.400064,
      NULL,
      3,
      3,
      0,
      1.951698,
      2.681561,
      NULL,
      2,
      3.509649,
      3,
      0,
      1.816585,
      NULL,
      NULL,
      5.876273,
      5,
      6.747690,
      2,
      2.091862,
      0.714288,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898744,
      NULL,
      NULL,
      1.934914,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.799800,
      NULL,
      NULL,
      2.571741,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.493966,
      NULL,
      NULL,
      1.006183,
      1.324564,
      0,
      1,
      1,
      1.614498,
      1.327057,
      NULL,
      NULL,
      0.371380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.899577,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.780825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015201,
      NULL,
      NULL,
      NULL,
      3.950643,
      NULL,
      NULL,
      NULL,
      1.358097,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.321868,
      NULL,
      NULL,
      NULL,
      2.187464,
      NULL,
      NULL,
      2,
      4,
      251.643188,
      1.566205,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.354258,
      NULL,
      NULL,
      1.739874,
      NULL,
      1.153009,
      1,
      2198,
      NULL,
      1,
      1,
      0,
      1,
      1.910308,
      1,
      NULL,
      1,
      NULL,
      1.868285,
      0.518924,
      NULL,
      0,
      1,
      NULL,
      1.978068,
      1.970691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.355421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153866,
      1.030052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312676,
      1,
      NULL,
      0,
      NULL,
      1.871377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625307,
      NULL,
      1.527082,
      NULL,
      NULL,
      1.800790,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.525278,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400645,
      0,
      3,
      NULL,
      1,
      NULL,
      1.435228,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.286917,
      1.689504,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      10,
      3.032343,
      1,
      3,
      5,
      14.530101,
      2.971247,
      3,
      NULL,
      1.681399,
      1,
      NULL,
      NULL,
      0.445888,
      NULL,
      NULL,
      0.681048,
      NULL,
      0,
      1,
      NULL,
      0.807992,
      1,
      NULL,
      0,
      1.709064,
      NULL,
      0,
      2.423943,
      NULL,
      NULL,
      NULL,
      NULL,
      0.715615,
      0,
      NULL,
      0.593451,
      0.712379,
      NULL,
      1.327589,
      2.910601,
      NULL,
      2.575555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      9,
      1.372197,
      4,
      2.796042,
      1.205469,
      3.696720,
      19,
      76,
      4.677013,
      NULL,
      0.091711,
      '04242',
      NULL,
      '',
      1.056394,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


