set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433921';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      1,
      1.397766,
      NULL,
      1,
      '3011',
      1.655294,
      0,
      NULL,
      NULL,
      ' 3-25-1982',
      5,
      NULL,
      0,
      0,
      2.904307,
      ' 8-22-1975',
      36,
      0,
      208,
      42.551748,
      3.125882,
      ' 9- 0-1988',
      ' 5-14-1976',
      ' 8-11-1981',
      3,
      0,
      2.392566,
      2,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252044,
      2.138869,
      8,
      1,
      2,
      6,
      4.242015,
      2.423750,
      9.160359,
      0.085593,
      1.564990,
      0,
      1,
      0.610035,
      NULL,
      0.104890,
      NULL,
      1,
      1,
      1.336222,
      1.010084,
      5.884781,
      2,
      0,
      4.934870,
      NULL,
      0,
      NULL,
      6.831300,
      NULL,
      3,
      1.308657,
      1.389721,
      0.583685,
      NULL,
      0,
      6.134976,
      1.115982,
      2.138091,
      0,
      2.529854,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.095725,
      0.197028,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.267865,
      3,
      1,
      2.564334,
      0.102549,
      1.427260,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.457947,
      NULL,
      0,
      1.604072,
      0.400402,
      NULL,
      1.784653,
      1,
      1,
      1.123911,
      0,
      1,
      1.257791,
      3.135962,
      1.092909,
      0,
      1.868412,
      1,
      1,
      0,
      0,
      1.303759,
      2.297141,
      1.328059,
      3,
      4,
      NULL,
      7,
      0.737455,
      NULL,
      0,
      0.998327,
      0.408895,
      2,
      ' 4- 9-1998',
      NULL,
      ' 9-20-2003',
      28.626106,
      1.086690,
      NULL,
      1.398937,
      7,
      1.848533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145251,
      0,
      NULL,
      3,
      NULL,
      1.503735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.836260,
      NULL,
      0.311722,
      1.208999,
      0.247399,
      1.575452,
      NULL,
      NULL,
      NULL,
      1.778749,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.239192,
      0.699835,
      3.114127,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3.087253,
      NULL,
      2.817327,
      0.043997,
      1,
      1,
      NULL,
      1.435345,
      NULL,
      3,
      1,
      0.575456,
      NULL,
      7,
      NULL,
      1,
      5.167875,
      1.783132,
      1,
      0.891843,
      1.652040,
      0,
      1.243488,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.978159,
      8.177043,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4.371758,
      2.278928,
      2,
      2.638242,
      0,
      3.815059,
      20,
      NULL,
      NULL,
      NULL,
      69.839385,
      50,
      46,
      4.300113,
      5.606980,
      2.347313,
      NULL,
      '',
      '',
      1.827654,
      '',
      NULL,
      '',
      1.558309,
      '',
      '',
      '',
      0.963683,
      13.618294,
      20.099926,
      NULL,
      NULL,
      26.774165,
      NULL,
      NULL,
      1,
      3.483354,
      0,
      NULL,
      1.605933,
      NULL,
      NULL,
      1.237725,
      NULL,
      NULL,
      1,
      0,
      2,
      2.968069,
      1.318197,
      3,
      1,
      NULL,
      NULL,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      0.339568,
      NULL,
      NULL,
      0.457919,
      NULL,
      NULL,
      1.514863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.321175,
      5.821074,
      1.337761,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.745365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557557,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      NULL,
      1.946205,
      0.749970,
      NULL,
      NULL,
      2.999326,
      NULL,
      3.062463,
      NULL,
      NULL,
      NULL,
      0.762008,
      NULL,
      NULL,
      0.669289,
      NULL,
      NULL,
      1.626860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.118602,
      NULL,
      NULL,
      1.948087,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.420756,
      NULL,
      NULL,
      5.556669,
      5,
      4,
      1,
      NULL,
      NULL,
      1.413779,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.015924,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.918576,
      1,
      1,
      1,
      0.775177,
      3,
      NULL,
      0,
      1,
      2.779469,
      1,
      1.877182,
      7,
      5.285244,
      5,
      NULL,
      NULL,
      NULL,
      1,
      2,
      6,
      1,
      0,
      1.451572,
      0.485361,
      NULL,
      1,
      NULL,
      NULL,
      1.058826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295735,
      NULL,
      NULL,
      0.568073,
      NULL,
      NULL,
      0.047152,
      NULL,
      NULL,
      1.740635,
      NULL,
      NULL,
      0.114251,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.545170,
      NULL,
      NULL,
      0.694793,
      0.298047,
      0.125515,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1.731032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.273758,
      NULL,
      NULL,
      NULL,
      2.560142,
      NULL,
      NULL,
      NULL,
      0.729682,
      NULL,
      NULL,
      NULL,
      1.587096,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.488770,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2.823394,
      1.571241,
      NULL,
      NULL,
      1.362653,
      NULL,
      NULL,
      0.536740,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      47.582148,
      1,
      0.342493,
      0.950543,
      0,
      0,
      0.540468,
      1,
      0.303725,
      0.829822,
      1.590757,
      0,
      NULL,
      1,
      1,
      0,
      0.701525,
      1.124017,
      NULL,
      1.982086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564473,
      3.252254,
      0.840771,
      3,
      1,
      1.637773,
      0.924313,
      4,
      4,
      NULL,
      3.845763,
      1,
      0.642911,
      3.351327,
      NULL,
      0.043686,
      3.092150,
      NULL,
      1,
      2,
      NULL,
      0.811232,
      0.341827,
      NULL,
      0.865607,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.776478,
      0.797542,
      NULL,
      0,
      3,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0.869575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579176,
      NULL,
      0.327000,
      NULL,
      1.661055,
      NULL,
      2.927326,
      4,
      2.415550,
      0,
      NULL,
      NULL,
      35.138219,
      76.307583,
      1.615519,
      1,
      2.721895,
      '13221',
      '',
      '',
      1.775748,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


