set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734866';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '0213103',
      2,
      0,
      1,
      0,
      '0421',
      0,
      1,
      NULL,
      NULL,
      '11-18-1985',
      88,
      NULL,
      1.397326,
      NULL,
      1.044962,
      '11-22-1994',
      19,
      0.100303,
      356.040476,
      84,
      0.648555,
      '11-16-1974',
      NULL,
      NULL,
      1.558982,
      2.770297,
      2.664860,
      2.821591,
      1,
      NULL,
      NULL,
      NULL,
      0.241128,
      33,
      1.427797,
      7.527223,
      8.981621,
      21.600810,
      12.603304,
      6,
      13.352119,
      NULL,
      1,
      4,
      3.894957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.628035,
      3,
      0.810400,
      1,
      0.390910,
      1.379905,
      0.569134,
      1.412506,
      2,
      3,
      1,
      NULL,
      3,
      2,
      3,
      NULL,
      1,
      0.757891,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.529775,
      NULL,
      NULL,
      3,
      3.449548,
      0.447595,
      2.406128,
      1.737000,
      NULL,
      NULL,
      NULL,
      0.489954,
      2.925307,
      0,
      NULL,
      1,
      2.729454,
      0.767885,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.956966,
      1.531015,
      1.990561,
      NULL,
      NULL,
      1,
      0.400255,
      1,
      2,
      4.785231,
      0.348480,
      NULL,
      1,
      1.679403,
      1.170432,
      1,
      0.142108,
      NULL,
      1.554300,
      NULL,
      0.890206,
      NULL,
      3,
      NULL,
      2.670908,
      6.216055,
      1.867501,
      3,
      3,
      2.466596,
      1,
      0.251387,
      2.029983,
      2.703680,
      2,
      7,
      NULL,
      0.735227,
      2.209825,
      0,
      NULL,
      2,
      6,
      4.463679,
      7,
      0,
      ' 9-26-1976',
      244,
      ' 5-14-1976',
      167,
      0.280146,
      0.750069,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.738481,
      0,
      0.781491,
      0.976261,
      2.463407,
      0,
      0.424521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.032355,
      7.254018,
      2.975004,
      1.251969,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0.142792,
      1.928841,
      1.330988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.143631,
      1,
      1,
      2.768430,
      0.518214,
      NULL,
      0,
      3,
      47.070900,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632980,
      1.305754,
      NULL,
      1.804255,
      NULL,
      0.934240,
      2.693616,
      NULL,
      3,
      1,
      0,
      3,
      3.779891,
      2.022659,
      2.872763,
      0.488955,
      NULL,
      0,
      NULL,
      0.565682,
      1.548755,
      NULL,
      1.756938,
      0.136386,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850048,
      0,
      NULL,
      4,
      NULL,
      NULL,
      8.622356,
      3.650602,
      NULL,
      0.990876,
      3.098262,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      2.837567,
      NULL,
      4.427915,
      32.801303,
      27,
      2.425009,
      5.153022,
      2,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.320137,
      '',
      '',
      '',
      0,
      0,
      229.600657,
      28.472754,
      0.254427,
      45.278848,
      NULL,
      5.297838,
      2.566560,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.057147,
      1.552154,
      1.579704,
      0.090705,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.569968,
      0,
      1.765386,
      0.679383,
      0.897770,
      1,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.748926,
      0,
      NULL,
      NULL,
      NULL,
      1.157455,
      NULL,
      NULL,
      NULL,
      NULL,
      2.974210,
      0.802767,
      2,
      1,
      NULL,
      0,
      0,
      1.003973,
      0,
      1,
      0.538751,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      2,
      3,
      NULL,
      2,
      3,
      0.418704,
      NULL,
      1.275854,
      0,
      1.617836,
      1.477553,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.460355,
      NULL,
      0.317521,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.282943,
      NULL,
      NULL,
      0.725257,
      NULL,
      NULL,
      1,
      0,
      1.006721,
      0,
      NULL,
      NULL,
      2,
      1.601826,
      NULL,
      2,
      2.270833,
      1.480937,
      NULL,
      1,
      NULL,
      4.571763,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335007,
      NULL,
      NULL,
      1.228749,
      NULL,
      NULL,
      2.840219,
      2,
      NULL,
      1.687913,
      0,
      3,
      7.230488,
      1.558714,
      3.848114,
      5,
      4.572257,
      1.936854,
      0,
      NULL,
      NULL,
      3.281172,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      4,
      0.136906,
      0,
      1,
      0,
      NULL,
      3.828437,
      NULL,
      1,
      1,
      3,
      NULL,
      2,
      NULL,
      4.147685,
      NULL,
      NULL,
      3.728891,
      NULL,
      NULL,
      1,
      7,
      1,
      1,
      1.577888,
      NULL,
      0.596426,
      1.375605,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.775663,
      NULL,
      NULL,
      0.172101,
      NULL,
      NULL,
      1.599068,
      NULL,
      NULL,
      0.490689,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.200428,
      NULL,
      NULL,
      1.673578,
      NULL,
      NULL,
      1.102080,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015360,
      1.773995,
      NULL,
      1,
      NULL,
      3,
      0.324870,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069226,
      1.205572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964462,
      0,
      NULL,
      NULL,
      1.372129,
      1.498364,
      NULL,
      NULL,
      NULL,
      2.296671,
      NULL,
      NULL,
      1.338740,
      0.941525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.361940,
      0.538070,
      NULL,
      NULL,
      0,
      NULL,
      7,
      3.562422,
      3.570121,
      140.802191,
      1,
      0.383956,
      157,
      10.573437,
      NULL,
      NULL,
      NULL,
      1,
      34,
      NULL,
      1,
      35.338151,
      29.857134,
      NULL,
      NULL,
      NULL,
      0.860310,
      NULL,
      1.398316,
      112,
      2.360129,
      1,
      NULL,
      0,
      1,
      0.484937,
      NULL,
      1,
      NULL,
      1.182438,
      0.935750,
      1,
      1.549352,
      1.922274,
      1,
      1.639429,
      1.422281,
      NULL,
      0.759252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.338649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187141,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.016984,
      NULL,
      0.699349,
      NULL,
      NULL,
      NULL,
      1.373085,
      0.825311,
      1.843014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240827,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.154408,
      NULL,
      3,
      NULL,
      1.623560,
      NULL,
      247.985365,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0.447702,
      1,
      31.460329,
      22,
      1.645199,
      NULL,
      NULL,
      NULL,
      1.812337,
      1.929519,
      0,
      1.384254,
      0,
      0,
      0,
      NULL,
      1.755925,
      NULL,
      2.101437,
      0,
      1,
      1.576570,
      0.911013,
      1,
      1.644346,
      1.517650,
      NULL,
      3.510911,
      NULL,
      0.634989,
      NULL,
      1.053608,
      0.621252,
      NULL,
      1.859166,
      1,
      1,
      NULL,
      1.726623,
      2.706656,
      0,
      0,
      1,
      0,
      0.173443,
      NULL,
      0,
      0,
      0.792288,
      NULL,
      1,
      0.022173,
      0.479625,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993220,
      1.999792,
      0,
      1,
      0,
      0,
      4,
      0,
      NULL,
      1,
      NULL,
      NULL,
      63,
      60.314930,
      NULL,
      3,
      0.611106,
      '24214',
      NULL,
      NULL,
      1.868212,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


