set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8531494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '4224411',
      2.713315,
      0,
      3,
      0,
      '0233',
      2.624168,
      0.318241,
      NULL,
      NULL,
      '11- 5-1974',
      61,
      NULL,
      3.794128,
      3.246393,
      0.038615,
      ' 6-13-1980',
      59,
      0,
      NULL,
      57,
      0.520098,
      ' 7- 1-1988',
      '11-22-1990',
      ' 7- 9-1985',
      NULL,
      0,
      0,
      0.766948,
      0.650707,
      NULL,
      3.193196,
      0,
      NULL,
      NULL,
      NULL,
      6,
      4.529130,
      5.916797,
      19.614140,
      NULL,
      15,
      0.070478,
      2.701801,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462358,
      2,
      1,
      0.282107,
      2,
      0,
      0,
      0.495015,
      0.182499,
      NULL,
      5.104284,
      0,
      2,
      NULL,
      3.362172,
      3,
      9,
      1,
      4.383410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958734,
      NULL,
      NULL,
      1.644331,
      NULL,
      3.501718,
      0.104220,
      3.122602,
      0.770240,
      2.509044,
      0.801581,
      1,
      NULL,
      NULL,
      2.483155,
      1.130498,
      1,
      0,
      0.422914,
      3.701189,
      0.463095,
      0.672401,
      1,
      0,
      6,
      0.518226,
      0.834575,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.225873,
      0.202671,
      NULL,
      NULL,
      7,
      4.719669,
      9.693072,
      1,
      3.019914,
      0.452005,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.420194,
      NULL,
      NULL,
      4.852967,
      3.795388,
      4.384124,
      NULL,
      1.327406,
      1.454342,
      2.419531,
      2,
      NULL,
      2.711352,
      NULL,
      6.784496,
      4.384269,
      NULL,
      8,
      6.779059,
      9,
      4.346434,
      NULL,
      7.944949,
      3.948460,
      2.957846,
      1,
      2,
      NULL,
      ' 2-27-1982',
      NULL,
      ' 9-26-1975',
      25,
      0,
      0,
      0.491491,
      6.634829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450251,
      0.481098,
      0,
      NULL,
      NULL,
      NULL,
      1.652352,
      1.407410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117734,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      0.100559,
      NULL,
      2.339119,
      6,
      0,
      1,
      NULL,
      0.784815,
      3.447723,
      NULL,
      0.319167,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.072545,
      7,
      0.698802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.500659,
      3.188407,
      60,
      0.298990,
      0,
      NULL,
      NULL,
      NULL,
      2.006079,
      1,
      2,
      0.081466,
      3,
      NULL,
      3,
      1.831531,
      0,
      2,
      1,
      2.141329,
      3,
      0.998110,
      3,
      0.305151,
      6,
      1.154389,
      1.348782,
      5,
      0.321906,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0.858347,
      3,
      1,
      0,
      4.743517,
      7,
      2,
      10,
      4.073751,
      NULL,
      NULL,
      4.364564,
      0.931439,
      2,
      0,
      13.879344,
      1.633394,
      3.575560,
      NULL,
      38.360313,
      4.941139,
      42.791549,
      NULL,
      0.463030,
      NULL,
      '14311',
      '33020',
      '',
      0.619638,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      15,
      36,
      31.399575,
      0,
      NULL,
      4,
      3.362887,
      1,
      3,
      0.536514,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.800819,
      0,
      3.040591,
      1.080788,
      2,
      NULL,
      0,
      3.202826,
      NULL,
      2,
      2,
      1.688222,
      1,
      NULL,
      NULL,
      0.101173,
      3,
      3.770650,
      1.729692,
      1.023041,
      1,
      NULL,
      NULL,
      NULL,
      0.503155,
      NULL,
      NULL,
      NULL,
      6,
      3.715512,
      1.007800,
      1,
      NULL,
      NULL,
      NULL,
      1.323244,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.371358,
      1.752666,
      2.071016,
      1,
      0,
      NULL,
      1,
      3.875141,
      1.707403,
      1.513892,
      1,
      1.956321,
      1,
      3,
      3.165385,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.042747,
      1,
      1,
      NULL,
      7.716415,
      NULL,
      0.331108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      0.867926,
      NULL,
      NULL,
      4,
      0,
      3.055656,
      NULL,
      3.572801,
      3,
      NULL,
      NULL,
      NULL,
      2.770082,
      5,
      3,
      0,
      NULL,
      NULL,
      0.301736,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.830202,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526490,
      2.057822,
      3,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      2.333836,
      2,
      3,
      NULL,
      2,
      0.742322,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.066928,
      NULL,
      NULL,
      2,
      3,
      1.031979,
      2,
      NULL,
      1.545233,
      0,
      1,
      0,
      6,
      9.151943,
      7.655731,
      1,
      NULL,
      NULL,
      0.959088,
      NULL,
      3.905125,
      1,
      1,
      1,
      1.850526,
      1.489669,
      0,
      NULL,
      NULL,
      0.042005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220520,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108463,
      NULL,
      NULL,
      NULL,
      1.334582,
      1.658247,
      1.219910,
      1.426814,
      NULL,
      1.549596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.530592,
      NULL,
      NULL,
      NULL,
      0.186948,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.890532,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.716327,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.741463,
      NULL,
      NULL,
      NULL,
      1.335494,
      NULL,
      NULL,
      NULL,
      0.634075,
      NULL,
      NULL,
      NULL,
      1.731975,
      NULL,
      NULL,
      NULL,
      0.007642,
      NULL,
      NULL,
      NULL,
      7.687301,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.020875,
      NULL,
      NULL,
      1.208834,
      9,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220359,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.831090,
      NULL,
      NULL,
      1.263318,
      49.394693,
      1,
      NULL,
      2.790781,
      1.254768,
      1.233187,
      0,
      0.169222,
      0.198312,
      0.729238,
      1.751146,
      NULL,
      NULL,
      1,
      0.475256,
      1,
      0.089499,
      3.138427,
      1.017942,
      1.638720,
      NULL,
      3.976985,
      NULL,
      NULL,
      NULL,
      3.828983,
      NULL,
      0,
      NULL,
      19,
      NULL,
      0.000469,
      NULL,
      NULL,
      NULL,
      0.253862,
      NULL,
      1.639810,
      0.816443,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.243856,
      NULL,
      0.448229,
      NULL,
      1,
      NULL,
      0.310922,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.670602,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007451,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.486089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333116,
      0.081810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.189506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890747,
      2.424582,
      NULL,
      1.779577,
      NULL,
      1.731406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794420,
      NULL,
      NULL,
      1,
      0.685990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.028243,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9.736024,
      2,
      2,
      1,
      0.701637,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.948747,
      NULL,
      NULL,
      NULL,
      0.363550,
      NULL,
      0,
      0.899903,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.950817,
      NULL,
      1,
      0,
      NULL,
      0,
      1.745421,
      NULL,
      1,
      1.289431,
      NULL,
      NULL,
      0,
      NULL,
      1.896243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.376857,
      9.674697,
      1.261687,
      NULL,
      NULL,
      54,
      23,
      NULL,
      1.699541,
      2,
      '20443',
      '44344',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


