set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7923979';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2301204',
      NULL,
      0.085581,
      1,
      NULL,
      '3322',
      1,
      NULL,
      NULL,
      NULL,
      ' 2-22-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8- 2-1985',
      12,
      3,
      117,
      63,
      3.917515,
      ' 4-16-1985',
      '10- 7-1979',
      ' 7- 9-1992',
      NULL,
      0,
      3.281422,
      1.469120,
      1.796445,
      3,
      1,
      NULL,
      0,
      NULL,
      2.982597,
      3,
      7.415400,
      1,
      3,
      3,
      14,
      NULL,
      1.049505,
      0.532555,
      0.600124,
      1,
      NULL,
      0.218970,
      0,
      0,
      0.170954,
      0.748241,
      0,
      1.382762,
      118.700411,
      NULL,
      6,
      7.761199,
      1,
      NULL,
      1.079326,
      1.986289,
      1.296519,
      0,
      1,
      1,
      0.005076,
      0.290891,
      1,
      1.598868,
      1.580974,
      1,
      1,
      NULL,
      0,
      1.283074,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565582,
      1,
      0,
      1.221848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.058148,
      3.221341,
      2.722487,
      4.224030,
      0.563417,
      NULL,
      3.148381,
      NULL,
      0,
      0,
      5.179364,
      NULL,
      1,
      0,
      NULL,
      0.797937,
      NULL,
      0.886108,
      6.207793,
      1,
      1,
      5,
      1.440591,
      7,
      4,
      NULL,
      5.721566,
      1,
      1,
      NULL,
      NULL,
      1,
      5,
      3.173204,
      6.577277,
      9,
      3.587109,
      NULL,
      0.591098,
      3.665777,
      5,
      1,
      0.479292,
      0.498545,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.746261,
      0,
      0,
      NULL,
      NULL,
      1.355890,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808833,
      1,
      3.596126,
      1.480033,
      1.430117,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.714506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.762903,
      1,
      NULL,
      0.241993,
      0.763871,
      0.693260,
      3.521688,
      4694,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.679115,
      2,
      2,
      NULL,
      NULL,
      0.718855,
      0.621783,
      1.798294,
      0.066740,
      NULL,
      1,
      0.961482,
      2,
      1.737311,
      1.611508,
      2,
      1,
      0,
      1.727759,
      0.954277,
      NULL,
      0.904353,
      0.591077,
      NULL,
      0,
      1,
      0.238609,
      0.216928,
      1,
      3.496232,
      1.662137,
      1.799762,
      3,
      0,
      10,
      5,
      0.993717,
      0,
      NULL,
      1,
      3.005658,
      3,
      NULL,
      71,
      1,
      1.765732,
      NULL,
      36.865063,
      77,
      35.143821,
      0,
      0,
      3.494318,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      26.145584,
      121.196913,
      NULL,
      0,
      10.297164,
      40.145971,
      344,
      10.365014,
      2,
      0,
      1.300836,
      0.807880,
      NULL,
      0,
      3.157274,
      0,
      0,
      1.386508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592607,
      NULL,
      1.668384,
      0,
      NULL,
      NULL,
      1.266836,
      NULL,
      NULL,
      0.901620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.240382,
      7.716747,
      NULL,
      0.144834,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.883936,
      1,
      1.119095,
      0.353355,
      NULL,
      NULL,
      1.309927,
      NULL,
      NULL,
      0.911074,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156446,
      NULL,
      NULL,
      1.254906,
      NULL,
      NULL,
      0.332992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.219370,
      0,
      NULL,
      NULL,
      NULL,
      4,
      5.658771,
      0.941925,
      3.205724,
      3.693784,
      0.467922,
      NULL,
      NULL,
      0.916078,
      1.806035,
      2.835682,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.475869,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.666538,
      2.983430,
      NULL,
      1.272830,
      NULL,
      NULL,
      4.995835,
      NULL,
      3.645376,
      1,
      2.159879,
      4,
      0,
      NULL,
      NULL,
      3,
      1.455761,
      NULL,
      0,
      0.035325,
      0,
      0,
      1,
      3,
      3,
      0.837060,
      8.811370,
      0,
      0,
      2.000326,
      1,
      2,
      3.057974,
      1.335986,
      NULL,
      NULL,
      2.422059,
      1,
      3.088708,
      4.062731,
      4,
      2,
      1.696098,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.183281,
      0.115048,
      1,
      1.259899,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791694,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.644183,
      NULL,
      NULL,
      1.424932,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.562252,
      3.752611,
      0,
      0.929978,
      0,
      2.399990,
      3.642249,
      NULL,
      NULL,
      2.469036,
      3,
      NULL,
      11.125309,
      NULL,
      NULL,
      NULL,
      3.620413,
      NULL,
      NULL,
      NULL,
      0.370307,
      NULL,
      NULL,
      NULL,
      1,
      0.461240,
      0.969055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.948504,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.021600,
      3.053090,
      3.219782,
      NULL,
      NULL,
      1.023957,
      0.511186,
      NULL,
      1.472691,
      1.397309,
      1.870773,
      NULL,
      1,
      1.866104,
      2.227590,
      NULL,
      2.122352,
      1.831400,
      1.338333,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      6.353676,
      NULL,
      3,
      NULL,
      1.744659,
      NULL,
      NULL,
      7,
      0.807100,
      3.180792,
      112.555168,
      31,
      2,
      68.584400,
      2.867609,
      1.631460,
      NULL,
      NULL,
      3,
      31.913677,
      8.140831,
      0.336764,
      27.622152,
      19.071383,
      NULL,
      NULL,
      0,
      0.517274,
      NULL,
      NULL,
      52,
      0.286918,
      1.293553,
      1.290875,
      1.502010,
      1.855770,
      0.066773,
      0,
      1,
      1,
      1.030453,
      NULL,
      0,
      0.613294,
      0.703318,
      NULL,
      1.946381,
      0,
      1,
      1.194834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.070399,
      NULL,
      0.367895,
      4,
      0.703184,
      1,
      1,
      NULL,
      0.069582,
      0,
      3,
      NULL,
      0.173831,
      0.079103,
      1,
      0.998464,
      0,
      0,
      0,
      NULL,
      3,
      1,
      1,
      0.504564,
      0,
      2.799962,
      NULL,
      1,
      1.317182,
      1.055345,
      0.120539,
      0,
      1.181132,
      NULL,
      0.781730,
      2,
      NULL,
      0,
      1,
      1,
      1.924249,
      2,
      1.186369,
      1,
      2,
      NULL,
      NULL,
      0.880941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539705,
      0.949100,
      1,
      0.604221,
      1,
      NULL,
      1.174012,
      11,
      11,
      3,
      1.484425,
      3.517296,
      40.574992,
      60,
      0.695101,
      1.044161,
      3,
      '41134',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


