set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206943';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3,
      1.711168,
      0,
      NULL,
      1.017523,
      1,
      0.161409,
      '440',
      '4',
      6.386717,
      52,
      NULL,
      3,
      NULL,
      0,
      0,
      '2430',
      1,
      0,
      NULL,
      NULL,
      ' 1- 9-2003',
      NULL,
      1,
      NULL,
      3,
      0.122691,
      ' 9-28-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-26-1999',
      NULL,
      1,
      0.702678,
      0.559583,
      0.693766,
      2,
      2,
      0,
      0.542867,
      30.360975,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.829447,
      2,
      2.477338,
      3,
      NULL,
      1,
      1.612635,
      1,
      3,
      4,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      3.035483,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.003379,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.818851,
      NULL,
      NULL,
      NULL,
      1.270382,
      NULL,
      3.950848,
      NULL,
      2,
      0.750394,
      0,
      1.756706,
      1,
      1,
      2.739208,
      6.825003,
      0.548056,
      4,
      NULL,
      1.258903,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538633,
      NULL,
      2.914302,
      NULL,
      2.195277,
      0.233483,
      0.548316,
      0.992837,
      0,
      1,
      0,
      5.608723,
      1.472382,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.780213,
      1,
      0,
      0.037390,
      NULL,
      3,
      1.901629,
      0.340117,
      0.275837,
      1,
      0.374086,
      NULL,
      1,
      0.118443,
      2,
      0.928863,
      2.749721,
      6,
      2,
      NULL,
      5.673562,
      1.183461,
      0,
      1.827115,
      0.236092,
      3.849909,
      ' 6-23-1991',
      820,
      ' 1- 9-1989',
      432.290251,
      1.823674,
      1,
      0.202440,
      1,
      1.050414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864989,
      1,
      0,
      1.907662,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153253,
      1,
      1.304295,
      1.945674,
      1.736516,
      2,
      0,
      0,
      1.561286,
      0.932680,
      0.499029,
      1.034569,
      1.206638,
      1.986878,
      NULL,
      0,
      4.264214,
      0.266009,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349445,
      3.104635,
      1,
      3.244851,
      1.858208,
      1.888077,
      1.300005,
      NULL,
      NULL,
      0,
      0.749636,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.445857,
      3,
      NULL,
      3,
      NULL,
      3,
      3.491592,
      2.400645,
      2.430357,
      2.843612,
      NULL,
      NULL,
      1,
      3.740655,
      NULL,
      0,
      0.567122,
      2.143764,
      1.569205,
      0.302381,
      1,
      1.506632,
      NULL,
      0,
      0,
      1,
      1.423457,
      1.482250,
      NULL,
      NULL,
      5,
      11,
      4,
      6.262990,
      NULL,
      1,
      NULL,
      2,
      2,
      1,
      0.410628,
      2.255815,
      12,
      1.076201,
      0.118296,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      '33004',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '1444',
      NULL,
      '',
      NULL,
      13.384865,
      406,
      4,
      0.854692,
      NULL,
      10,
      NULL,
      NULL,
      3.506599,
      1.501429,
      1.686607,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.020659,
      NULL,
      1.736130,
      NULL,
      NULL,
      3,
      3.761161,
      3,
      1.536363,
      1,
      1.438073,
      1.514599,
      2.845069,
      1,
      2.088980,
      0,
      3,
      1,
      NULL,
      2.700668,
      3.765012,
      1.538843,
      NULL,
      NULL,
      0,
      0.584562,
      2.207957,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.219124,
      3.138676,
      3.779504,
      NULL,
      0.417895,
      3,
      1,
      0.991430,
      0,
      NULL,
      0.768278,
      1,
      0,
      0.148783,
      2,
      0.898923,
      2,
      2.673772,
      NULL,
      1.161893,
      1.123789,
      0,
      1.458669,
      3,
      NULL,
      0.856947,
      1.764845,
      2.376120,
      1,
      1,
      0,
      1.128971,
      0.525808,
      1.279089,
      NULL,
      NULL,
      10.165113,
      4,
      4.515753,
      0,
      0.867067,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      3,
      1.677232,
      0.550176,
      2.327725,
      0.945054,
      NULL,
      NULL,
      1.553364,
      1.362163,
      1,
      1.976402,
      NULL,
      NULL,
      7.058802,
      0.332334,
      NULL,
      NULL,
      1.955778,
      0,
      0.896283,
      NULL,
      NULL,
      6,
      0.908520,
      5.084139,
      1,
      NULL,
      NULL,
      1.863364,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.728929,
      NULL,
      NULL,
      0.793521,
      NULL,
      NULL,
      1.976147,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.555436,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.432738,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.246813,
      NULL,
      1,
      1.308728,
      1,
      1,
      0,
      9.097588,
      1,
      7,
      2.177379,
      0,
      1,
      1,
      0,
      1.678205,
      NULL,
      NULL,
      3.276607,
      NULL,
      1.194213,
      0.977801,
      4,
      5,
      1.264184,
      NULL,
      0,
      2.386540,
      0.272787,
      0,
      3.010718,
      0,
      0,
      0.054541,
      0,
      1.499118,
      NULL,
      NULL,
      NULL,
      0.522505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705659,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.835713,
      NULL,
      NULL,
      NULL,
      2.047879,
      3.392035,
      1,
      0.652136,
      2,
      0.331455,
      NULL,
      NULL,
      1.549809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234999,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.747645,
      0.733127,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      0.193368,
      NULL,
      NULL,
      0,
      3.824260,
      NULL,
      NULL,
      NULL,
      1.113728,
      NULL,
      NULL,
      1,
      0.666554,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.291051,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.751506,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      3.776059,
      1,
      NULL,
      NULL,
      NULL,
      0.790036,
      19,
      114,
      3,
      NULL,
      NULL,
      1.727643,
      NULL,
      NULL,
      NULL,
      18,
      2.052420,
      0.959763,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.429720,
      NULL,
      1,
      687.120940,
      3,
      0,
      2,
      1,
      NULL,
      0,
      3.033182,
      1.559070,
      NULL,
      1,
      1,
      1.920306,
      3,
      0.344366,
      0,
      0.333037,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.266479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      147,
      NULL,
      1,
      34,
      73.124964,
      0,
      1.475176,
      NULL,
      NULL,
      3.238985,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2.448436,
      NULL,
      0,
      NULL,
      0.179382,
      NULL,
      3,
      NULL,
      0.697311,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.908731,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337114,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.463509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.024916,
      NULL,
      0.944064,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.905992,
      NULL,
      NULL,
      NULL,
      1.346499,
      NULL,
      0.313256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723906,
      0.552011,
      1.428494,
      1,
      1.598951,
      NULL,
      3,
      1.086777,
      NULL,
      0,
      0,
      2.711831,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      3.221868,
      0.059624,
      NULL,
      3.591532,
      0.056979,
      1.874812,
      1.387922,
      NULL,
      2,
      1.980843,
      NULL,
      3.275537,
      0.687187,
      1,
      NULL,
      NULL,
      NULL,
      1.523238,
      2,
      0.495008,
      3,
      0.146629,
      1,
      0,
      1.438872,
      2,
      1.032034,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.323574,
      0.604993,
      0,
      0,
      0.349468,
      NULL,
      0,
      1,
      1.378459,
      NULL,
      NULL,
      25.776188,
      5.510818,
      NULL,
      0.627903,
      NULL,
      '24431',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1312',
      '',
      '');
commit;
end;
/


