set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935322';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '4240000',
      3,
      1,
      0,
      0,
      NULL,
      2.297744,
      2,
      4.079996,
      16,
      NULL,
      45,
      NULL,
      2,
      3.852450,
      0.122104,
      ' 0-15-1993',
      54.770160,
      4,
      55.734772,
      103.029284,
      2.702241,
      ' 7- 7-2002',
      ' 0- 6-2003',
      ' 8- 3-1989',
      1,
      2,
      NULL,
      1.533910,
      NULL,
      3.858261,
      9,
      1,
      1.483406,
      19,
      NULL,
      9.453654,
      3.962545,
      151.484544,
      166,
      1.174486,
      14.414400,
      3.760514,
      4,
      7,
      1.606386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964894,
      2.786796,
      1,
      0.404869,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.371529,
      1,
      0.430665,
      0,
      0,
      1.771934,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.999677,
      5,
      0.499274,
      1.627405,
      1.373844,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.569896,
      1,
      0.852044,
      1.273116,
      1.288804,
      0.881151,
      1.461973,
      NULL,
      7,
      1.447898,
      0,
      0.419006,
      0,
      NULL,
      NULL,
      0.034694,
      NULL,
      NULL,
      0,
      0.951097,
      0.062031,
      0.053157,
      0.878817,
      0,
      1.404312,
      NULL,
      0.760931,
      1.162979,
      1.820108,
      0,
      0.184590,
      NULL,
      1.620713,
      1,
      1.360707,
      1.691567,
      0.303077,
      NULL,
      0,
      3.420637,
      0.566988,
      0,
      0.578479,
      1,
      0,
      NULL,
      0,
      1,
      1.545561,
      1,
      NULL,
      5.869657,
      1.281386,
      2,
      NULL,
      0,
      3.543166,
      0,
      NULL,
      0.849999,
      1,
      11,
      0.411816,
      NULL,
      2,
      2.147119,
      NULL,
      296,
      '11-27-1985',
      27,
      1.402413,
      1,
      0.209965,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.393240,
      1,
      0,
      1,
      NULL,
      0.608793,
      0.366688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084079,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.949772,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.667585,
      NULL,
      1.167322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527829,
      1,
      0.315395,
      1.402569,
      1.768189,
      0.951714,
      1.074115,
      NULL,
      61.518149,
      NULL,
      1.786637,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.069792,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.997747,
      1,
      0,
      2.904547,
      3,
      NULL,
      3,
      1,
      1,
      29.180839,
      NULL,
      1,
      122,
      189,
      NULL,
      39,
      NULL,
      170.745746,
      1.359873,
      0,
      NULL,
      NULL,
      1,
      1,
      6.353443,
      4,
      5,
      3,
      2.802639,
      1.811498,
      0.725993,
      2,
      2,
      1,
      6,
      2.996222,
      3.930501,
      NULL,
      69,
      30,
      73,
      NULL,
      0.970216,
      3,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      6.509680,
      '12144',
      '44411',
      '33140',
      1.215733,
      40,
      252.368920,
      43.603044,
      2,
      60.468507,
      5.991937,
      4,
      1.860689,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.026586,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.164238,
      NULL,
      NULL,
      NULL,
      0.409934,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.405114,
      4.218543,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.236295,
      NULL,
      NULL,
      6.754166,
      6.642027,
      0.484949,
      0.855497,
      1.434936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737837,
      2,
      NULL,
      1.447607,
      NULL,
      3.008030,
      0,
      2,
      0.018619,
      1.234508,
      1.182491,
      1,
      0.375986,
      0.899530,
      0.863630,
      1.412806,
      NULL,
      3,
      0,
      1,
      0.580800,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      2,
      0,
      1,
      NULL,
      0,
      2.686371,
      9.158481,
      0.516598,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.766354,
      1,
      1.615931,
      2.380566,
      0.648330,
      1.077118,
      0.936404,
      NULL,
      NULL,
      5.139093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.375011,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.182372,
      NULL,
      NULL,
      2,
      2,
      0.462083,
      0,
      NULL,
      NULL,
      0,
      1.313000,
      NULL,
      0.814363,
      1.361635,
      1.964117,
      0,
      4.940759,
      3.573020,
      0.959312,
      0.533941,
      NULL,
      0.972566,
      NULL,
      2,
      0.348156,
      NULL,
      NULL,
      4.778027,
      2,
      7.519229,
      1.546526,
      0.256479,
      1.757375,
      NULL,
      1,
      0.129771,
      1,
      NULL,
      NULL,
      3,
      1.146427,
      1.978629,
      1.510137,
      4,
      NULL,
      2.654684,
      NULL,
      0,
      1,
      5.933189,
      4,
      NULL,
      1,
      1,
      0,
      1.459645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483033,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.419643,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.820889,
      0.980920,
      2.382909,
      0,
      NULL,
      NULL,
      NULL,
      3.031285,
      NULL,
      NULL,
      6.119165,
      1.528067,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834508,
      NULL,
      NULL,
      0,
      0.256385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449826,
      0.312148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.329587,
      NULL,
      NULL,
      NULL,
      0.906708,
      3,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.617326,
      NULL,
      NULL,
      NULL,
      1.796067,
      0,
      NULL,
      NULL,
      0,
      0.926062,
      NULL,
      NULL,
      2.180809,
      1.532361,
      NULL,
      NULL,
      1.443338,
      NULL,
      NULL,
      NULL,
      3.923753,
      73,
      50.261623,
      NULL,
      NULL,
      NULL,
      0.011686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.491933,
      NULL,
      NULL,
      0.697320,
      3,
      1,
      198,
      0.624014,
      1.751495,
      0,
      NULL,
      NULL,
      1,
      1.525616,
      0,
      0.452304,
      1,
      1.988171,
      0.341659,
      0,
      0.211329,
      NULL,
      0.241813,
      1,
      0.533451,
      1.475873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.162558,
      2.413382,
      1.282171,
      0.776101,
      2.019354,
      0.753949,
      1.706118,
      0.945930,
      0.576215,
      0.586833,
      0,
      0,
      0.369105,
      1.266569,
      NULL,
      2,
      1.192938,
      1,
      2,
      0.623639,
      1,
      0,
      NULL,
      1.451805,
      1,
      0.564117,
      1.881023,
      0,
      0.416627,
      1.715741,
      0.605259,
      0,
      1,
      0.570929,
      1.116235,
      NULL,
      0,
      0.503133,
      0,
      1.750341,
      0,
      2,
      1.752616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885245,
      NULL,
      1.624147,
      NULL,
      0.641808,
      1,
      9.375550,
      10,
      NULL,
      3.412885,
      1,
      0,
      64.636091,
      76.208288,
      2,
      1,
      0,
      NULL,
      '',
      '',
      1.384878,
      '',
      '',
      '',
      5.609151,
      '11424',
      NULL,
      '31242');
commit;
end;
/


