set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8130151';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068371,
      NULL,
      0,
      '2302',
      0,
      0,
      0,
      1,
      ' 6-27-1979',
      25.323922,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      124,
      1.648607,
      ' 1-15-1974',
      ' 1-17-1988',
      ' 7-10-1999',
      NULL,
      0.969265,
      NULL,
      NULL,
      1.707918,
      0.394281,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.796415,
      5.072653,
      NULL,
      12.029401,
      NULL,
      23,
      0.652379,
      3,
      6,
      1,
      NULL,
      1.997224,
      0,
      1.669897,
      1,
      1.400407,
      0.526698,
      0,
      NULL,
      1.909053,
      NULL,
      2,
      1,
      2,
      7,
      1.157380,
      1,
      0.986838,
      NULL,
      2.332239,
      5.466773,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762584,
      0.329393,
      1.583074,
      3.446206,
      NULL,
      5,
      0.200234,
      NULL,
      NULL,
      1.696168,
      NULL,
      NULL,
      2,
      6,
      NULL,
      1,
      1,
      1.540333,
      1,
      2.624363,
      2.063148,
      0,
      2,
      NULL,
      NULL,
      1.025749,
      3,
      1,
      2.660542,
      1,
      0.293329,
      NULL,
      1.693747,
      5,
      8.912063,
      1,
      3,
      1.088816,
      1.543643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.623241,
      1.254271,
      8,
      0.522622,
      3,
      1,
      0.320482,
      0,
      2,
      0,
      1,
      1,
      1.067359,
      NULL,
      1.696096,
      1.455376,
      0.977226,
      NULL,
      0,
      NULL,
      0.125437,
      1,
      7.952237,
      7.719524,
      NULL,
      0,
      3.185872,
      6.134909,
      NULL,
      7.198102,
      3.961937,
      5.228144,
      4,
      7,
      1,
      9.849154,
      3.790100,
      2.424126,
      2,
      4.911095,
      0.082864,
      1.712189,
      9.224316,
      7.144325,
      0,
      1.188260,
      8,
      0.790842,
      ' 2-16-1982',
      165.570666,
      ' 1-12-1985',
      242.493274,
      NULL,
      1.333449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.959816,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.441298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.089000,
      0.868934,
      2,
      NULL,
      1,
      1,
      1.791701,
      6.131088,
      3,
      0.657500,
      0,
      1.541766,
      6,
      0,
      NULL,
      NULL,
      0,
      10.457290,
      1.267659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.240002,
      0.370958,
      1,
      1,
      0.379958,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.693200,
      1.636729,
      NULL,
      1,
      1.546425,
      1.501330,
      3,
      0,
      NULL,
      1.326269,
      2,
      NULL,
      2,
      2.212000,
      2,
      3.912878,
      5,
      1.604748,
      0,
      3.098275,
      1.442784,
      0.194794,
      0.056328,
      0,
      1,
      0.707930,
      1,
      0.395567,
      0.775067,
      1.614184,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      16,
      NULL,
      30,
      2.679987,
      0.712474,
      1.445012,
      '41404',
      NULL,
      NULL,
      0,
      '',
      '',
      NULL,
      1.210021,
      NULL,
      '',
      '',
      3,
      14.754711,
      0.005470,
      0.689449,
      2,
      6.979442,
      6,
      1,
      2.763307,
      0,
      1.133934,
      3.205385,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.062843,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      2,
      0,
      0.148430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.846774,
      NULL,
      NULL,
      1.960560,
      NULL,
      NULL,
      0.002396,
      NULL,
      NULL,
      NULL,
      6,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.258726,
      NULL,
      NULL,
      0,
      0,
      0.196205,
      3,
      0,
      3.316223,
      3,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      2,
      3.484902,
      2,
      NULL,
      3.766678,
      0,
      NULL,
      0.775720,
      NULL,
      1,
      2.754516,
      1.063271,
      3.970548,
      1,
      0,
      3.643159,
      2,
      0.082073,
      9.552960,
      NULL,
      6.363257,
      0,
      1.947800,
      NULL,
      NULL,
      NULL,
      0.081206,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.772607,
      NULL,
      0,
      1.181575,
      NULL,
      1,
      1.428562,
      NULL,
      NULL,
      5.669782,
      NULL,
      1,
      NULL,
      3.175535,
      0.635480,
      0.986161,
      NULL,
      NULL,
      4.764010,
      2,
      5,
      0,
      NULL,
      NULL,
      0.817138,
      NULL,
      NULL,
      1.610006,
      NULL,
      NULL,
      1.222755,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.216904,
      NULL,
      NULL,
      3.798007,
      3,
      2.306006,
      2.132802,
      2,
      1.003552,
      5,
      1,
      3.220892,
      NULL,
      1,
      0.402652,
      NULL,
      NULL,
      NULL,
      1.424365,
      NULL,
      3,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      6.606219,
      6,
      5.320303,
      2,
      2.795574,
      NULL,
      1,
      1.132201,
      2,
      1.699339,
      NULL,
      NULL,
      2,
      2,
      3,
      1.857386,
      5.241130,
      2.755586,
      2.642972,
      6,
      3,
      3.469342,
      NULL,
      7.494102,
      0,
      1.312980,
      1.619583,
      0.187721,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.140237,
      NULL,
      NULL,
      1.966104,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.083968,
      NULL,
      NULL,
      3.209464,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.364023,
      0.514681,
      3.808731,
      NULL,
      NULL,
      0.084708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.114213,
      1.102344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709441,
      0,
      NULL,
      NULL,
      0.735172,
      NULL,
      NULL,
      NULL,
      1.591796,
      NULL,
      NULL,
      NULL,
      1.132671,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.033970,
      0,
      NULL,
      NULL,
      3.271247,
      0,
      NULL,
      NULL,
      1,
      0.805017,
      NULL,
      NULL,
      1,
      1.868514,
      NULL,
      NULL,
      2.291877,
      NULL,
      NULL,
      NULL,
      11.432970,
      1.703809,
      NULL,
      NULL,
      0.811201,
      NULL,
      NULL,
      NULL,
      0.035003,
      26.886199,
      NULL,
      0.705623,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037491,
      NULL,
      NULL,
      1.625206,
      NULL,
      0,
      NULL,
      368,
      0,
      1,
      0,
      1,
      1,
      NULL,
      0.322411,
      1.038169,
      1.528088,
      0,
      0.026589,
      0,
      1.866422,
      0.173055,
      0.183744,
      1,
      NULL,
      0.098849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967116,
      NULL,
      12,
      3.740893,
      4,
      4,
      2,
      1.612619,
      1,
      1,
      1.521947,
      1.575329,
      0.054914,
      NULL,
      0,
      NULL,
      0,
      3.065710,
      3.973135,
      0,
      0,
      1,
      2,
      3,
      0.933997,
      1,
      1.132537,
      0,
      1.136039,
      3.134341,
      2.014183,
      0.556663,
      0.260093,
      0.321282,
      2,
      1.111522,
      1,
      1,
      0.712662,
      NULL,
      1,
      3,
      1,
      0.437668,
      0.167856,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.869373,
      1,
      0,
      0,
      1.295260,
      5.118186,
      NULL,
      12,
      1,
      0,
      0.550506,
      18,
      32,
      1.297350,
      1,
      1.131091,
      '02144',
      '',
      '',
      0,
      '',
      '',
      '',
      0.863424,
      '',
      NULL,
      '');
commit;
end;
/


