set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000189';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1213441',
      0,
      1.294295,
      1,
      1,
      '3314',
      1.247695,
      1,
      NULL,
      NULL,
      NULL,
      109,
      NULL,
      4,
      NULL,
      1,
      ' 8-29-1986',
      55.203375,
      3,
      NULL,
      91.156044,
      3.737877,
      ' 3-20-1985',
      ' 8-24-1982',
      ' 5-20-1975',
      1,
      NULL,
      3.383566,
      NULL,
      1,
      2,
      0.353214,
      1.933447,
      NULL,
      450.562037,
      2,
      16,
      7,
      0,
      6,
      0,
      14.029404,
      5,
      0,
      5.651645,
      0.303381,
      NULL,
      0.807297,
      0.314350,
      1.044363,
      NULL,
      1.128361,
      NULL,
      NULL,
      0,
      158.491834,
      NULL,
      9,
      1,
      0.280073,
      NULL,
      1.266804,
      1.204812,
      0,
      NULL,
      NULL,
      1.256509,
      3.205320,
      2.575952,
      1,
      0.748854,
      0.107798,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.312245,
      1.758922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626850,
      1.716713,
      NULL,
      1.200737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.082698,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0.124872,
      0.444528,
      0.281349,
      1.805197,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      2,
      5,
      NULL,
      NULL,
      NULL,
      7,
      9.376926,
      4,
      4,
      9,
      NULL,
      0.955587,
      0.092464,
      2.481038,
      2.952446,
      NULL,
      10,
      1.126239,
      6,
      8,
      NULL,
      2.864821,
      NULL,
      0.753677,
      4.760216,
      3,
      1.858141,
      ' 3-28-2003',
      1598,
      ' 6- 6-1974',
      325,
      0.477761,
      0,
      NULL,
      1.440388,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.269533,
      0.870461,
      0.940816,
      0,
      0.433304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261244,
      NULL,
      620.172440,
      3,
      0.525054,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963941,
      0.383647,
      NULL,
      1,
      NULL,
      0.124837,
      0.746931,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647664,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.678217,
      NULL,
      1.061566,
      0,
      1.113674,
      2,
      1,
      NULL,
      11854.459519,
      1.550729,
      NULL,
      NULL,
      766,
      792.480572,
      1.094041,
      1,
      3.705498,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.268504,
      NULL,
      1.549591,
      NULL,
      0,
      1,
      NULL,
      3.810022,
      0.334421,
      3,
      1.126557,
      0,
      NULL,
      0.849243,
      1.654989,
      1.225589,
      0,
      0,
      1.772813,
      NULL,
      5,
      0.002904,
      1.462603,
      5,
      NULL,
      3.356479,
      1.520266,
      NULL,
      NULL,
      2,
      3.481375,
      2,
      0,
      1.997022,
      32,
      1.858990,
      3,
      NULL,
      14.387369,
      NULL,
      8.611137,
      3.697571,
      1,
      5,
      '24401',
      '03420',
      '',
      0.786833,
      NULL,
      '',
      '',
      7.087231,
      '0022',
      '2121',
      NULL,
      1.362844,
      38.204119,
      880.509590,
      0,
      0.943289,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.645616,
      NULL,
      3,
      2.774773,
      0.548664,
      0.910424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.667675,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617217,
      NULL,
      NULL,
      1.412918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      8,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.016367,
      NULL,
      NULL,
      NULL,
      3.074348,
      0,
      3,
      1.257094,
      NULL,
      NULL,
      0.892611,
      NULL,
      NULL,
      NULL,
      1.168205,
      NULL,
      1.242347,
      1,
      1,
      0.151395,
      NULL,
      0.678198,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1.205575,
      1.378348,
      NULL,
      NULL,
      0.821140,
      NULL,
      NULL,
      0.222061,
      NULL,
      NULL,
      5.556398,
      NULL,
      3,
      0.285002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915684,
      NULL,
      3.525284,
      3.517424,
      1.339474,
      0,
      3.978247,
      2,
      0,
      0.125562,
      NULL,
      NULL,
      4.151813,
      0,
      2.799836,
      3,
      NULL,
      1,
      NULL,
      0,
      0.598876,
      3.058975,
      7.773149,
      3.353086,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.153507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292536,
      NULL,
      NULL,
      0.930942,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.156649,
      NULL,
      NULL,
      5,
      2.914288,
      7,
      1.205560,
      5.160862,
      3.595178,
      0,
      NULL,
      0.586703,
      1,
      2,
      2.849367,
      1,
      NULL,
      NULL,
      8,
      3.338495,
      7,
      1,
      2,
      NULL,
      3,
      1,
      NULL,
      0,
      2,
      0.496013,
      3,
      2.444827,
      1,
      0.354853,
      2,
      2.868978,
      3.588270,
      NULL,
      NULL,
      3,
      5.462709,
      4,
      1,
      NULL,
      0.616625,
      NULL,
      0.270528,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371544,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.763610,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.940184,
      NULL,
      NULL,
      1.735175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.035393,
      NULL,
      NULL,
      3.799923,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0.527543,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.121317,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.643030,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.583873,
      NULL,
      NULL,
      NULL,
      0.110594,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.970358,
      NULL,
      680,
      3.391699,
      1926.918954,
      972.411696,
      NULL,
      399,
      779,
      NULL,
      128.894521,
      2,
      15602,
      36,
      1,
      0.146331,
      1,
      1.715226,
      0.922732,
      NULL,
      0,
      0.809163,
      0.524245,
      0,
      0,
      1,
      0,
      0.324541,
      0.469995,
      1,
      1.784455,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.969194,
      NULL,
      6.889088,
      0.889462,
      1.629930,
      1.212297,
      5,
      7,
      2,
      2,
      1,
      0,
      0.772242,
      NULL,
      1,
      1.884629,
      NULL,
      0.074332,
      1.411551,
      NULL,
      1.574123,
      1,
      NULL,
      0.144534,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      0.398556,
      NULL,
      2.874653,
      3,
      NULL,
      0,
      1.090670,
      NULL,
      3,
      1.619751,
      NULL,
      3,
      1,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148167,
      NULL,
      0,
      NULL,
      0.488424,
      NULL,
      NULL,
      10,
      1,
      2.450449,
      NULL,
      NULL,
      0.998130,
      5,
      1,
      5,
      '00443',
      '12301',
      '',
      0,
      '',
      NULL,
      NULL,
      0,
      NULL,
      '3010',
      '2101');
commit;
end;
/


