set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6118005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      2,
      0.962394,
      NULL,
      1,
      NULL,
      0.257668,
      1.904967,
      NULL,
      11,
      ' 4-21-1995',
      38,
      NULL,
      0.659611,
      1.745766,
      1,
      ' 5-29-1976',
      NULL,
      NULL,
      172.719568,
      169.255189,
      NULL,
      NULL,
      ' 9- 2-1996',
      '10- 9-1979',
      0.832940,
      2,
      2,
      0.144077,
      0,
      1,
      5,
      0,
      1.322237,
      18.666803,
      5.342338,
      5.692807,
      NULL,
      16.141789,
      11,
      1,
      5,
      5,
      3.536751,
      0.204329,
      NULL,
      0,
      3.338198,
      1,
      1,
      NULL,
      1.927413,
      1,
      1,
      0.013422,
      0,
      NULL,
      1,
      NULL,
      NULL,
      9.105864,
      0,
      1.488450,
      5,
      2.157897,
      0.923254,
      0.409123,
      1,
      1,
      9,
      2.433042,
      1,
      7,
      1.190258,
      NULL,
      1.772322,
      NULL,
      0.660215,
      NULL,
      NULL,
      1.412325,
      NULL,
      NULL,
      NULL,
      3,
      3.610832,
      3,
      NULL,
      0.421019,
      3.666175,
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      2,
      0.777929,
      1.448635,
      2.795647,
      3,
      2,
      5.484011,
      1.512146,
      3,
      1.984007,
      0,
      1.000651,
      NULL,
      0.027814,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.887096,
      3,
      0.354807,
      0,
      3,
      NULL,
      0,
      2.711404,
      0.511849,
      0,
      1,
      1.555025,
      1,
      0.508232,
      0.116749,
      0,
      1,
      1.637345,
      NULL,
      1,
      3,
      2.764324,
      NULL,
      4,
      2,
      7.699366,
      3,
      0,
      NULL,
      2,
      0,
      NULL,
      2.449467,
      1.588927,
      3.877539,
      2,
      3.799011,
      4.319976,
      NULL,
      1.891464,
      NULL,
      8,
      3.764385,
      7.094063,
      NULL,
      NULL,
      0.141525,
      '10- 0-1996',
      475.230025,
      ' 0-17-1998',
      0,
      3.677305,
      1.875513,
      0,
      2.775030,
      1.129446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.771859,
      1.694936,
      1.929362,
      NULL,
      NULL,
      0,
      0.604113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364087,
      0,
      NULL,
      1.150359,
      0,
      0.511306,
      0.748052,
      NULL,
      NULL,
      NULL,
      0.354105,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207293,
      NULL,
      1,
      0,
      NULL,
      0.349236,
      0.766565,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261747,
      2,
      3,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.002351,
      2.047123,
      1,
      1.112294,
      0,
      NULL,
      3,
      2,
      0.217364,
      0.125932,
      3.698048,
      0,
      1.691436,
      NULL,
      0,
      0.453122,
      0.656548,
      0.242778,
      1.129783,
      1.763400,
      NULL,
      2.808407,
      NULL,
      6,
      3,
      1.884891,
      2.977214,
      5,
      0,
      4.194924,
      0,
      1,
      0.794031,
      0,
      3.497801,
      NULL,
      NULL,
      3.636818,
      NULL,
      27.959452,
      NULL,
      68,
      2,
      0.712056,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      51.851005,
      9,
      42.615599,
      1.712363,
      28,
      5.888530,
      12.300733,
      3,
      3.379826,
      13.283436,
      0.718725,
      1,
      NULL,
      NULL,
      NULL,
      6.674002,
      6,
      NULL,
      1.517092,
      1.887327,
      0.588687,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3.209090,
      1,
      2.205053,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.112610,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.308907,
      NULL,
      NULL,
      NULL,
      NULL,
      3.434168,
      0,
      0.957160,
      3.729604,
      2.550209,
      1.554339,
      NULL,
      2,
      1.280822,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      2,
      0.776820,
      3.070758,
      2.613501,
      0,
      3.978704,
      NULL,
      NULL,
      2,
      3.388766,
      0,
      NULL,
      NULL,
      0.652960,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.271427,
      0,
      10.856118,
      6,
      5,
      1.804755,
      0,
      NULL,
      NULL,
      NULL,
      0.253375,
      0.740150,
      2.608188,
      0,
      NULL,
      3.120647,
      1,
      2.919272,
      5,
      0.017686,
      2.907267,
      NULL,
      2.477878,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.687081,
      NULL,
      NULL,
      1.704126,
      NULL,
      NULL,
      0.410265,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.785711,
      NULL,
      NULL,
      1.031396,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.308612,
      0.408638,
      2.793064,
      NULL,
      2.098975,
      1,
      NULL,
      0.842892,
      10.085646,
      3.288713,
      8.269193,
      1.773638,
      NULL,
      NULL,
      0,
      3.776807,
      NULL,
      3,
      1.176083,
      NULL,
      0,
      NULL,
      3,
      9,
      0,
      3.470105,
      2,
      1.422099,
      3.157380,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.334327,
      1,
      1,
      6.058584,
      7,
      5.592488,
      7.493552,
      7,
      2,
      1.067376,
      1.965153,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.886601,
      NULL,
      NULL,
      1.856639,
      NULL,
      NULL,
      1.490742,
      NULL,
      NULL,
      3.583345,
      NULL,
      NULL,
      1.600600,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.633405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      0.486326,
      2,
      NULL,
      0.224960,
      NULL,
      1.701881,
      3.309425,
      1,
      NULL,
      18.962585,
      0.891950,
      6,
      NULL,
      1.406785,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.847707,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.136449,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.464165,
      NULL,
      1.662446,
      NULL,
      0.194390,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.524561,
      NULL,
      1.435412,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.926135,
      NULL,
      2.331373,
      1.602627,
      3.802340,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.416274,
      1,
      0.347212,
      NULL,
      NULL,
      0.487094,
      2.842172,
      NULL,
      3.849466,
      1.639234,
      1.537523,
      NULL,
      3.134294,
      NULL,
      1,
      NULL,
      3,
      1.760037,
      0.124662,
      NULL,
      14,
      NULL,
      8.364408,
      NULL,
      5.224051,
      0.568393,
      5.961062,
      NULL,
      NULL,
      0.965233,
      303,
      149.224525,
      0,
      2,
      2.435040,
      0.468657,
      NULL,
      NULL,
      NULL,
      5.179380,
      1,
      1.306479,
      3,
      NULL,
      1.497497,
      NULL,
      NULL,
      0.904128,
      NULL,
      0,
      130,
      9.524310,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0.559696,
      1.541284,
      0.570505,
      1.482347,
      0.549798,
      0,
      0.821549,
      NULL,
      0.245939,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.032481,
      NULL,
      1.297849,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.207477,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.011439,
      NULL,
      NULL,
      NULL,
      1.359753,
      NULL,
      NULL,
      NULL,
      0.342525,
      NULL,
      NULL,
      NULL,
      1,
      1.533577,
      1.213534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840457,
      0,
      NULL,
      NULL,
      NULL,
      0.363083,
      1,
      1,
      2.940588,
      2.324778,
      3,
      0,
      NULL,
      1.853873,
      NULL,
      0.332212,
      3,
      NULL,
      1,
      0.594516,
      NULL,
      1,
      1.891539,
      NULL,
      0.839354,
      1,
      NULL,
      0.793396,
      0.660967,
      NULL,
      0.939049,
      1.658446,
      NULL,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      2.215356,
      NULL,
      1,
      1,
      NULL,
      2.300803,
      NULL,
      0.191702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.169008,
      3.474537,
      75.504710,
      37.593882,
      5.665039,
      NULL,
      NULL,
      '30302',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.494591,
      '',
      '',
      NULL);
commit;
end;
/


