set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5607545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '2112432',
      NULL,
      1,
      1,
      0,
      NULL,
      2.509120,
      2.378456,
      0,
      2.829023,
      '11- 2-1999',
      31.958641,
      NULL,
      NULL,
      1,
      1,
      ' 4- 9-1981',
      50.702330,
      3.113018,
      90.677902,
      5.318672,
      4.692966,
      NULL,
      NULL,
      ' 9- 5-1989',
      1.635256,
      0.160785,
      1,
      1,
      0.335127,
      NULL,
      3,
      1.292517,
      NULL,
      NULL,
      NULL,
      0,
      0,
      28,
      31,
      NULL,
      11.908340,
      2,
      2,
      1.915995,
      1,
      NULL,
      1,
      1.449626,
      NULL,
      NULL,
      1.130150,
      NULL,
      1,
      0.862836,
      NULL,
      0,
      1.424114,
      1.705809,
      1,
      4,
      0.289096,
      1,
      NULL,
      1,
      1,
      3.060687,
      1.697387,
      1.273581,
      3.819465,
      1.088570,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.857278,
      NULL,
      NULL,
      1,
      0.560339,
      0.493819,
      1.706737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077627,
      1.675744,
      0.353220,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.873267,
      NULL,
      0,
      1,
      0,
      NULL,
      0.091341,
      NULL,
      0,
      NULL,
      1,
      1.521746,
      1,
      0,
      1.224460,
      NULL,
      NULL,
      NULL,
      1.050474,
      1,
      1.027461,
      0,
      1.911183,
      2.184050,
      0.838805,
      0.397492,
      0.481656,
      1.883357,
      1.943680,
      1,
      1,
      1,
      2.835235,
      1,
      3.550471,
      NULL,
      4.618078,
      4,
      4.273975,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302707,
      0.212642,
      1,
      1,
      0,
      NULL,
      1.238223,
      0.346916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.147165,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.441936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.300405,
      1.377166,
      2.233134,
      5,
      NULL,
      1.598600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.533029,
      1.459871,
      NULL,
      0,
      1.256941,
      0,
      NULL,
      3,
      1.115243,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173497,
      2,
      2.141480,
      1,
      1.009677,
      0.750928,
      2,
      3,
      0,
      3.189064,
      2.885347,
      1.663249,
      NULL,
      1.090569,
      3.530795,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.852228,
      NULL,
      1.288734,
      NULL,
      1.017768,
      6,
      11.199434,
      4.105346,
      11.702013,
      7,
      NULL,
      0,
      NULL,
      NULL,
      1.894536,
      2,
      2.709258,
      23.404631,
      0.730455,
      NULL,
      65.863052,
      NULL,
      NULL,
      NULL,
      2,
      1.515088,
      2,
      '22312',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.656489,
      '',
      '',
      '',
      0,
      6.598844,
      142,
      14.386425,
      0.152408,
      NULL,
      2,
      3.416344,
      0.205265,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.029486,
      NULL,
      NULL,
      3,
      0,
      1.370041,
      NULL,
      NULL,
      NULL,
      1.689770,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      2,
      1.723310,
      1,
      NULL,
      NULL,
      0.744387,
      NULL,
      NULL,
      1.142944,
      NULL,
      NULL,
      0.760911,
      NULL,
      NULL,
      0,
      3.409035,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.600674,
      0.170106,
      5,
      0.949081,
      1.889490,
      1.646515,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      3.178857,
      NULL,
      2.585400,
      0,
      1.274562,
      3.844099,
      0.602110,
      1.567343,
      NULL,
      NULL,
      1,
      NULL,
      1.527446,
      0.074175,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.364805,
      4,
      1.407940,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478220,
      NULL,
      NULL,
      NULL,
      0.197572,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.254842,
      19.329722,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1.053221,
      NULL,
      NULL,
      0.810982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.343614,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.329110,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.784625,
      NULL,
      NULL,
      3.246351,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      3.023594,
      1.547525,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0.083032,
      1.839620,
      NULL,
      1,
      1,
      1.278649,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      3.671623,
      3,
      3,
      2,
      0,
      1.673544,
      2,
      1,
      0,
      3.828000,
      3,
      1,
      0,
      2.477683,
      4.569341,
      NULL,
      5.811076,
      0,
      NULL,
      3.189461,
      5,
      NULL,
      1,
      0,
      0,
      1,
      2.744835,
      NULL,
      NULL,
      0.596391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.783625,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.373406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.421531,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.228608,
      NULL,
      3.098141,
      0.344256,
      NULL,
      NULL,
      0.126899,
      NULL,
      NULL,
      NULL,
      3.088073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.739306,
      NULL,
      NULL,
      NULL,
      1.500270,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491760,
      3.460854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295648,
      NULL,
      NULL,
      NULL,
      3.819201,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009173,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.311825,
      NULL,
      NULL,
      0.641472,
      3.802301,
      NULL,
      NULL,
      NULL,
      0.582416,
      NULL,
      NULL,
      2.897973,
      3.851024,
      NULL,
      NULL,
      1.353938,
      NULL,
      NULL,
      NULL,
      0.782246,
      3.678466,
      1,
      1.639250,
      NULL,
      NULL,
      0.911977,
      NULL,
      NULL,
      3.334958,
      0.543539,
      1.254211,
      1.149050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389797,
      NULL,
      NULL,
      8055,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.215524,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      2.756607,
      NULL,
      0.014811,
      NULL,
      NULL,
      NULL,
      1.052178,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.008551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847736,
      3.490179,
      NULL,
      2,
      NULL,
      3,
      NULL,
      25.000445,
      NULL,
      3,
      NULL,
      3.447443,
      NULL,
      3,
      0,
      NULL,
      18.370545,
      27,
      0.431005,
      NULL,
      NULL,
      NULL,
      2.725430,
      4.126683,
      NULL,
      8.375538,
      5.007007,
      3,
      2,
      4.067492,
      NULL,
      1,
      3,
      0.124964,
      0.129872,
      NULL,
      NULL,
      0.543393,
      1,
      3.903946,
      13.507509,
      2.783181,
      9.538364,
      19,
      7,
      4.746552,
      3.899694,
      10.066073,
      11,
      15.345185,
      NULL,
      NULL,
      NULL,
      0,
      0.344694,
      16,
      0.721311,
      4.426770,
      1.927696,
      1.028892,
      NULL,
      1,
      1.213982,
      1.016031,
      0,
      0,
      0.463244,
      1,
      3,
      1.409929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.850720,
      1,
      NULL,
      3.763503,
      3.819007,
      3,
      1.064424,
      0,
      1,
      NULL,
      3.095395,
      1,
      3,
      1,
      1.935095,
      1,
      3,
      NULL,
      1,
      0.952058,
      1.342303,
      NULL,
      1,
      0,
      0.449187,
      28,
      NULL,
      NULL,
      0,
      0.318044,
      NULL,
      3.176675,
      0,
      1.994147,
      1.313716,
      2.945046,
      NULL,
      1,
      2,
      3,
      60.047742,
      54.711091,
      6,
      0,
      1.176915,
      '43140',
      '31123',
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


