set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5607545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '34',
      '03',
      14.846734,
      36.775801,
      '1123032',
      1,
      0.690580,
      2,
      NULL,
      '2344',
      NULL,
      1.607199,
      NULL,
      NULL,
      ' 4-23-1982',
      1,
      NULL,
      NULL,
      1.061099,
      NULL,
      ' 3-12-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 7-1982',
      0.723069,
      0.163865,
      NULL,
      1,
      NULL,
      0.962847,
      NULL,
      1.952713,
      NULL,
      NULL,
      NULL,
      NULL,
      5.932275,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.555947,
      NULL,
      0.687561,
      0.567808,
      0,
      NULL,
      0.995516,
      0.165123,
      0.262153,
      NULL,
      0,
      0.409253,
      1,
      NULL,
      0.828333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.096708,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266529,
      1,
      0,
      0.078370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.655234,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1.923514,
      1.970089,
      0,
      0,
      1.190327,
      0,
      0.947484,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.989131,
      NULL,
      0.278769,
      3.147422,
      3,
      2,
      NULL,
      1.744603,
      1.019185,
      1,
      7.784604,
      NULL,
      1.273841,
      8,
      1,
      3,
      1.271052,
      2,
      NULL,
      1,
      5.632114,
      3.038331,
      1,
      1.514714,
      0.947804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.619134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.615576,
      1.684050,
      1,
      0.103687,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627790,
      2,
      8.006892,
      1,
      0,
      0.683444,
      0.018710,
      NULL,
      NULL,
      NULL,
      1.695262,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.378949,
      NULL,
      1.272994,
      0.662039,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.767049,
      1,
      3.785136,
      3,
      3.378502,
      0.645026,
      1.777549,
      3,
      NULL,
      0.064127,
      3,
      3,
      0.996446,
      0.282934,
      1,
      0.197076,
      0,
      NULL,
      0.814242,
      1.264762,
      NULL,
      1,
      0.167464,
      0,
      NULL,
      0.316994,
      1,
      3,
      0.614432,
      NULL,
      3.661258,
      NULL,
      4.910103,
      NULL,
      4.758710,
      2.485399,
      3.773819,
      4,
      1,
      NULL,
      3,
      NULL,
      0.585500,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1,
      NULL,
      '',
      '',
      1.421235,
      '',
      NULL,
      '',
      0.874422,
      '2121',
      NULL,
      '',
      3.331902,
      11.964772,
      107,
      5.967911,
      3.537514,
      36,
      2.343039,
      NULL,
      NULL,
      0,
      2.393767,
      1,
      1,
      NULL,
      NULL,
      1.378626,
      NULL,
      NULL,
      1,
      1,
      0.794398,
      0.731661,
      2,
      1,
      NULL,
      0.870209,
      0,
      2.651425,
      0.093142,
      1,
      NULL,
      0.603843,
      1.955206,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.573060,
      0,
      5,
      2,
      4.221467,
      0,
      0.497971,
      NULL,
      NULL,
      NULL,
      1.744750,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073998,
      1.210350,
      2.975106,
      3.634359,
      0,
      0.040420,
      NULL,
      0,
      NULL,
      NULL,
      1.726514,
      3.236139,
      0.449507,
      3,
      3,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.083712,
      0.172553,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4,
      5.281202,
      1.104297,
      0,
      NULL,
      NULL,
      NULL,
      0.080993,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.591276,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460942,
      1,
      0.976343,
      2.547261,
      1,
      3.394894,
      1.824770,
      NULL,
      NULL,
      7.470161,
      6.837048,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392003,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.386895,
      2.575119,
      0.154740,
      NULL,
      NULL,
      NULL,
      3,
      5.661097,
      5,
      3.073563,
      4,
      NULL,
      NULL,
      NULL,
      1.579085,
      1.403467,
      0,
      0,
      1,
      2.156324,
      3.497064,
      1.435241,
      3.359620,
      7.165438,
      6,
      2,
      NULL,
      2,
      1,
      0.168471,
      0,
      3.937313,
      NULL,
      NULL,
      NULL,
      2,
      1.694334,
      3,
      1,
      0,
      9,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      0,
      1.732379,
      1,
      0,
      NULL,
      NULL,
      1.390158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.296620,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285411,
      NULL,
      NULL,
      NULL,
      1,
      2.603893,
      3.535559,
      NULL,
      NULL,
      2,
      0.806431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793503,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.128007,
      2,
      NULL,
      NULL,
      3.736282,
      2.666488,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.715160,
      1,
      NULL,
      NULL,
      0.623167,
      NULL,
      NULL,
      NULL,
      0.693165,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.272137,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.661900,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      5,
      14,
      1,
      4.146556,
      3525.601298,
      1.756388,
      NULL,
      NULL,
      1,
      3.992202,
      3312,
      0.135991,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.568548,
      NULL,
      0,
      203,
      1.627635,
      1,
      NULL,
      0.358080,
      0,
      0.184196,
      NULL,
      NULL,
      NULL,
      0.793893,
      1.342392,
      0.310704,
      0.781792,
      1.616670,
      1,
      0.994213,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.465432,
      NULL,
      0.434752,
      NULL,
      0.108039,
      NULL,
      71.379898,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.423601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610376,
      NULL,
      0.210917,
      NULL,
      1,
      NULL,
      0.002303,
      NULL,
      0.576892,
      NULL,
      0.567207,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.612939,
      NULL,
      0.378110,
      NULL,
      0.238784,
      NULL,
      0.711752,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.248816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.830742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.726736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545429,
      NULL,
      NULL,
      2.903543,
      NULL,
      1,
      NULL,
      160.395767,
      NULL,
      0,
      NULL,
      1.873757,
      NULL,
      1.058020,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7.053539,
      3.106814,
      6.902791,
      5.461615,
      0.230917,
      11.332042,
      0,
      0.273891,
      1,
      0.723971,
      NULL,
      0,
      1.661839,
      3,
      1,
      1,
      2,
      3.855847,
      NULL,
      NULL,
      0,
      2,
      3,
      3,
      0.545635,
      0.848263,
      0.883708,
      1.424583,
      3.032726,
      2.721976,
      NULL,
      1.150260,
      1.854224,
      NULL,
      1,
      1,
      1,
      3,
      0.092013,
      0,
      NULL,
      1,
      2.621556,
      3,
      0.198680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.967785,
      1,
      3.643396,
      1,
      1,
      0,
      0.067041,
      1.399079,
      2,
      1.019333,
      0,
      2,
      1,
      0,
      2.362989,
      0.890934,
      2.277959,
      0,
      0.431983,
      2.276224,
      3.835701,
      2,
      NULL,
      NULL,
      0.610617,
      3.612866,
      0,
      NULL,
      1,
      59.861968,
      0,
      NULL,
      2,
      3,
      NULL,
      1.758696,
      2.672836,
      1,
      NULL,
      2.433438,
      NULL,
      2,
      7,
      0.845918,
      2,
      NULL,
      3,
      '20413',
      '20003',
      '',
      0.600546,
      '',
      '',
      '',
      0.512529,
      '4244',
      '',
      '');
commit;
end;
/


