set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9966597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.472681,
      2.921347,
      3.889109,
      2,
      1.240479,
      NULL,
      2.581480,
      2.609572,
      '344',
      '40413300',
      24,
      39,
      NULL,
      0,
      NULL,
      2,
      3,
      '2442',
      NULL,
      0.709949,
      NULL,
      NULL,
      ' 1-24-2002',
      36,
      78,
      NULL,
      1.291453,
      2.893427,
      ' 6-16-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 1- 9-2001',
      NULL,
      '10- 5-1980',
      1.331754,
      2,
      2.496321,
      2,
      1,
      0,
      3.118511,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.036891,
      2.302480,
      0,
      NULL,
      NULL,
      1,
      1,
      3.707001,
      0.922372,
      3,
      3,
      0,
      1,
      1.285143,
      0.736554,
      0.221484,
      NULL,
      1.481621,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.000731,
      1,
      0.789673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.668159,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263142,
      1,
      0,
      6.166478,
      0.097940,
      NULL,
      NULL,
      0.273033,
      0,
      3.007026,
      1.870818,
      1,
      4.853683,
      NULL,
      1,
      0.012264,
      0.080701,
      0,
      NULL,
      0,
      1.722833,
      3,
      NULL,
      5.030348,
      NULL,
      7,
      4,
      1,
      1.661890,
      1.434488,
      0,
      0.259209,
      2.899028,
      4,
      7.403880,
      7.400326,
      4.544299,
      7.952049,
      3.039034,
      7,
      1.940343,
      1.547233,
      1.357913,
      4.903191,
      0,
      3.067171,
      1,
      ' 7- 5-1989',
      228,
      ' 4-26-1992',
      51.104509,
      1,
      1,
      0.311895,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631296,
      5.697562,
      2.037575,
      0,
      NULL,
      1.849332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675307,
      NULL,
      NULL,
      NULL,
      NULL,
      5.655904,
      1,
      0,
      0.790581,
      1.141529,
      0.688561,
      6,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.235304,
      0.829029,
      6,
      8,
      0.249058,
      NULL,
      1.276271,
      NULL,
      NULL,
      NULL,
      NULL,
      0.984474,
      1.154475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.225309,
      0.387598,
      0.541945,
      NULL,
      1,
      2,
      4,
      1.323744,
      0,
      NULL,
      NULL,
      NULL,
      1.707496,
      0,
      2,
      2,
      0.814518,
      NULL,
      3,
      0,
      3.764684,
      2.673980,
      3.954580,
      3.811064,
      1,
      1,
      3.345956,
      NULL,
      3.562374,
      1,
      NULL,
      3,
      NULL,
      1.197362,
      1.056725,
      1.505598,
      1,
      0,
      1,
      0.869109,
      0.948305,
      NULL,
      2.638883,
      0.010776,
      2,
      1,
      4,
      7,
      4.572459,
      6,
      5.139003,
      NULL,
      7.868956,
      3,
      2,
      2,
      NULL,
      2.370865,
      1.657148,
      52.035839,
      NULL,
      NULL,
      NULL,
      2.582622,
      1.463932,
      1.407579,
      '12240',
      '34200',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.780693,
      30.239215,
      28,
      16.785750,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.127844,
      NULL,
      NULL,
      3.359365,
      0,
      0,
      1,
      NULL,
      NULL,
      0.505652,
      3.129088,
      0.631478,
      NULL,
      2.157471,
      1.387249,
      1.544093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.330466,
      NULL,
      NULL,
      2.783254,
      9.697001,
      1.380556,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.882116,
      NULL,
      NULL,
      NULL,
      1.452183,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680829,
      NULL,
      NULL,
      1.687681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325989,
      1,
      0.746561,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.797974,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669683,
      0.691901,
      3.013967,
      1.302398,
      NULL,
      NULL,
      1.147730,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006805,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.641350,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.302968,
      1.637584,
      0,
      1,
      1,
      NULL,
      4.120989,
      4,
      NULL,
      1,
      0,
      3,
      3,
      0,
      2.205910,
      1,
      3,
      1.489002,
      1.833571,
      8.490549,
      5,
      3,
      1.429574,
      0,
      3.247230,
      3,
      0.857154,
      3.685105,
      2,
      1,
      NULL,
      1.865769,
      3.492932,
      NULL,
      1.422219,
      5.939539,
      NULL,
      2,
      5.469093,
      2.417790,
      2.470145,
      4,
      1,
      1,
      0.661914,
      NULL,
      1.570692,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192984,
      NULL,
      NULL,
      2.550150,
      NULL,
      NULL,
      0.561715,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.770649,
      1,
      3.187658,
      0.297127,
      0.019864,
      3.044346,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.541600,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.345392,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.683791,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.736027,
      NULL,
      NULL,
      NULL,
      1.681969,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.191645,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.090478,
      1.186976,
      2.192629,
      57.039573,
      1.777381,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.239481,
      NULL,
      1.433264,
      0,
      0.679065,
      NULL,
      NULL,
      3.585254,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.927868,
      0,
      NULL,
      1,
      1.321773,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2.058528,
      NULL,
      1,
      NULL,
      12.674076,
      NULL,
      3.043411,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.946049,
      NULL,
      0.369699,
      NULL,
      0.722149,
      NULL,
      1,
      NULL,
      1.939628,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.019856,
      NULL,
      1,
      NULL,
      0.463511,
      NULL,
      0,
      NULL,
      0.033107,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323253,
      1.374974,
      1,
      0.229534,
      0.874568,
      2,
      0,
      NULL,
      NULL,
      1,
      3.524350,
      0.779744,
      NULL,
      0.818535,
      NULL,
      1,
      2,
      NULL,
      0.686761,
      1.113135,
      NULL,
      1,
      1,
      NULL,
      0.325409,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.426432,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1.930302,
      NULL,
      1,
      3,
      NULL,
      2.954442,
      1.931287,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      2,
      3.826393,
      1.898670,
      NULL,
      NULL,
      96.050133,
      16,
      3.912304,
      NULL,
      2,
      '44342',
      '32012',
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


