set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6414280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '2431132',
      0,
      1,
      3,
      2,
      NULL,
      2,
      0.352102,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      ' 3-15-1983',
      47,
      0,
      10.370950,
      21.057322,
      1.857430,
      NULL,
      NULL,
      ' 4-19-1978',
      NULL,
      0,
      NULL,
      0.321033,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      17.082809,
      0.259475,
      NULL,
      4.913380,
      2.036556,
      0,
      4,
      1.263363,
      0,
      1.985660,
      1,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1.925042,
      NULL,
      3.166954,
      13,
      3,
      NULL,
      0.685367,
      1,
      0,
      1,
      0,
      0.119664,
      0.679906,
      1.426902,
      1.250261,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.356397,
      0,
      0.592446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677438,
      1.726844,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.907518,
      NULL,
      0.626682,
      1,
      0.292987,
      1.562369,
      1.407554,
      0.023119,
      0,
      NULL,
      1.268301,
      NULL,
      0.166368,
      0,
      0.751703,
      0.838625,
      NULL,
      1,
      0.127490,
      0,
      1,
      NULL,
      0.570280,
      1,
      1,
      NULL,
      0,
      1.374741,
      NULL,
      0.824884,
      1.073523,
      NULL,
      1.064812,
      1.605184,
      NULL,
      0,
      0,
      0.708759,
      1.327475,
      NULL,
      NULL,
      1.796886,
      0.142368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.043639,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.202557,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0.903193,
      3,
      0.468826,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.668399,
      0,
      0.038783,
      0,
      0.064991,
      0,
      0,
      6.973023,
      3,
      1,
      NULL,
      NULL,
      1,
      2,
      3.575747,
      1.990170,
      8,
      NULL,
      NULL,
      5.312475,
      7,
      8,
      ' 7-12-2002',
      273,
      ' 0-25-1993',
      NULL,
      NULL,
      4,
      1,
      NULL,
      2,
      0.610111,
      1,
      1,
      0,
      1.763189,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.357428,
      NULL,
      NULL,
      0,
      NULL,
      3.338431,
      NULL,
      NULL,
      2,
      1.902141,
      1.739234,
      3,
      1.274181,
      NULL,
      6,
      84,
      NULL,
      NULL,
      91,
      58.626265,
      28,
      1,
      1.527089,
      1.216102,
      1.976177,
      1.084943,
      1,
      1.639367,
      1.498568,
      0,
      1.441609,
      8.103584,
      3.877845,
      5,
      0,
      1,
      2,
      4.168080,
      2,
      4,
      3.247952,
      1,
      3,
      4,
      0.079316,
      0.977144,
      24,
      NULL,
      NULL,
      NULL,
      0.866087,
      NULL,
      0.621158,
      '23102',
      '',
      '',
      0,
      '',
      '',
      '',
      0.548312,
      '',
      '',
      NULL,
      1.256229,
      20.578961,
      NULL,
      26,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.938729,
      NULL,
      NULL,
      0.021690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.793951,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.688680,
      NULL,
      NULL,
      1.522106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.886878,
      NULL,
      NULL,
      1.983890,
      NULL,
      NULL,
      1.718071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402412,
      NULL,
      NULL,
      0.301343,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.580628,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151554,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.355629,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.456609,
      NULL,
      NULL,
      1.108950,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.538798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490780,
      NULL,
      NULL,
      1.095715,
      NULL,
      NULL,
      1.315006,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.098414,
      0.508434,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.932496,
      2.808578,
      1,
      NULL,
      1.560497,
      1.372756,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.647515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323337,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.533981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.130002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      0.560897,
      1.450477,
      NULL,
      NULL,
      NULL,
      2.444228,
      NULL,
      0.447120,
      NULL,
      NULL,
      NULL,
      1.590474,
      NULL,
      NULL,
      1.720404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1069.721746,
      0,
      1,
      0.579873,
      0.499468,
      NULL,
      0.997296,
      0,
      NULL,
      0.684678,
      0,
      0.253114,
      0.117062,
      1.272486,
      0.323608,
      0.385939,
      0.016578,
      1,
      1.404242,
      1.816806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.782222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.978697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714248,
      3.089513,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.978763,
      0.759741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.275084,
      2,
      NULL,
      1,
      1.240691,
      1,
      1.478863,
      0.726937,
      2.054119,
      0.283069,
      0.909418,
      0,
      1.178478,
      0,
      0.536604,
      0.549923,
      1.603855,
      1.226134,
      0,
      0.262740,
      NULL,
      0,
      1,
      1.174306,
      0.891566,
      0.855919,
      0.311194,
      1.158379,
      1,
      NULL,
      0.833126,
      1,
      0.580989,
      0.305657,
      NULL,
      0,
      1.648276,
      0.372581,
      0.105107,
      1.154112,
      1.863525,
      0.648900,
      0,
      NULL,
      NULL,
      3,
      1.665429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334029,
      0.750789,
      1.959695,
      0,
      1,
      1.531384,
      0.223335,
      5,
      0.391673,
      1,
      NULL,
      NULL,
      73.243005,
      90,
      0.759320,
      1,
      3.976952,
      '02024',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


