set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857458';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.165024,
      NULL,
      3,
      1.224339,
      NULL,
      2.668094,
      3.488227,
      0,
      '144',
      '22004414',
      17.661264,
      6.771419,
      '4410100',
      1,
      0.057214,
      0,
      0,
      '0023',
      2.953289,
      1.220485,
      NULL,
      NULL,
      NULL,
      NULL,
      137,
      NULL,
      0.935249,
      NULL,
      '10-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      0.012030,
      ' 6-21-1988',
      ' 4- 1-1994',
      NULL,
      3,
      2.468748,
      3.253969,
      NULL,
      NULL,
      3,
      1.856196,
      NULL,
      1.702177,
      8,
      1.762397,
      7,
      2.825401,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206090,
      2.591400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      8.840176,
      NULL,
      0.331140,
      5,
      NULL,
      1,
      NULL,
      1.146763,
      1,
      4.605522,
      1.287699,
      0,
      0.558168,
      0,
      0.882395,
      5,
      NULL,
      NULL,
      NULL,
      3.958874,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008468,
      1.298446,
      1.799109,
      1,
      0.077522,
      0.621593,
      0,
      0.146611,
      1,
      0,
      3.056196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.854328,
      1.926869,
      1.433870,
      0.515717,
      1,
      9.462979,
      NULL,
      1.643764,
      0.087319,
      0.651280,
      0.699945,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.534047,
      0.960626,
      0,
      1.687034,
      0.005911,
      0,
      1,
      1,
      1.541220,
      1.659289,
      1.938758,
      0,
      1,
      0,
      1.570703,
      0,
      1.360654,
      0,
      NULL,
      NULL,
      0.765744,
      7,
      2,
      1.937158,
      5.887303,
      1.053300,
      5,
      2,
      1.784867,
      6,
      7.530178,
      2,
      0.162918,
      6,
      1,
      2.636971,
      1,
      0.425683,
      NULL,
      4,
      4,
      7,
      1,
      3.580292,
      2.181003,
      0,
      5.736478,
      3,
      ' 3- 1-1990',
      NULL,
      NULL,
      332,
      NULL,
      1.639270,
      1.329427,
      1.341293,
      1.276825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423835,
      0,
      1.160732,
      0.462743,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036692,
      NULL,
      8.826148,
      NULL,
      1,
      6,
      1.387266,
      1,
      3.983957,
      1,
      NULL,
      NULL,
      0.705638,
      1.176130,
      NULL,
      0,
      1,
      1,
      NULL,
      1.420732,
      4,
      0,
      3.452680,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.905043,
      1.538209,
      0,
      1,
      NULL,
      1.653339,
      3.149949,
      5.080015,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.071003,
      0,
      2,
      3,
      2.774303,
      NULL,
      0,
      0,
      3.373280,
      3.090817,
      0.802691,
      1,
      2.684495,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1.077656,
      0.070037,
      0,
      1.433918,
      0.771346,
      1.691498,
      3.022058,
      0,
      NULL,
      NULL,
      NULL,
      4,
      4.280673,
      6,
      5,
      0.504881,
      NULL,
      3.801392,
      2.308384,
      0,
      NULL,
      3.766642,
      1,
      10.544818,
      NULL,
      32,
      NULL,
      0.004178,
      0,
      1.897441,
      '12043',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.045088,
      NULL,
      42,
      9.298908,
      2.727876,
      1.739066,
      NULL,
      3,
      4.613342,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.690435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929767,
      NULL,
      NULL,
      3,
      1.263183,
      1,
      0.588691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.849815,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      2.076059,
      0.404494,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.895104,
      0.893743,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.509023,
      0,
      1.397768,
      0,
      0,
      0.957613,
      3,
      0,
      1,
      3.981943,
      1.776163,
      1,
      0,
      0.961087,
      1.180015,
      1.858885,
      NULL,
      NULL,
      0.686276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      5.674700,
      1.265089,
      1.384705,
      NULL,
      NULL,
      NULL,
      1.343274,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.800497,
      NULL,
      NULL,
      3.012025,
      0.250351,
      0,
      1.195741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.934171,
      NULL,
      0.813942,
      0.867461,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.164060,
      NULL,
      NULL,
      3.624506,
      1.971183,
      1.122360,
      4.449568,
      0,
      0.308072,
      3,
      0.490013,
      2,
      2.294989,
      NULL,
      1.159724,
      4,
      0.000265,
      1,
      2.667061,
      2.364424,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      1,
      1.584014,
      3,
      3.873329,
      3.756971,
      NULL,
      NULL,
      2.476766,
      3,
      NULL,
      3.185040,
      3.435550,
      1,
      2,
      NULL,
      0,
      3,
      NULL,
      0.249361,
      0,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      0.857865,
      2,
      6,
      1.388961,
      1.408048,
      0.860349,
      NULL,
      1.009739,
      0.742188,
      NULL,
      NULL,
      0.747566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.624425,
      NULL,
      NULL,
      1.666762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127147,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.824635,
      1,
      0.884585,
      0.129444,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.814237,
      NULL,
      NULL,
      NULL,
      3.314330,
      NULL,
      NULL,
      NULL,
      1.418860,
      NULL,
      NULL,
      NULL,
      0.720416,
      NULL,
      NULL,
      NULL,
      0.663092,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.347750,
      NULL,
      NULL,
      NULL,
      0.458815,
      NULL,
      NULL,
      NULL,
      1.440698,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401860,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284026,
      50.955412,
      16,
      2.282139,
      NULL,
      NULL,
      1.540675,
      NULL,
      NULL,
      NULL,
      0.082904,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      58,
      7,
      1,
      0.807226,
      0,
      1,
      0,
      0,
      1,
      0.026179,
      1.506085,
      0.082602,
      NULL,
      0.337279,
      1.296487,
      0.095958,
      0,
      0,
      1,
      0.538122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.846894,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1.092460,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1.973248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.011051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.627749,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.146127,
      0.388687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675270,
      NULL,
      0,
      1,
      0.389842,
      NULL,
      2,
      NULL,
      7,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.841616,
      3,
      NULL,
      0.837658,
      2,
      NULL,
      0,
      1.166355,
      NULL,
      1.520746,
      1,
      NULL,
      1.077559,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      3.166116,
      NULL,
      NULL,
      0.086816,
      NULL,
      0,
      2.187156,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.973601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819063,
      NULL,
      1,
      NULL,
      0.039168,
      NULL,
      1,
      NULL,
      4.668274,
      1,
      NULL,
      NULL,
      40.637735,
      92,
      5.032550,
      0,
      0,
      '41442',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


