set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9903181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      NULL,
      0,
      0,
      2,
      1.908846,
      4,
      NULL,
      '02112314',
      43.310634,
      76,
      '1432202',
      NULL,
      0,
      3,
      2,
      '2442',
      1,
      0,
      NULL,
      NULL,
      ' 1-22-1989',
      18.699213,
      29,
      NULL,
      0.884050,
      NULL,
      ' 7-28-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 5-25-1974',
      ' 6-15-1989',
      ' 9-24-1975',
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071509,
      2,
      NULL,
      1,
      NULL,
      0.909083,
      NULL,
      0.096665,
      0.322378,
      NULL,
      0.871440,
      0,
      1.706383,
      0,
      0,
      1,
      2,
      2,
      9.582994,
      1,
      1,
      4,
      6.731359,
      1.474869,
      7.601675,
      NULL,
      0,
      3.312558,
      6.353282,
      NULL,
      6,
      1,
      5.483846,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.270730,
      NULL,
      NULL,
      0,
      1.428280,
      NULL,
      0.967561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310648,
      3,
      4,
      0.896900,
      NULL,
      0.166653,
      0.285045,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      9.840686,
      4.728323,
      6,
      1,
      4.533526,
      NULL,
      4.967638,
      4.711247,
      1,
      6,
      1,
      1,
      1,
      NULL,
      1.613146,
      NULL,
      1,
      1.841894,
      1.468149,
      1.915806,
      0.635988,
      5,
      3,
      1,
      1,
      0.942580,
      NULL,
      1,
      1.048423,
      1,
      2,
      0,
      NULL,
      0,
      6.832772,
      0.028455,
      NULL,
      NULL,
      1,
      0.609446,
      0.041264,
      4.690162,
      5,
      3.829050,
      ' 0-19-1991',
      5,
      ' 4- 6-2001',
      4.155879,
      1,
      1,
      NULL,
      1,
      NULL,
      9,
      NULL,
      0,
      3,
      NULL,
      5.065828,
      8,
      2,
      5.211969,
      0,
      2,
      0.662761,
      0.810197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664795,
      NULL,
      0.710288,
      1.661774,
      3.513882,
      7.884296,
      NULL,
      1,
      6.597256,
      1,
      NULL,
      0.969482,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.819559,
      3,
      NULL,
      0.428119,
      1.781785,
      0.545838,
      10,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.706215,
      2.617863,
      3.827373,
      2.538704,
      3.711654,
      1,
      3,
      2.441384,
      0,
      3.561611,
      2,
      NULL,
      2.789997,
      1,
      0.328866,
      1,
      1.946366,
      3,
      0,
      0.180629,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.186716,
      1.987684,
      2.572187,
      NULL,
      NULL,
      NULL,
      4.731172,
      1.693193,
      NULL,
      8,
      1.714254,
      4,
      0,
      3,
      1,
      2,
      2.700558,
      29,
      2.076099,
      0,
      28,
      NULL,
      27.054148,
      47.783589,
      5.539659,
      0.038104,
      3.698676,
      '0304',
      NULL,
      '',
      1.226948,
      '',
      '',
      '',
      0.697627,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.241023,
      NULL,
      NULL,
      1.068901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108884,
      1.648153,
      NULL,
      0,
      NULL,
      0.053104,
      1,
      0.732528,
      1.013230,
      0.395943,
      1.805090,
      0,
      NULL,
      0.604272,
      NULL,
      0.779661,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.710148,
      0.721368,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.793405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.732198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.440361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792401,
      1,
      2,
      0,
      1.763885,
      0,
      44,
      NULL,
      0.445399,
      1.169837,
      1.632552,
      0,
      0,
      0.233959,
      NULL,
      0,
      21.504807,
      NULL,
      1.911164,
      NULL,
      NULL,
      NULL,
      0.323104,
      NULL,
      1,
      1,
      NULL,
      0.057114,
      0,
      1,
      0,
      1.387497,
      2,
      0,
      1.115395,
      1.954758,
      NULL,
      1,
      1.363411,
      NULL,
      1,
      1.982503,
      NULL,
      0.726036,
      1,
      NULL,
      1.673523,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016054,
      0.350623,
      NULL,
      0.896916,
      1.907679,
      NULL,
      0.455542,
      1.946226,
      NULL,
      1.591274,
      0,
      NULL,
      0.593500,
      0.937291,
      NULL,
      2,
      NULL,
      0.816783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171079,
      NULL,
      1.158333,
      NULL,
      0,
      2.465447,
      2,
      1,
      NULL,
      NULL,
      64.981281,
      144.393367,
      0.791215,
      1.742484,
      3.283400,
      '4344',
      '14443',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL);
commit;
end;
/


