set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032078';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '2031232',
      1.730085,
      NULL,
      2,
      3,
      '0211',
      3.918504,
      1,
      NULL,
      NULL,
      '10-11-2003',
      NULL,
      NULL,
      4.093790,
      0,
      NULL,
      ' 6- 9-1976',
      12,
      1,
      NULL,
      83,
      2,
      NULL,
      NULL,
      ' 8-14-1982',
      0.240030,
      NULL,
      NULL,
      0.688895,
      1,
      1,
      2,
      NULL,
      2,
      NULL,
      6.660606,
      14,
      3.036828,
      10.906195,
      NULL,
      7.606920,
      19.958338,
      NULL,
      3,
      1.174978,
      0.927770,
      NULL,
      3.063295,
      NULL,
      NULL,
      0.486668,
      1.445425,
      1,
      NULL,
      1,
      1.927230,
      0.978355,
      1.112502,
      2,
      NULL,
      1,
      0.830609,
      NULL,
      1.942913,
      0,
      0.368101,
      0.184274,
      0,
      1,
      0,
      1.415005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710013,
      0.048547,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.243172,
      0,
      0.595297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.300407,
      0,
      0,
      0,
      4,
      0,
      0.520405,
      1,
      1.363505,
      NULL,
      2,
      0.008703,
      0.436465,
      NULL,
      0.238157,
      NULL,
      0.177009,
      0.870978,
      1.026103,
      NULL,
      0.967051,
      0.327185,
      1,
      NULL,
      0,
      3.463361,
      0.673016,
      0,
      1.762219,
      0,
      0.086140,
      1.034899,
      1,
      0,
      5.207578,
      1.387306,
      0.366565,
      0,
      1,
      0,
      1,
      0.744804,
      0.377529,
      0.932315,
      1.600586,
      1,
      0,
      0.174589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.534289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.130844,
      1.661765,
      NULL,
      1.220549,
      2.007178,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.304669,
      NULL,
      0,
      1.005854,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.224235,
      0.562112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.216424,
      0.698541,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002434,
      0.772198,
      1,
      0,
      3.494863,
      4.053841,
      3,
      0.996165,
      2.274918,
      5,
      0.381418,
      5.313874,
      0.148324,
      5.057924,
      3,
      NULL,
      0,
      2,
      0.472126,
      0.939218,
      3,
      NULL,
      0,
      NULL,
      0,
      3,
      1.172843,
      1.081774,
      4.766809,
      0.610897,
      2,
      0,
      NULL,
      9,
      NULL,
      2,
      NULL,
      1.375127,
      1,
      NULL,
      3.929954,
      0.899908,
      0.920001,
      1,
      39,
      NULL,
      NULL,
      13.761103,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      '24024',
      '',
      0,
      '',
      NULL,
      '',
      3,
      '1130',
      NULL,
      '',
      3.495636,
      NULL,
      996.017594,
      14.524301,
      1.250373,
      26.435484,
      9,
      25.613232,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.843991,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909376,
      2.146676,
      1.134569,
      0.448163,
      0,
      0.276079,
      0.744405,
      NULL,
      NULL,
      1,
      1.219883,
      1.937978,
      3,
      1,
      1.368609,
      NULL,
      0,
      1.661850,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.965681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.952910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.669305,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.502634,
      NULL,
      NULL,
      5,
      4,
      0,
      0.913752,
      NULL,
      NULL,
      0.900080,
      NULL,
      NULL,
      0.680754,
      NULL,
      NULL,
      1,
      1,
      0,
      0.411998,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.929231,
      1,
      3.196968,
      1,
      0,
      6.161570,
      2,
      1,
      1.843131,
      NULL,
      NULL,
      NULL,
      1.153867,
      NULL,
      1.204068,
      1.927856,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.350023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887212,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.169916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778125,
      NULL,
      NULL,
      0.620726,
      NULL,
      NULL,
      NULL,
      0,
      6,
      0,
      NULL,
      NULL,
      2.105790,
      3.384637,
      NULL,
      1.520049,
      1.970889,
      NULL,
      3,
      NULL,
      NULL,
      101,
      NULL,
      NULL,
      1.071357,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.586849,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.945613,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      7,
      NULL,
      0,
      0,
      1,
      3,
      1.714504,
      1.097988,
      0.596640,
      1.709194,
      NULL,
      NULL,
      NULL,
      0.034884,
      NULL,
      NULL,
      NULL,
      0.569451,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.387037,
      NULL,
      NULL,
      NULL,
      0.212162,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.228964,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.438351,
      NULL,
      NULL,
      NULL,
      7.266053,
      NULL,
      0.815350,
      NULL,
      NULL,
      NULL,
      2,
      49.347968,
      5.258356,
      1.809926,
      NULL,
      NULL,
      0.565335,
      NULL,
      NULL,
      0.688560,
      NULL,
      NULL,
      3.160333,
      273,
      1,
      2,
      196.602078,
      NULL,
      2.797408,
      275.050642,
      3,
      NULL,
      0.003786,
      1.932702,
      NULL,
      0.852763,
      1.431211,
      1.384940,
      NULL,
      1,
      0,
      1,
      1,
      1.601983,
      1.751679,
      0,
      1.099840,
      1.583697,
      1.674507,
      1,
      1.315638,
      NULL,
      0.238484,
      NULL,
      1.401833,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      153.604067,
      NULL,
      1.012842,
      28.650793,
      80,
      0.942079,
      NULL,
      NULL,
      NULL,
      1.557320,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.945738,
      NULL,
      1.511367,
      NULL,
      0.254338,
      NULL,
      0.870193,
      NULL,
      0.781200,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.707675,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.908702,
      0.331898,
      1.523978,
      0.616354,
      1.805296,
      1,
      NULL,
      1.650607,
      NULL,
      0.625312,
      0,
      0.017234,
      NULL,
      0.183083,
      0,
      1,
      1.754140,
      NULL,
      NULL,
      0.364719,
      1,
      1.728470,
      1,
      0,
      0,
      NULL,
      1.643715,
      0.949658,
      1,
      0,
      1,
      2.627119,
      2.406354,
      3.897224,
      3,
      1.125581,
      1.610599,
      1,
      1.466683,
      1,
      0,
      0.215621,
      2,
      0,
      NULL,
      1.152419,
      2.904039,
      1.516372,
      3,
      2,
      0.337055,
      NULL,
      0.046587,
      0.434673,
      0.822484,
      1,
      0,
      NULL,
      1,
      0,
      1.697864,
      1,
      1.681737,
      0,
      3,
      3,
      0,
      NULL,
      0.531212,
      0.059013,
      3,
      33,
      NULL,
      NULL,
      1,
      1.354268,
      3,
      0.455424,
      1.219130,
      NULL,
      NULL,
      0.961262,
      0,
      2.193998,
      NULL,
      2.218226,
      2,
      0,
      NULL,
      1.000173,
      NULL,
      1,
      NULL,
      1.556263,
      0.667343,
      0.635356,
      1,
      1,
      0.947500,
      2,
      3.100659,
      25.946527,
      1,
      NULL,
      1.565537,
      1,
      NULL,
      NULL,
      3,
      3.046259,
      NULL,
      7.486392,
      7.566322,
      NULL,
      NULL,
      NULL,
      55,
      41.698507,
      1.230333,
      0,
      5,
      '33141',
      '02123',
      '30220',
      1.224295,
      NULL,
      '',
      '',
      0,
      '2244',
      '',
      '');
commit;
end;
/


