set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9036326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0221420',
      1,
      1.528239,
      5,
      NULL,
      '2340',
      1,
      0,
      NULL,
      NULL,
      ' 2-11-1989',
      8.579864,
      NULL,
      2.816205,
      1.017209,
      4.282935,
      '10- 7-1980',
      15.243144,
      3,
      295,
      19.422958,
      NULL,
      ' 7-11-1992',
      ' 8-18-1980',
      NULL,
      0.597867,
      0.834701,
      3,
      2.203521,
      0.009144,
      2,
      2.755175,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.164339,
      27,
      25,
      4,
      12.184481,
      1,
      1,
      3.912146,
      1.291357,
      0.866995,
      1.283265,
      1.624906,
      0,
      0.173906,
      0,
      NULL,
      0,
      4.878017,
      1,
      NULL,
      NULL,
      5.464816,
      1.988153,
      NULL,
      NULL,
      NULL,
      1.242492,
      9.625567,
      0.709480,
      4.034001,
      0,
      1,
      1,
      1,
      0.366138,
      0,
      NULL,
      1,
      3,
      3,
      0,
      NULL,
      NULL,
      0.619496,
      NULL,
      NULL,
      NULL,
      0,
      1.560239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.396848,
      1.993968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873556,
      5,
      2.084539,
      NULL,
      7.740776,
      0,
      2,
      NULL,
      0.475156,
      1.624339,
      4,
      1,
      1,
      1.876227,
      NULL,
      0,
      0.104968,
      1.324094,
      0,
      NULL,
      0,
      3.154167,
      0.164699,
      NULL,
      4,
      NULL,
      5.873186,
      4.250546,
      5,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.691811,
      5.162072,
      3.549167,
      NULL,
      2,
      NULL,
      1.718202,
      2.231871,
      NULL,
      0.457894,
      3.073740,
      2.404654,
      ' 7-28-1998',
      0.335631,
      ' 7-10-1984',
      NULL,
      NULL,
      1.696507,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2,
      0.843620,
      0,
      2.293526,
      5,
      7,
      2,
      1,
      NULL,
      3,
      2.648496,
      3,
      0.654455,
      2.331455,
      ' 1-16-1989',
      16.933183,
      ' 0- 1-1993',
      1.203000,
      0,
      1.546924,
      3.476104,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184776,
      0.377523,
      1,
      NULL,
      3,
      4,
      3,
      1.059602,
      2.172148,
      3,
      0.861732,
      NULL,
      1,
      0,
      0.313311,
      6,
      NULL,
      0,
      5.308082,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969642,
      0,
      1.088824,
      2.275198,
      NULL,
      1.457262,
      1.214801,
      0.803327,
      81,
      1,
      1.020685,
      NULL,
      NULL,
      NULL,
      1.405246,
      0,
      0,
      0,
      NULL,
      1.434155,
      3,
      0.540208,
      2.951479,
      0,
      NULL,
      2.615483,
      0,
      NULL,
      NULL,
      3,
      1,
      0.919259,
      2.980922,
      NULL,
      0,
      1.236479,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.563138,
      1.971374,
      0.515539,
      7,
      0.925184,
      0,
      4,
      NULL,
      11,
      9,
      0,
      4.887106,
      3.987464,
      5.262574,
      1,
      3.709396,
      1.250872,
      64.341175,
      NULL,
      NULL,
      NULL,
      20,
      43.666839,
      69.794816,
      2,
      1.766002,
      0,
      '32301',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.634075,
      '',
      '',
      '',
      0.079065,
      27,
      27,
      0.033601,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.884502,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.468923,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470461,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.899280,
      NULL,
      NULL,
      0.032518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.286189,
      NULL,
      NULL,
      1.361663,
      NULL,
      NULL,
      0.205528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.826705,
      NULL,
      NULL,
      2.129004,
      2.489185,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.099111,
      1.709370,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538389,
      NULL,
      NULL,
      0,
      3.152733,
      NULL,
      0,
      1.472106,
      NULL,
      2,
      5.626148,
      1.316492,
      0,
      NULL,
      1.834715,
      2.564455,
      0,
      1.981247,
      1.075930,
      NULL,
      NULL,
      0.226192,
      2,
      0.630172,
      5,
      5.479371,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.666616,
      0.123101,
      0,
      NULL,
      1,
      1.409329,
      1.296650,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      3.210316,
      NULL,
      NULL,
      NULL,
      0.213266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.496910,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.637327,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.669408,
      NULL,
      NULL,
      NULL,
      0.249535,
      NULL,
      NULL,
      NULL,
      1.078185,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.740514,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.594288,
      4.094797,
      0,
      2.346974,
      3.727952,
      1.813795,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.973727,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.624777,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1.784350,
      NULL,
      0,
      0.808274,
      0.742044,
      0.091752,
      1,
      0,
      1,
      1.789342,
      0.447526,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.398796,
      0.360167,
      4,
      2.515321,
      3,
      0,
      5,
      8.465823,
      NULL,
      3.265869,
      2.199963,
      0.412782,
      0.451863,
      NULL,
      1,
      1.967989,
      1.748144,
      1,
      0.684402,
      NULL,
      0,
      0,
      0,
      1,
      1.974231,
      0,
      1.223658,
      NULL,
      0.479322,
      NULL,
      0,
      1.305905,
      1,
      NULL,
      NULL,
      1.605461,
      0.257951,
      NULL,
      0.818355,
      1,
      0.382400,
      1.603023,
      1.852234,
      0.282574,
      3,
      3,
      1.366707,
      NULL,
      1.956323,
      0,
      NULL,
      1.217550,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.340603,
      NULL,
      0.921498,
      NULL,
      0.405655,
      NULL,
      0.303688,
      NULL,
      0.579301,
      NULL,
      0.337863,
      NULL,
      0.467665,
      NULL,
      1,
      NULL,
      4,
      0,
      NULL,
      2.847581,
      3.251473,
      2.091853,
      1.798693,
      3,
      2,
      0,
      2,
      2.600428,
      1.960053,
      0,
      1.516961,
      0.970987,
      0,
      1,
      2.013851,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.938047,
      1,
      0.269116,
      2,
      10.855482,
      NULL,
      3,
      1.458797,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      5,
      NULL,
      NULL,
      NULL,
      52.085264,
      107,
      NULL,
      1.839268,
      1.215363,
      '34424',
      '',
      '',
      0.388573,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


