set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      0.029611,
      3,
      2,
      '3112',
      0.277254,
      NULL,
      NULL,
      NULL,
      ' 6-26-1982',
      39.616740,
      NULL,
      5,
      2,
      NULL,
      ' 8-18-2003',
      68.556695,
      0.068750,
      122.139091,
      96,
      3.315625,
      ' 2-15-1979',
      '11- 6-1979',
      ' 1-20-2003',
      1,
      NULL,
      2,
      3,
      0.725062,
      3,
      1.844240,
      3.537033,
      NULL,
      NULL,
      NULL,
      7,
      2,
      7.749303,
      NULL,
      NULL,
      22,
      NULL,
      2.193474,
      8.657647,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553014,
      2,
      0,
      10.083675,
      0,
      0.358457,
      1,
      1.389176,
      1,
      NULL,
      1.964930,
      1.707158,
      1.979503,
      0,
      1,
      7.020313,
      1.578293,
      2.749230,
      NULL,
      0,
      0.527670,
      NULL,
      NULL,
      1.742777,
      NULL,
      NULL,
      9,
      1.914330,
      1,
      NULL,
      1.908929,
      NULL,
      1.838579,
      NULL,
      3,
      0.997187,
      1.053526,
      1,
      0.759890,
      NULL,
      0,
      1.510363,
      1,
      0.768375,
      0.430752,
      0.431453,
      NULL,
      1,
      7,
      1,
      NULL,
      0,
      1.978976,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.658672,
      0,
      2,
      NULL,
      1,
      4,
      4,
      0.906391,
      1,
      NULL,
      5.148740,
      1.623990,
      0,
      7,
      0.519026,
      NULL,
      1,
      0.709422,
      1,
      NULL,
      1,
      0,
      NULL,
      0.070222,
      0.144326,
      5,
      3,
      0.865053,
      1.556303,
      1.762259,
      1,
      1,
      1,
      0.829199,
      NULL,
      1.777358,
      NULL,
      0,
      1,
      4.680026,
      7.283169,
      1.155664,
      NULL,
      0,
      1,
      1.363203,
      5,
      3,
      NULL,
      1724.680750,
      ' 5- 2-1991',
      238.550560,
      1.503982,
      0,
      0.775045,
      NULL,
      0.507533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.565466,
      1,
      0,
      0.447064,
      1.805524,
      1.071547,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      0,
      1.795644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.700739,
      1,
      0.003715,
      3,
      1.248132,
      1.069737,
      0,
      0.665562,
      7,
      3.028503,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.467180,
      NULL,
      0.938460,
      0.791858,
      0,
      0.762180,
      NULL,
      17,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.729209,
      3,
      1,
      3,
      0,
      2,
      NULL,
      NULL,
      0,
      2.904682,
      NULL,
      1,
      1.843117,
      1,
      1.295594,
      3.766567,
      NULL,
      3.781988,
      0,
      NULL,
      1.610049,
      1.999069,
      NULL,
      1,
      0.966913,
      1.718345,
      1.274174,
      1,
      4,
      NULL,
      NULL,
      9.232533,
      6,
      9,
      9,
      NULL,
      NULL,
      1,
      4.948581,
      0,
      2.911424,
      1,
      33,
      2.345817,
      1,
      NULL,
      26,
      46.316326,
      NULL,
      1.439967,
      0.111799,
      3.286519,
      '43123',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      NULL,
      22.292957,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.060915,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607756,
      NULL,
      NULL,
      3,
      1.722683,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639302,
      NULL,
      NULL,
      1.547385,
      NULL,
      NULL,
      1.789384,
      NULL,
      NULL,
      6.548663,
      NULL,
      1.246729,
      1.691874,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.544642,
      0,
      1,
      NULL,
      NULL,
      1.535214,
      0.578174,
      0.766388,
      0,
      0,
      1,
      3.255343,
      0.608956,
      3,
      0,
      NULL,
      0.985368,
      NULL,
      2,
      0.204560,
      0,
      0.524335,
      1.546596,
      0.173352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.899866,
      NULL,
      NULL,
      6,
      1.887440,
      1,
      NULL,
      0.047817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.964754,
      NULL,
      0.635378,
      1,
      NULL,
      NULL,
      0.886853,
      0,
      NULL,
      3.138709,
      1,
      1.333096,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.052497,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.939449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.093367,
      1.210043,
      1.634979,
      1.148970,
      0.788330,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340769,
      0,
      0.757935,
      0.338575,
      NULL,
      1,
      1,
      NULL,
      3,
      1.378027,
      1.889710,
      2,
      0.044511,
      1.465784,
      1,
      NULL,
      1.915593,
      3,
      NULL,
      1.310273,
      2,
      1.467305,
      0.115099,
      2.702791,
      0.005990,
      0,
      2.162906,
      NULL,
      1.130063,
      NULL,
      3.052845,
      0,
      1,
      0.315173,
      1,
      NULL,
      0.747051,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.895876,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1.385069,
      1.381136,
      NULL,
      0.733603,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      67.230095,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.522814,
      NULL,
      NULL,
      NULL,
      1.175558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.400419,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.008594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.461180,
      NULL,
      NULL,
      NULL,
      3.744628,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661666,
      NULL,
      1.833818,
      0,
      1,
      1,
      0.626851,
      NULL,
      NULL,
      1.110867,
      NULL,
      NULL,
      0.144000,
      NULL,
      NULL,
      0.910228,
      NULL,
      NULL,
      0.627615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      360.470727,
      2,
      0,
      0,
      1,
      1.061167,
      1.403764,
      NULL,
      1.462693,
      1.631809,
      1.116174,
      0.126760,
      1,
      1.210989,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.695588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.557157,
      3,
      1.120479,
      0.174931,
      NULL,
      2,
      7.317091,
      1,
      2.413949,
      1,
      1,
      1,
      NULL,
      NULL,
      3.451502,
      NULL,
      3,
      2.092050,
      NULL,
      NULL,
      0.802095,
      NULL,
      0,
      0,
      NULL,
      1.411374,
      0.507384,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1.380319,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.314449,
      NULL,
      0.885076,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      7.687432,
      68,
      5,
      2,
      0.202785,
      '33124',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


