set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '4002132',
      0,
      0,
      5,
      2,
      '3003',
      0.517925,
      NULL,
      NULL,
      NULL,
      ' 6-15-1978',
      46,
      NULL,
      0.041464,
      3.717169,
      0,
      ' 3-23-1979',
      24,
      2,
      64,
      118.395346,
      0.625016,
      ' 2-12-1996',
      NULL,
      NULL,
      NULL,
      3,
      3.654551,
      2.819847,
      1,
      0.776620,
      1.490355,
      2,
      NULL,
      NULL,
      NULL,
      2,
      2.965701,
      11,
      NULL,
      NULL,
      9,
      5,
      0.860067,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      2,
      0.543306,
      8.990447,
      1,
      NULL,
      1.922134,
      2,
      0.346092,
      0.908512,
      0.699282,
      4,
      0,
      NULL,
      1,
      9,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.826918,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3.380463,
      0.390288,
      3.635651,
      NULL,
      0.647933,
      NULL,
      NULL,
      0.782094,
      NULL,
      NULL,
      1.071144,
      0.712626,
      5,
      1.945042,
      0,
      2,
      0,
      1.577544,
      1.630412,
      2.049783,
      0,
      0,
      1,
      2,
      NULL,
      1,
      0.830203,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.218393,
      1,
      1.569167,
      0.511078,
      1,
      0.527216,
      1,
      0.113148,
      0,
      2,
      0.554443,
      1.575554,
      7,
      5.438445,
      7,
      NULL,
      1,
      9,
      4.343519,
      6,
      0,
      NULL,
      1,
      NULL,
      '10-14-1980',
      7,
      ' 1- 0-1990',
      1,
      NULL,
      1,
      1,
      0,
      0.811197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.869585,
      1.435292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092818,
      NULL,
      0.552290,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687491,
      NULL,
      5,
      1.163864,
      2.510610,
      0.500730,
      2,
      1.230997,
      NULL,
      NULL,
      1.344240,
      3.671989,
      1.580431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205845,
      NULL,
      1.398215,
      0,
      1,
      NULL,
      1,
      2,
      16,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312577,
      1,
      0,
      0,
      2,
      0.698961,
      3.809396,
      3.374940,
      1,
      0.892651,
      0.655371,
      3.356650,
      0,
      2,
      1.674024,
      1.388088,
      3.839762,
      0,
      0.966956,
      1.782780,
      1.583973,
      NULL,
      0.477315,
      1,
      1.821436,
      0.171947,
      1.694153,
      0.211590,
      1.328436,
      1,
      1,
      11,
      9.679118,
      4.859005,
      1,
      11.567103,
      3.305888,
      2,
      1,
      NULL,
      NULL,
      3.797298,
      1,
      30.717774,
      NULL,
      NULL,
      NULL,
      71,
      74,
      36.732374,
      2,
      1,
      2.866623,
      '22120',
      '',
      '',
      0.106941,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.883116,
      29.110490,
      69,
      11,
      1.009578,
      NULL,
      2,
      6,
      5.942179,
      3.458368,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483162,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.272394,
      NULL,
      NULL,
      NULL,
      3.482804,
      1.790227,
      1.460622,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.162221,
      NULL,
      NULL,
      0.078289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.539761,
      NULL,
      1,
      0.302409,
      NULL,
      NULL,
      NULL,
      0.178823,
      NULL,
      NULL,
      NULL,
      2.560822,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.969197,
      NULL,
      NULL,
      3,
      NULL,
      1.127020,
      NULL,
      1.400385,
      NULL,
      1,
      1.245422,
      2,
      2.200063,
      0,
      0.564567,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.143102,
      1,
      NULL,
      2,
      5,
      1.136976,
      1,
      0.035652,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.611370,
      NULL,
      NULL,
      0.691283,
      NULL,
      NULL,
      1.011696,
      0,
      1,
      0.659913,
      NULL,
      NULL,
      0.232699,
      3.043643,
      1.902542,
      2,
      1,
      NULL,
      0.241361,
      NULL,
      NULL,
      5.982335,
      5,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.129432,
      NULL,
      NULL,
      0.321177,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.269211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0.282590,
      NULL,
      NULL,
      NULL,
      3,
      1.466295,
      3.179674,
      0.495482,
      0,
      0,
      4,
      NULL,
      0,
      0.993376,
      1,
      2,
      1,
      2.815792,
      3.299538,
      NULL,
      0,
      NULL,
      NULL,
      3.561586,
      NULL,
      2,
      NULL,
      2,
      0.745847,
      NULL,
      NULL,
      0,
      1,
      1,
      0.905519,
      0.236966,
      0,
      0.595419,
      NULL,
      1.100286,
      NULL,
      NULL,
      0.528537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.798624,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.438762,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.329059,
      1.921057,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      4.572721,
      3.583820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.316766,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168828,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.878104,
      NULL,
      NULL,
      1,
      1.289699,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.085049,
      NULL,
      NULL,
      0,
      5.387406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.615364,
      7.332778,
      0,
      0.446198,
      NULL,
      NULL,
      1.077549,
      NULL,
      NULL,
      0.761323,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432659,
      NULL,
      0.712610,
      902.204935,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.291331,
      1,
      1.123421,
      0.373506,
      NULL,
      0.827799,
      0,
      NULL,
      0.202396,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160424,
      0.215862,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599016,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352393,
      0.108460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003484,
      0.923970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.707178,
      1.994931,
      1.006565,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307917,
      NULL,
      0.276490,
      NULL,
      0.887164,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.978803,
      3,
      1.879776,
      0,
      1,
      3,
      3.443676,
      5,
      2,
      0,
      NULL,
      0,
      0.482028,
      0.971084,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      1.640344,
      1,
      NULL,
      0,
      3,
      0.514132,
      1,
      0.845324,
      0.974628,
      NULL,
      1.396024,
      0,
      NULL,
      1.238002,
      1,
      1.545697,
      1,
      1.493622,
      3,
      NULL,
      NULL,
      1.176395,
      0.682289,
      0.591091,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.566540,
      1.430400,
      0,
      1,
      0,
      4.987697,
      2.700112,
      0.576940,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '21123',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.019795,
      '',
      '',
      '');
commit;
end;
/


