set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.662922,
      1,
      1.985593,
      3,
      1,
      2,
      6,
      0.422244,
      '112',
      '44242011',
      49,
      43,
      '2223214',
      0.993781,
      NULL,
      4,
      1,
      '0222',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1983',
      NULL,
      46.790045,
      NULL,
      1.562245,
      3.175735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-23-1978',
      NULL,
      2.398227,
      NULL,
      NULL,
      0.709214,
      0,
      0.859011,
      1.138502,
      1,
      1,
      14,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      NULL,
      2.260562,
      0,
      1,
      2.594755,
      0,
      1,
      2.679564,
      1.551534,
      1.295195,
      0.468745,
      1.914680,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579107,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.877552,
      1,
      1.694285,
      NULL,
      0,
      NULL,
      1.437478,
      0,
      0,
      1.093333,
      0,
      0.693695,
      0,
      0,
      0,
      0.968936,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.340444,
      0,
      5,
      1,
      6,
      8,
      7,
      9,
      NULL,
      7,
      0.742677,
      9.951447,
      1,
      NULL,
      0,
      2,
      1.546545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.021079,
      2,
      0,
      1.570249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043252,
      1,
      1,
      1.135199,
      0,
      1,
      1.128584,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148170,
      1.431223,
      1.040985,
      1,
      1.693385,
      1.052939,
      3,
      88,
      2,
      1.160128,
      NULL,
      NULL,
      NULL,
      1.711119,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2.599678,
      2.436951,
      2.593518,
      2.305348,
      NULL,
      3,
      NULL,
      1.799289,
      0,
      3.240393,
      0,
      3.581844,
      1.344973,
      1.412590,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      3.721871,
      NULL,
      0.948069,
      7,
      1.181626,
      3.145012,
      7,
      NULL,
      7.520828,
      1.769036,
      0.082143,
      7.591218,
      3,
      3,
      0.777971,
      61.309682,
      3.938247,
      2,
      47,
      NULL,
      77.192103,
      29.533993,
      NULL,
      0.262044,
      1.875072,
      '23143',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.860371,
      20.916185,
      NULL,
      7.460257,
      1,
      32.019370,
      8,
      15,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      1.391727,
      NULL,
      NULL,
      1.538678,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382877,
      3,
      0,
      0.592666,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.701655,
      7,
      NULL,
      0,
      0.131902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257184,
      3.934815,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.771001,
      1,
      1.049818,
      1,
      0,
      0.446215,
      1,
      0.385502,
      NULL,
      0.478868,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      1,
      2,
      0.487242,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211459,
      NULL,
      NULL,
      0.960743,
      NULL,
      NULL,
      2,
      0,
      0.294472,
      NULL,
      NULL,
      NULL,
      9.202646,
      1,
      0.802972,
      3,
      NULL,
      1.563611,
      NULL,
      NULL,
      NULL,
      2.041181,
      1,
      1.622205,
      NULL,
      NULL,
      NULL,
      0.394260,
      NULL,
      NULL,
      1.261748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.366361,
      NULL,
      NULL,
      3.130112,
      0.577181,
      1,
      4.638094,
      0,
      1.259857,
      NULL,
      0,
      0.346571,
      4,
      1.515415,
      2.431135,
      1,
      0,
      3.724359,
      0,
      NULL,
      NULL,
      NULL,
      1.743495,
      1,
      8.133089,
      7,
      NULL,
      0.359704,
      2.591848,
      0,
      2,
      NULL,
      3.768266,
      0.879774,
      3,
      2,
      0,
      NULL,
      2.808057,
      0,
      0,
      2.143953,
      2,
      NULL,
      NULL,
      1.349114,
      7,
      4,
      1.258028,
      1,
      0.637565,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467090,
      NULL,
      NULL,
      1.054490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.936503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.161588,
      NULL,
      NULL,
      1.284213,
      0.107196,
      0.502453,
      1.822909,
      1,
      3.723929,
      3,
      NULL,
      NULL,
      7,
      5.656085,
      NULL,
      NULL,
      36,
      24.596081,
      NULL,
      NULL,
      1,
      3.023381,
      NULL,
      NULL,
      1.141961,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.623370,
      NULL,
      NULL,
      NULL,
      1,
      1.086820,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.481513,
      0.005163,
      NULL,
      NULL,
      6,
      0.145583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      8,
      3,
      1.886372,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.733726,
      NULL,
      NULL,
      1,
      NULL,
      1.158504,
      289,
      NULL,
      1,
      1,
      0,
      1.486777,
      1.605746,
      1,
      NULL,
      1,
      0.335628,
      1,
      1,
      0,
      0.840252,
      0.640068,
      0.854161,
      0.698699,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.697032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.114498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970933,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.349492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665141,
      0,
      NULL,
      1.796127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.406150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.182603,
      3.320109,
      1,
      2.850998,
      4,
      4,
      13.118461,
      3.551523,
      NULL,
      3.279165,
      0.527294,
      1.376720,
      NULL,
      1,
      NULL,
      0,
      0.929516,
      1.004896,
      3.639623,
      1,
      0,
      3.824483,
      2,
      3.128689,
      NULL,
      0,
      NULL,
      1.086730,
      0,
      0.216909,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.473256,
      NULL,
      2.279307,
      0.529718,
      0.109482,
      1.252009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635862,
      1,
      0,
      1,
      0,
      NULL,
      7,
      NULL,
      7.063447,
      3,
      1,
      2.177949,
      45.064441,
      10.366582,
      2.515974,
      3.517334,
      NULL,
      '41024',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


