set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402223';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.631485,
      3,
      0,
      0.572723,
      0.271293,
      NULL,
      2,
      NULL,
      '440',
      '12242241',
      26,
      57,
      '2011012',
      NULL,
      NULL,
      3,
      3,
      '1033',
      3,
      0.398846,
      NULL,
      NULL,
      ' 5-26-1991',
      3,
      8.528662,
      NULL,
      3.732400,
      1.546047,
      ' 2- 5-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      1.192686,
      '11- 5-1998',
      NULL,
      ' 8-11-2001',
      1,
      3.497137,
      1.679742,
      1.692145,
      1,
      0.041985,
      NULL,
      0.461929,
      0.003527,
      NULL,
      9.953566,
      2.404467,
      1.219801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.326464,
      NULL,
      1,
      0,
      1,
      NULL,
      0.731387,
      1,
      0.150548,
      1,
      1,
      3.885051,
      NULL,
      3.301773,
      10,
      0.170302,
      NULL,
      6.998651,
      2,
      NULL,
      9,
      1,
      0,
      NULL,
      0,
      1.862344,
      10,
      1,
      0.740415,
      0,
      1,
      0.513399,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.454534,
      1,
      0.205999,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      1.550506,
      NULL,
      7.939291,
      0.462780,
      0,
      6,
      NULL,
      0,
      NULL,
      6.091676,
      NULL,
      0,
      1.680222,
      0,
      1.807988,
      NULL,
      0.091666,
      5,
      2.461577,
      0.104946,
      0.796807,
      0,
      4,
      2,
      1.628567,
      NULL,
      5.029850,
      3,
      1.211000,
      3,
      0.802855,
      3.445254,
      NULL,
      4.015048,
      7,
      3.152641,
      3,
      NULL,
      7,
      7,
      3.465824,
      0.739547,
      0,
      2.467348,
      ' 5-23-1983',
      782,
      ' 6- 4-1987',
      324,
      3,
      NULL,
      1.567620,
      NULL,
      0.784952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.066976,
      NULL,
      0.033634,
      0,
      2.556068,
      0.172879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489723,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168555,
      0.284007,
      3.972514,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      7.562800,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190912,
      0,
      1.657009,
      1,
      1.797039,
      1.223027,
      0,
      1,
      7.657271,
      1.412585,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.679519,
      0,
      1,
      NULL,
      0,
      NULL,
      6,
      NULL,
      1.164803,
      NULL,
      0.494390,
      3.510793,
      1.474041,
      1,
      0,
      NULL,
      1.954583,
      0.336786,
      0,
      NULL,
      1.268939,
      1.770635,
      1,
      NULL,
      0.475809,
      0,
      NULL,
      0.064420,
      NULL,
      0,
      1,
      6.930201,
      9,
      3,
      NULL,
      5,
      3,
      1,
      1.163055,
      NULL,
      NULL,
      0,
      3.249383,
      66,
      0,
      1,
      22.420525,
      NULL,
      NULL,
      50,
      2,
      3.595415,
      5.421244,
      '20434',
      '13324',
      '',
      0.437124,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      15,
      188,
      30,
      NULL,
      NULL,
      2.401508,
      1.056906,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.539376,
      NULL,
      0,
      0.530427,
      1,
      1.230616,
      NULL,
      NULL,
      3,
      1.491004,
      3.191353,
      1.056828,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.989144,
      NULL,
      NULL,
      0.197703,
      NULL,
      NULL,
      0.129912,
      NULL,
      NULL,
      5,
      NULL,
      1.235915,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.959623,
      NULL,
      NULL,
      NULL,
      1.734328,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659447,
      NULL,
      NULL,
      1.160815,
      NULL,
      NULL,
      1.176142,
      NULL,
      NULL,
      1.399883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      0.403553,
      1.393124,
      0,
      0,
      0.357613,
      NULL,
      NULL,
      3.802609,
      3,
      5,
      NULL,
      1,
      1.814150,
      2.986900,
      1,
      1,
      0,
      0.533778,
      NULL,
      0,
      NULL,
      NULL,
      0.837966,
      NULL,
      NULL,
      0.793185,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.923763,
      0,
      1.733026,
      2,
      NULL,
      NULL,
      4,
      0,
      0,
      1,
      1.718187,
      3,
      0.384401,
      NULL,
      NULL,
      0.770702,
      3.634356,
      NULL,
      0,
      2,
      1,
      NULL,
      2,
      0.210009,
      3.772133,
      NULL,
      7.880002,
      2.733807,
      1,
      3,
      3.469721,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.348305,
      NULL,
      2.361329,
      2.283362,
      0.948046,
      5.644878,
      2.409207,
      NULL,
      5,
      1.504043,
      2,
      2,
      1.891897,
      0,
      NULL,
      0,
      1.876129,
      3.737063,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.404550,
      NULL,
      NULL,
      3.999415,
      NULL,
      NULL,
      1.925344,
      NULL,
      NULL,
      0.659803,
      NULL,
      NULL,
      1.978417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760713,
      1,
      0.226857,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.135332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.364144,
      NULL,
      NULL,
      NULL,
      1.766844,
      NULL,
      NULL,
      NULL,
      1.770663,
      NULL,
      0,
      0.208345,
      NULL,
      NULL,
      1.507459,
      NULL,
      NULL,
      1.451123,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971357,
      NULL,
      1,
      63,
      23,
      NULL,
      1.051695,
      1.137843,
      2.224729,
      0,
      0,
      0.285654,
      NULL,
      0,
      1.112110,
      NULL,
      1,
      NULL,
      0.681351,
      NULL,
      0,
      1,
      2,
      NULL,
      2.128339,
      NULL,
      0,
      NULL,
      1.505729,
      NULL,
      3,
      NULL,
      2.080186,
      NULL,
      136,
      NULL,
      1.685743,
      10,
      NULL,
      1.640703,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.016591,
      NULL,
      1.271104,
      NULL,
      0.130851,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.966401,
      NULL,
      1.099701,
      NULL,
      0.939303,
      1.066571,
      0.875350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522287,
      1.564655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673877,
      0.765489,
      NULL,
      1.695221,
      NULL,
      1.623629,
      NULL,
      NULL,
      NULL,
      0.802565,
      NULL,
      1.832225,
      NULL,
      0,
      0,
      1.891537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003975,
      1,
      0.390271,
      1,
      0.446274,
      1.226238,
      1.234712,
      1.993827,
      NULL,
      3.442554,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.556255,
      0,
      NULL,
      0.987252,
      0,
      NULL,
      1.305770,
      1.541742,
      NULL,
      1.663652,
      0.472839,
      NULL,
      0,
      1,
      NULL,
      1.439623,
      0.992708,
      NULL,
      1.632141,
      2,
      NULL,
      1,
      1.194248,
      NULL,
      0,
      0.252662,
      0.593813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.852631,
      NULL,
      3.979735,
      6.115795,
      2.396595,
      1,
      0,
      2,
      8,
      69.677430,
      NULL,
      2,
      0,
      NULL,
      '11141',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


