set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906086';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '4432223',
      0,
      NULL,
      4,
      2,
      '1031',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-23-1996',
      37,
      1,
      17.296313,
      25.821342,
      0.151786,
      ' 5-24-1977',
      ' 1-24-1996',
      ' 9- 7-1997',
      3.149504,
      3,
      3,
      0.044232,
      0,
      0,
      1.118952,
      1,
      0.098734,
      12.418899,
      6.664549,
      19,
      NULL,
      6.750318,
      17.151884,
      NULL,
      6,
      NULL,
      1.827051,
      0.663437,
      0.589581,
      5,
      NULL,
      0,
      1,
      0.899017,
      0,
      1.556169,
      1.690210,
      0,
      0,
      2,
      NULL,
      5.185366,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1.558754,
      1.904330,
      3.924304,
      4.209901,
      2,
      4.859006,
      3,
      NULL,
      0,
      2,
      2.322841,
      0,
      0.825532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562563,
      NULL,
      0,
      0.584245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.018321,
      0.428898,
      0.830487,
      5.347147,
      0.124411,
      1.412394,
      3.916443,
      0.391833,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.844566,
      2.947174,
      NULL,
      2,
      1,
      1.980760,
      0.836787,
      0,
      NULL,
      0.588408,
      0,
      2,
      1,
      4.199899,
      0.363627,
      NULL,
      1,
      1,
      1.911307,
      NULL,
      NULL,
      0.211712,
      NULL,
      0,
      7.968924,
      0,
      5,
      8,
      0,
      2,
      4.880539,
      5,
      3.377249,
      1.429914,
      0,
      4.317670,
      6.345803,
      2.712261,
      1,
      0.493776,
      3,
      4,
      6.663708,
      5.747560,
      3,
      4,
      5.645441,
      0,
      ' 8-11-1982',
      163,
      NULL,
      NULL,
      NULL,
      2.124985,
      0,
      0.820093,
      0.846971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911948,
      1,
      1,
      0,
      NULL,
      0.730828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      30,
      2,
      0.607588,
      1.014617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.437663,
      NULL,
      NULL,
      NULL,
      2.078817,
      0.630921,
      1,
      NULL,
      0,
      3.259130,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.420544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178196,
      0.554667,
      0.542802,
      1.306741,
      0,
      1.995493,
      1.338740,
      2,
      NULL,
      NULL,
      3.844406,
      26.707338,
      22.328358,
      21,
      4.501804,
      NULL,
      0.140301,
      4,
      3,
      1,
      3,
      NULL,
      1,
      2.077103,
      2.244304,
      4,
      3,
      NULL,
      1.366676,
      3,
      0.099128,
      3,
      2,
      4.549559,
      0.675421,
      0,
      1.294837,
      1,
      1,
      1.018943,
      0,
      1,
      1,
      NULL,
      0.263347,
      NULL,
      0,
      8,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1.211726,
      NULL,
      2,
      0,
      0.478617,
      51,
      NULL,
      3.588518,
      NULL,
      NULL,
      17,
      80.265346,
      2.980687,
      1,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      2.821521,
      '41420',
      '',
      '',
      NULL,
      29,
      74,
      28.405536,
      2,
      28.025470,
      3.161721,
      0.388233,
      0,
      1,
      NULL,
      NULL,
      0.792552,
      NULL,
      NULL,
      0.959828,
      NULL,
      NULL,
      1,
      3.783937,
      NULL,
      NULL,
      NULL,
      NULL,
      3.857777,
      2.212753,
      3.315421,
      0,
      3,
      3.784794,
      2,
      NULL,
      0,
      NULL,
      1.504825,
      1,
      NULL,
      NULL,
      1,
      3.228577,
      3,
      2,
      1,
      NULL,
      NULL,
      4.297017,
      NULL,
      5.065205,
      NULL,
      1.809370,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.115540,
      NULL,
      NULL,
      1.523163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.890035,
      1.567187,
      1,
      0.058871,
      1,
      1,
      2,
      0,
      6,
      7.554842,
      NULL,
      1,
      1.320494,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.950152,
      2,
      NULL,
      2,
      1.075110,
      0,
      2,
      3,
      0,
      1.092749,
      NULL,
      3,
      NULL,
      2.993451,
      1.989431,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227017,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.546464,
      NULL,
      0.248370,
      3,
      2,
      3.347000,
      NULL,
      1,
      0,
      0.459745,
      NULL,
      4,
      0.997655,
      9.826838,
      5,
      NULL,
      4,
      1,
      NULL,
      NULL,
      3,
      3.189620,
      2,
      3,
      2,
      3.561582,
      NULL,
      1,
      2,
      5.930967,
      NULL,
      NULL,
      2,
      0.959421,
      0.783300,
      0,
      3,
      1.605679,
      1.347807,
      3,
      0.979492,
      0,
      1.113363,
      NULL,
      NULL,
      NULL,
      3,
      1.809887,
      7.692839,
      NULL,
      3,
      0,
      4.696203,
      0.498091,
      0,
      0,
      NULL,
      1.339705,
      NULL,
      NULL,
      NULL,
      0.886710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.261086,
      NULL,
      NULL,
      2.665722,
      NULL,
      NULL,
      0.706687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1.810274,
      0,
      0,
      0,
      0.093375,
      3.059168,
      NULL,
      NULL,
      NULL,
      0.193328,
      4.520795,
      NULL,
      NULL,
      20,
      10,
      NULL,
      NULL,
      NULL,
      1.395257,
      NULL,
      NULL,
      0.777042,
      1.573566,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.188710,
      NULL,
      NULL,
      0.695792,
      1.062729,
      NULL,
      NULL,
      0.016675,
      1,
      NULL,
      NULL,
      1.195319,
      1.744681,
      NULL,
      NULL,
      3.087370,
      2,
      NULL,
      NULL,
      NULL,
      0.788615,
      NULL,
      NULL,
      1.862280,
      1,
      NULL,
      NULL,
      NULL,
      3.561747,
      NULL,
      NULL,
      2.671678,
      NULL,
      NULL,
      NULL,
      1,
      1.140183,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      9,
      2.825703,
      NULL,
      NULL,
      1.377241,
      NULL,
      NULL,
      NULL,
      0.430275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      183,
      3,
      1.601470,
      1.508503,
      0,
      0,
      1.091849,
      1,
      0.114177,
      1.891929,
      NULL,
      0.517295,
      NULL,
      1,
      0.125202,
      1,
      1,
      NULL,
      1.308181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651495,
      1.552513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.091644,
      0.213505,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745092,
      0.914383,
      1.947384,
      1.661466,
      NULL,
      6,
      NULL,
      1.958790,
      15.531649,
      3,
      NULL,
      1,
      NULL,
      0.844287,
      0,
      1,
      1.492690,
      1,
      0,
      1,
      2,
      NULL,
      0,
      0.699738,
      2,
      3.295654,
      0,
      0,
      3.245843,
      NULL,
      1.448822,
      2,
      1,
      1.651609,
      NULL,
      NULL,
      0.501900,
      1.662816,
      1.657312,
      0,
      0,
      2.838381,
      1.150477,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587905,
      2.924798,
      3,
      2.522623,
      0.034142,
      3,
      NULL,
      NULL,
      2.249575,
      NULL,
      0,
      1,
      2,
      NULL,
      3,
      3.824577,
      NULL,
      0.047127,
      NULL,
      2.871143,
      0,
      1,
      2,
      2,
      NULL,
      0,
      5,
      0.714259,
      NULL,
      NULL,
      NULL,
      3,
      1.967499,
      1,
      1.407517,
      NULL,
      2.621305,
      4,
      0.604586,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      0,
      1.857073,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      '40440',
      '',
      '');
commit;
end;
/


