set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9690575';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '01',
      10.019329,
      28.722206,
      '1014412',
      0,
      NULL,
      0,
      NULL,
      '4111',
      4.086721,
      0,
      NULL,
      NULL,
      NULL,
      64.007181,
      0.885786,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 2- 0-1983',
      ' 3-16-2003',
      ' 5- 3-1984',
      NULL,
      2.937055,
      NULL,
      NULL,
      0,
      3.032617,
      5,
      1,
      1.194722,
      330.494799,
      1,
      6.269508,
      7.708335,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886690,
      1,
      NULL,
      0.658030,
      NULL,
      1.503349,
      0.531451,
      1,
      1.877454,
      0.732701,
      NULL,
      1,
      0.794809,
      0.182623,
      NULL,
      NULL,
      4.210826,
      0.276290,
      2,
      1,
      NULL,
      9.412364,
      NULL,
      0,
      1.654118,
      1,
      3,
      1.903010,
      NULL,
      1.965497,
      2,
      0.551416,
      1.861228,
      3,
      0,
      1.730963,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.582944,
      2,
      1.425620,
      2.815638,
      NULL,
      0,
      0.729983,
      0.483651,
      3.613661,
      2.874940,
      0,
      0,
      0.700353,
      0,
      1.057654,
      0.231602,
      1,
      NULL,
      0,
      NULL,
      0.641165,
      0,
      4,
      NULL,
      2.128316,
      5,
      0,
      NULL,
      NULL,
      1.979238,
      NULL,
      NULL,
      1,
      1.543987,
      1,
      1.277326,
      7.632454,
      6.749451,
      9,
      1,
      NULL,
      2,
      4,
      NULL,
      2.264217,
      6,
      NULL,
      1,
      1.799450,
      1,
      1.601210,
      NULL,
      0.936305,
      1,
      2,
      1.226340,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.977005,
      0,
      1.894912,
      3,
      NULL,
      5.428755,
      4,
      2.457226,
      NULL,
      NULL,
      9.724645,
      0,
      NULL,
      1,
      3,
      ' 8-20-1974',
      1629,
      ' 5-28-1977',
      585,
      0,
      NULL,
      1.687767,
      0.159727,
      2,
      NULL,
      16,
      1,
      NULL,
      1,
      1,
      0.811046,
      1,
      1.616938,
      1,
      0.874977,
      1,
      1,
      1.600049,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986483,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.759872,
      1.427640,
      0.976996,
      1.132061,
      NULL,
      NULL,
      NULL,
      0,
      1.251117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.646986,
      0,
      NULL,
      1.657523,
      0,
      1,
      0,
      92,
      3,
      0.410371,
      NULL,
      NULL,
      NULL,
      0,
      0.754854,
      2,
      0,
      3.013077,
      2.441867,
      2.177430,
      0,
      2,
      0.614480,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0,
      2.537030,
      NULL,
      0.176682,
      0.094698,
      NULL,
      1.001322,
      1,
      1.582159,
      0,
      1,
      0,
      0.917703,
      0.038815,
      0,
      1,
      11,
      9,
      2,
      NULL,
      NULL,
      3,
      5,
      NULL,
      4.516727,
      3,
      3,
      3.730706,
      59,
      0,
      1,
      NULL,
      NULL,
      4.961080,
      NULL,
      3.889494,
      4,
      1,
      '30010',
      '',
      '',
      1,
      '',
      '',
      '',
      0.462971,
      '',
      '',
      '',
      2,
      39.012102,
      NULL,
      NULL,
      3,
      10.915134,
      1,
      39.471046,
      3,
      NULL,
      NULL,
      2.224372,
      0,
      NULL,
      NULL,
      1.435011,
      NULL,
      NULL,
      2.591801,
      2.279843,
      2,
      0.535820,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.453657,
      0,
      NULL,
      1.148781,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.712815,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.176815,
      3,
      7.955228,
      1.114494,
      1,
      NULL,
      NULL,
      NULL,
      0.067919,
      NULL,
      NULL,
      NULL,
      0.207033,
      2.291631,
      1.379271,
      3.606549,
      0,
      0.724022,
      0,
      NULL,
      NULL,
      2.017095,
      0.006511,
      1.808646,
      0.642949,
      NULL,
      0.960748,
      2,
      NULL,
      NULL,
      0.457395,
      1.785070,
      0,
      1,
      3.154725,
      0.869141,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.822682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773576,
      0.580729,
      0.723829,
      2.024405,
      0,
      1.844194,
      1,
      NULL,
      NULL,
      9.821711,
      3.784747,
      5.769703,
      3.778157,
      2,
      NULL,
      2.056125,
      3,
      0.353175,
      0,
      3,
      0,
      0.580414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045351,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.210699,
      NULL,
      NULL,
      0.125194,
      NULL,
      NULL,
      0.560383,
      NULL,
      NULL,
      2,
      1,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.332376,
      2,
      2,
      NULL,
      NULL,
      NULL,
      6,
      5.758893,
      1.182920,
      NULL,
      3,
      0.389963,
      NULL,
      1,
      3.432208,
      NULL,
      NULL,
      2.215428,
      2,
      3,
      2.630944,
      9.944770,
      2,
      2,
      NULL,
      0.044209,
      2,
      0,
      0.202026,
      3.026784,
      NULL,
      NULL,
      1.605346,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.022921,
      NULL,
      NULL,
      1.728361,
      NULL,
      NULL,
      1.775698,
      NULL,
      NULL,
      2.390523,
      NULL,
      NULL,
      1.813331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.066157,
      0,
      1.771387,
      NULL,
      1.348250,
      2.732163,
      NULL,
      NULL,
      NULL,
      1.780000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.173776,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.055213,
      35.206488,
      25,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337336,
      NULL,
      NULL,
      2.709478,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250071,
      798.032099,
      53.384134,
      0.470671,
      NULL,
      0,
      0,
      NULL,
      1.122758,
      NULL,
      0,
      0,
      1,
      0.789506,
      NULL,
      1.451150,
      1.074664,
      NULL,
      0,
      0,
      0.062185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544152,
      1,
      3,
      2.239965,
      0.457193,
      0,
      1,
      1,
      5.660389,
      3.271395,
      2.961312,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.840405,
      NULL,
      0,
      0.258876,
      NULL,
      0.358075,
      1,
      NULL,
      0.693861,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.370258,
      NULL,
      1,
      NULL,
      NULL,
      1.242695,
      2.380138,
      NULL,
      0.125917,
      0.082751,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.148386,
      NULL,
      NULL,
      NULL,
      7.851020,
      3.300427,
      3,
      3.002040,
      NULL,
      2,
      36.302718,
      1,
      5,
      NULL,
      2.906740,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


