set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7038100';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3002130',
      NULL,
      1,
      0,
      NULL,
      '1243',
      NULL,
      2,
      NULL,
      51.500502,
      ' 7-22-1998',
      NULL,
      NULL,
      2.442462,
      3.015034,
      1.429749,
      NULL,
      NULL,
      3.926629,
      NULL,
      NULL,
      3.443596,
      NULL,
      NULL,
      '11- 9-2001',
      2,
      1,
      1.116971,
      0,
      NULL,
      0,
      1.725279,
      0.597674,
      0.908711,
      387.732091,
      NULL,
      7,
      NULL,
      21.141372,
      30.182754,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.528372,
      0.310821,
      NULL,
      1.322632,
      0,
      0.171815,
      0.266931,
      1,
      0,
      NULL,
      NULL,
      14,
      4,
      NULL,
      NULL,
      1.067954,
      0.794794,
      1.500639,
      0.526249,
      NULL,
      0,
      NULL,
      1.402433,
      NULL,
      1,
      0,
      1,
      NULL,
      0.371246,
      2.705298,
      0.046336,
      0,
      1.993461,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.292189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3.527340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598402,
      1.814223,
      1,
      1,
      NULL,
      1.912530,
      3.438903,
      NULL,
      0,
      0.673047,
      0,
      NULL,
      0.055413,
      0,
      NULL,
      0.018497,
      1,
      NULL,
      1.176699,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.760286,
      NULL,
      3,
      NULL,
      1,
      2,
      1,
      1,
      1.506738,
      5.253289,
      1.784168,
      0.771372,
      1,
      0.855601,
      4.700669,
      3,
      3.258553,
      0.479088,
      9,
      9,
      0.846140,
      7,
      3,
      NULL,
      ' 1-26-1980',
      1099,
      ' 7-18-1998',
      NULL,
      2.723560,
      2.454764,
      0,
      0.011062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.520827,
      NULL,
      1.612126,
      0.080542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.937246,
      NULL,
      1.578821,
      1.681740,
      NULL,
      0.107635,
      NULL,
      1,
      0.194819,
      NULL,
      NULL,
      NULL,
      1.804200,
      0.420975,
      2.125445,
      2,
      3.751659,
      2,
      2,
      2,
      1,
      2,
      1.085337,
      2,
      NULL,
      NULL,
      3,
      3,
      8,
      1.259636,
      NULL,
      1,
      NULL,
      0.818328,
      1.796490,
      1.168318,
      0,
      1.102464,
      0,
      NULL,
      1,
      1.041167,
      NULL,
      NULL,
      10,
      11,
      1.861361,
      NULL,
      6,
      1,
      3,
      NULL,
      5.853961,
      3.779169,
      NULL,
      3,
      58,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735232,
      0.079755,
      1,
      '10422',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1.019320,
      '',
      '',
      '',
      0,
      13.441292,
      385,
      39,
      1,
      36,
      14.120665,
      244.749920,
      2.654674,
      0,
      NULL,
      10.688880,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      1.467083,
      11,
      NULL,
      NULL,
      3,
      3.803726,
      16.161778,
      0,
      NULL,
      16.200227,
      0.923573,
      NULL,
      NULL,
      1.220042,
      NULL,
      NULL,
      0.028469,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.344402,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.567813,
      1.379885,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      5.236029,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.808582,
      0.664918,
      1.025136,
      NULL,
      1,
      0.771024,
      1,
      0,
      NULL,
      1.083364,
      1,
      1,
      1.675356,
      0.937156,
      NULL,
      1,
      12.104216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.254852,
      NULL,
      0,
      3.517119,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.067493,
      NULL,
      NULL,
      0.909239,
      NULL,
      NULL,
      1.782791,
      1.618638,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.952942,
      0.135306,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.013738,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.004509,
      NULL,
      NULL,
      1.763462,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.515739,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.182687,
      3,
      1,
      NULL,
      1,
      2.080812,
      4,
      2.781194,
      7.222945,
      0,
      1.801206,
      NULL,
      3.684541,
      2,
      NULL,
      0,
      3.355521,
      0,
      2.093565,
      NULL,
      3.607357,
      0.473795,
      0,
      1.246646,
      0,
      NULL,
      NULL,
      2,
      1.814057,
      2,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.916661,
      NULL,
      NULL,
      7.460321,
      6,
      3.893518,
      0,
      NULL,
      1.318180,
      NULL,
      0,
      1.546606,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.356004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.617751,
      NULL,
      NULL,
      1.494105,
      NULL,
      NULL,
      0.783373,
      NULL,
      NULL,
      19.500764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219220,
      NULL,
      NULL,
      NULL,
      NULL,
      2.731352,
      NULL,
      5,
      6,
      0,
      1.400432,
      1.127138,
      50,
      9.886386,
      NULL,
      2.942729,
      NULL,
      0,
      NULL,
      1.957140,
      NULL,
      1.371178,
      NULL,
      0.462187,
      2,
      1,
      0,
      0.353445,
      1,
      0,
      NULL,
      2,
      NULL,
      3.599737,
      NULL,
      0.635698,
      1.695218,
      2,
      2,
      0.542740,
      14,
      2,
      0.214436,
      NULL,
      7,
      NULL,
      1,
      2,
      0.587418,
      3,
      0,
      1.956927,
      0,
      1.603078,
      NULL,
      1.070138,
      4.628672,
      NULL,
      1,
      3.406893,
      3,
      NULL,
      1.029224,
      1.901774,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2.716370,
      0.874785,
      0,
      3,
      0.028855,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.028401,
      1,
      NULL,
      0.785118,
      2.407685,
      3,
      10,
      NULL,
      5,
      1,
      3,
      NULL,
      NULL,
      2,
      1.862348,
      271,
      8,
      2,
      8.723406,
      7,
      0.209425,
      NULL,
      NULL,
      1,
      6,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      40.811476,
      NULL,
      570.223663,
      NULL,
      1.299541,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0.814620,
      0,
      0,
      0.406842,
      NULL,
      1,
      1,
      1,
      0.709219,
      1.205679,
      1.119186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.877142,
      4.186672,
      12.673589,
      1.823452,
      4,
      NULL,
      2.672492,
      18,
      0.840086,
      NULL,
      3.663446,
      NULL,
      NULL,
      0,
      0.193012,
      3.090368,
      1.508101,
      0,
      3.706419,
      NULL,
      NULL,
      0.361672,
      NULL,
      1.398873,
      3,
      NULL,
      3.865318,
      3.700571,
      0,
      NULL,
      3,
      2,
      1.735537,
      1,
      2,
      0.907321,
      1,
      0.222834,
      1.936267,
      0,
      3.284107,
      1,
      3.313611,
      0.610806,
      2,
      0.850132,
      1.550342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.094611,
      1.019418,
      0,
      1.058012,
      0.481639,
      1.565358,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0.997389,
      NULL,
      0,
      NULL,
      0.706782,
      0,
      0.802485,
      1.053551,
      1,
      1.465389,
      1.869669,
      8,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.396424,
      1.510975,
      0,
      1.101743,
      0,
      0,
      7,
      3,
      6,
      3,
      NULL,
      0.976453,
      56.683787,
      19.021711,
      7,
      1.020307,
      1.559602,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


