set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9627735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '13',
      8.122349,
      NULL,
      '1103231',
      NULL,
      0,
      4,
      NULL,
      '4203',
      5,
      1,
      NULL,
      NULL,
      '11-27-1992',
      113.693121,
      22,
      NULL,
      3,
      1.730774,
      ' 6-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 5- 1-1985',
      ' 9- 2-1983',
      ' 3-15-2003',
      NULL,
      1.334113,
      NULL,
      2.811313,
      1.667802,
      NULL,
      1.141051,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023430,
      2.368431,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      3,
      5.778779,
      1.866656,
      0,
      1.833907,
      0,
      3,
      7,
      1.664177,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.401912,
      NULL,
      NULL,
      2,
      0.152251,
      0,
      3.645595,
      NULL,
      0.474136,
      2.388939,
      1.102107,
      1.157433,
      2,
      2.587073,
      0.222994,
      1.630635,
      3,
      0,
      1.165343,
      NULL,
      1,
      1,
      3,
      0.164965,
      NULL,
      6,
      1,
      NULL,
      1.937103,
      1,
      NULL,
      NULL,
      1.647827,
      NULL,
      NULL,
      0,
      NULL,
      1.472581,
      1,
      0,
      1.190226,
      5.587512,
      NULL,
      0,
      0,
      0,
      1.459893,
      0,
      5,
      1,
      NULL,
      1,
      1.450075,
      0,
      NULL,
      0,
      5.815752,
      NULL,
      0.800959,
      0.361446,
      1,
      0.088537,
      3.592145,
      1,
      3.961617,
      0.961086,
      0.195981,
      0,
      4.643164,
      1.132699,
      2.675302,
      5.532388,
      6.392829,
      0.642885,
      1.264339,
      5,
      NULL,
      6.213601,
      6.690582,
      NULL,
      NULL,
      1.195186,
      3.929988,
      ' 2-16-1990',
      NULL,
      ' 8-11-1992',
      0,
      3.293395,
      1.131014,
      NULL,
      5.680740,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036166,
      1.934861,
      1.946242,
      1.438072,
      0,
      NULL,
      0,
      1.267900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.578910,
      NULL,
      9,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280941,
      7,
      1.011533,
      0.063433,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.045682,
      3.563065,
      0.970521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.677045,
      3,
      1.137597,
      0,
      0.666798,
      0.034075,
      10,
      1,
      1.591923,
      NULL,
      NULL,
      NULL,
      2.110515,
      0,
      0,
      2.090329,
      0.092834,
      0,
      NULL,
      0,
      1.118726,
      0,
      3,
      2.237490,
      NULL,
      0,
      NULL,
      2.335184,
      1.054325,
      NULL,
      0,
      0.094812,
      0.618115,
      0,
      0.450554,
      0,
      1.717409,
      0.637278,
      NULL,
      1.224897,
      0,
      1.283641,
      2.024681,
      0.849398,
      7.062279,
      0,
      1,
      3.763389,
      6.040662,
      3.332715,
      2,
      0.112467,
      NULL,
      NULL,
      1.709869,
      3.570447,
      3,
      1.163350,
      0,
      NULL,
      NULL,
      39.917810,
      11,
      2,
      5.919954,
      1,
      '20443',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      3,
      49,
      NULL,
      32,
      NULL,
      22.649061,
      5.879788,
      3,
      NULL,
      NULL,
      NULL,
      0.610887,
      1.898198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.705667,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.826073,
      NULL,
      NULL,
      1.458189,
      NULL,
      NULL,
      0.938839,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0,
      0.343792,
      NULL,
      NULL,
      NULL,
      1.448615,
      NULL,
      NULL,
      NULL,
      1.089386,
      NULL,
      2.573962,
      1.851993,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.183152,
      1,
      2,
      1,
      1,
      NULL,
      2,
      1,
      1.197744,
      0.832850,
      2.340927,
      0.732756,
      NULL,
      NULL,
      3.367422,
      1,
      2,
      NULL,
      0.717824,
      NULL,
      NULL,
      1.082739,
      3.007872,
      NULL,
      7,
      9,
      5.378075,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.918384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.134704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.623309,
      1,
      NULL,
      NULL,
      NULL,
      1.452124,
      NULL,
      5.960015,
      1.091472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819410,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.257538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.786811,
      2,
      0,
      NULL,
      NULL,
      1,
      0.205876,
      2.337700,
      6.891736,
      7,
      5,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.503803,
      0,
      2,
      0,
      1,
      NULL,
      2,
      6,
      NULL,
      6.195673,
      3.841092,
      0.893263,
      NULL,
      NULL,
      1,
      2.237036,
      1,
      1.504459,
      NULL,
      2,
      NULL,
      3,
      3,
      1,
      7,
      1.229355,
      2,
      2.026065,
      0,
      NULL,
      NULL,
      1.905658,
      1.343832,
      0.589875,
      1.727152,
      0.480169,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053745,
      NULL,
      NULL,
      1.315230,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.756120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.035644,
      1.588219,
      1.018467,
      0,
      1.203260,
      NULL,
      NULL,
      5.394309,
      NULL,
      NULL,
      NULL,
      79,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.505557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039455,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515322,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.179971,
      NULL,
      NULL,
      NULL,
      1.115649,
      NULL,
      NULL,
      NULL,
      3.099483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.473173,
      NULL,
      77281.361890,
      1,
      19.010297,
      1069,
      1,
      NULL,
      NULL,
      2,
      4,
      3401.773164,
      0.009481,
      NULL,
      NULL,
      0.391189,
      NULL,
      NULL,
      0.324962,
      NULL,
      0.391795,
      493.218880,
      NULL,
      1.722438,
      1.474613,
      0.769813,
      0.846641,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.431795,
      0,
      NULL,
      1.159577,
      0.114772,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820296,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372721,
      0.750312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342900,
      NULL,
      0,
      NULL,
      1.554140,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.630130,
      0.938755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.265232,
      3,
      NULL,
      3.527744,
      0.720292,
      3,
      0,
      7,
      0,
      2,
      3,
      1,
      0.911229,
      1.500382,
      NULL,
      1,
      0,
      NULL,
      3.811593,
      NULL,
      NULL,
      NULL,
      1.468523,
      NULL,
      3.118286,
      3.188345,
      NULL,
      1,
      0,
      NULL,
      0.518563,
      2.498787,
      NULL,
      NULL,
      1,
      NULL,
      0.994033,
      1.878919,
      NULL,
      1.283743,
      1.309282,
      NULL,
      0,
      2.168904,
      NULL,
      0,
      NULL,
      1.767112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653005,
      NULL,
      2.503465,
      NULL,
      1.700334,
      NULL,
      1,
      NULL,
      2.397950,
      1.926553,
      NULL,
      NULL,
      3.070467,
      31.668665,
      2.646903,
      1.229859,
      2.502780,
      '02320',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


