set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7618530';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3312234',
      0.074036,
      NULL,
      1,
      2,
      NULL,
      2.411314,
      NULL,
      NULL,
      NULL,
      '11- 1-2002',
      NULL,
      NULL,
      4,
      NULL,
      0.732348,
      NULL,
      73.991134,
      NULL,
      176.233744,
      11,
      0,
      NULL,
      ' 8-21-1985',
      NULL,
      NULL,
      NULL,
      3.465678,
      2.955674,
      NULL,
      3,
      NULL,
      1.028235,
      1,
      2,
      9,
      12,
      1.576320,
      15,
      20.103064,
      6,
      NULL,
      6,
      3,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      5.903414,
      3,
      1.403853,
      0.007902,
      NULL,
      NULL,
      NULL,
      1.246455,
      0,
      1.627305,
      1.453394,
      0,
      1.128515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.663075,
      0.975571,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.399907,
      1.395728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.862609,
      0.447474,
      0.058923,
      0,
      1.007507,
      0,
      1,
      0,
      0.782249,
      2,
      1.310697,
      0.231718,
      0,
      NULL,
      0.039073,
      NULL,
      1,
      6,
      5.991147,
      NULL,
      3,
      1.910669,
      NULL,
      9.678155,
      5.193146,
      1,
      0,
      4,
      7,
      3.282128,
      6,
      NULL,
      4.634072,
      5,
      1,
      3,
      3,
      3.100214,
      10,
      0,
      0.663036,
      NULL,
      NULL,
      NULL,
      ' 8-20-1992',
      385.625541,
      ' 5-23-1992',
      21,
      0.338443,
      0,
      0.273750,
      8.741532,
      1.693254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604458,
      1.369823,
      0.720995,
      NULL,
      NULL,
      1.136513,
      1.085073,
      1.202049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.537957,
      1.196103,
      1,
      3,
      1,
      0.725259,
      1.975893,
      3,
      3,
      7,
      5.219647,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.578807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428416,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      26.265811,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.325684,
      3,
      5.269990,
      3.345731,
      3.416555,
      1.598778,
      2,
      0,
      1,
      0.493496,
      3.044211,
      2,
      NULL,
      1.724955,
      0,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131835,
      0,
      0.838228,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      51,
      NULL,
      0.056822,
      2,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      2,
      37,
      2,
      0,
      5,
      0,
      16.524086,
      1,
      1.553853,
      2,
      NULL,
      0.356718,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.858850,
      NULL,
      NULL,
      2.254072,
      NULL,
      NULL,
      0.810057,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.709588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116662,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.320934,
      6,
      6,
      0,
      0.684741,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.316605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.692756,
      0.389898,
      NULL,
      0.070658,
      1,
      3.499542,
      NULL,
      1.366189,
      2,
      2,
      3.698476,
      0,
      1.620016,
      0,
      NULL,
      NULL,
      NULL,
      1.877990,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.143052,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241433,
      3,
      1.253888,
      1.222069,
      NULL,
      NULL,
      5,
      1,
      2.543339,
      NULL,
      3,
      5,
      4.495992,
      3,
      3,
      3.734601,
      3,
      0,
      2.403760,
      3.165426,
      1,
      2,
      NULL,
      NULL,
      5.175589,
      0.564881,
      NULL,
      NULL,
      1.423018,
      2,
      1.098271,
      3,
      2.769092,
      1,
      2,
      1.314659,
      0.742526,
      1.001207,
      NULL,
      3.819085,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.202434,
      7,
      4,
      0,
      NULL,
      0,
      0,
      1.455569,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.920460,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.695373,
      NULL,
      NULL,
      1.022022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.444624,
      1,
      1.658367,
      0.236933,
      0.414485,
      0.046144,
      NULL,
      NULL,
      1.736521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730209,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.211105,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.942640,
      NULL,
      NULL,
      NULL,
      1.179630,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.695313,
      NULL,
      NULL,
      NULL,
      1.224418,
      33.295987,
      1,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      2.056631,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432350,
      NULL,
      1.033997,
      95.473384,
      571,
      1,
      1.944529,
      NULL,
      NULL,
      0.384844,
      0,
      NULL,
      0,
      0,
      0.929210,
      1.478511,
      1,
      0.748686,
      1.516181,
      0,
      1.533966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      2.140820,
      5.271665,
      1,
      3.594635,
      0.258590,
      0.830121,
      1.216753,
      0.714992,
      NULL,
      1.762904,
      1.343808,
      NULL,
      2,
      3.932395,
      NULL,
      1.448660,
      0,
      NULL,
      NULL,
      2.010129,
      NULL,
      1.057135,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.106748,
      2,
      NULL,
      1.824987,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.214262,
      NULL,
      NULL,
      0,
      1.400957,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.449748,
      4,
      8.397964,
      1,
      1.493126,
      1,
      11.002652,
      40,
      0,
      0,
      3,
      '40341',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


